/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.wfs_1_0_0.request;

import java.util.Iterator;
import org.gvsig.remoteclient.wfs.WFSProtocolHandler;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.edition.IWFSTOperation;
import org.gvsig.remoteclient.wfs.edition.WFSTDeleteOperation;
import org.gvsig.remoteclient.wfs.edition.WFSTInsertOperation;
import org.gvsig.remoteclient.wfs.edition.WFSTTransaction;
import org.gvsig.remoteclient.wfs.edition.WFSTUpdateOperation;
import org.gvsig.remoteclient.wfs.filters.filterencoding.FilterEncoding;
import org.gvsig.remoteclient.wfs.request.WFSTransactionRequest;

public class WFSTransactionRequest1_0_0
extends WFSTransactionRequest {
    public WFSTransactionRequest1_0_0(WFSStatus status, WFSProtocolHandler protocolHandler) {
        super(status, protocolHandler);
    }

    protected String getHttpGetRequest(String onlineResource) {
        return null;
    }

    protected String getHttpPostRequest(String onlineResource) {
        int i;
        StringBuffer request = new StringBuffer();
        this.addHttpPostHeaderRequest(request);
        WFSTTransaction transaction = this.status.getTransaction();
        for (i = 0; i < transaction.getInsertOperationSize(); ++i) {
            this.addInsertOperation(transaction.getInseOperationAt(i), request);
        }
        for (i = 0; i < transaction.getUpdateOperationSize(); ++i) {
            this.addUpdateOperation(transaction.getUpdateOperationAt(i), request);
        }
        if (transaction.getDeleteOperationSize() > 0) {
            WFSTDeleteOperation firstOperation = transaction.getDeleteOperationAt(0);
            this.addOperationHeader(firstOperation, request);
            FilterEncoding filterEncoding = new FilterEncoding(this.status);
            filterEncoding.setQualified(true);
            for (int i2 = 0; i2 < transaction.getDeleteOperationSize(); ++i2) {
                filterEncoding.addFeatureById(transaction.getDeleteOperationAt(i2).getId());
            }
            request.append(filterEncoding.toString(this.protocolHandler.getVersion()));
            this.addOperationEnd(firstOperation, request);
        }
        this.addHttpPostEndRequest(request);
        return request.toString();
    }

    private void addOperationHeader(IWFSTOperation operation, StringBuffer request) {
        request.append("<wfs:");
        request.append(operation.getOperationName());
        if (operation.hasTypeName()) {
            request.append(" typeName=\"" + this.status.getFeatureFullName() + "\"");
        }
        request.append(">");
    }

    private void addOperationEnd(IWFSTOperation operation, StringBuffer request) {
        request.append("</wfs:");
        request.append(operation.getOperationName() + ">");
    }

    private void addInsertOperation(WFSTInsertOperation insertOperation, StringBuffer request) {
        this.addOperationHeader(insertOperation, request);
        request.append(this.createXMLStartTag(this.status.getFeatureFullName()));
        Iterator it = insertOperation.getKeysIterator();
        while (it.hasNext()) {
            String attName = (String)it.next();
            request.append(this.createXMLStartTag(this.status.getNamespacePrefix() + ":" + attName));
            request.append(insertOperation.getValue(attName));
            request.append(this.createXMLEndtTag(this.status.getNamespacePrefix() + ":" + attName));
        }
        request.append(this.createXMLEndtTag(this.status.getFeatureFullName()));
        this.addOperationEnd(insertOperation, request);
    }

    private void addUpdateOperation(WFSTUpdateOperation updateOperation, StringBuffer request) {
        this.addOperationHeader(updateOperation, request);
        Iterator it = updateOperation.getKeysIterator();
        while (it.hasNext()) {
            String attName = (String)it.next();
            request.append(this.createXMLStartTag("wfs:Property"));
            request.append(this.createXMLStartTag("wfs:Name"));
            request.append(this.status.getNamespacePrefix() + ":" + attName);
            request.append(this.createXMLEndtTag("wfs:Name"));
            request.append(this.createXMLStartTag("wfs:Value"));
            request.append(updateOperation.getValue(attName));
            request.append(this.createXMLEndtTag("wfs:Value"));
            request.append(this.createXMLEndtTag("wfs:Property"));
        }
        FilterEncoding filterEncoding = new FilterEncoding(this.status);
        filterEncoding.setQualified(true);
        filterEncoding.addFeatureById(updateOperation.getId());
        request.append(filterEncoding.toString(this.protocolHandler.getVersion()));
        this.addOperationEnd(updateOperation, request);
    }

    private void addHttpPostHeaderRequest(StringBuffer request) {
        request.append("<?xml version=\"1.0\" ?>");
        request.append("<wfs:");
        request.append("Transaction ");
        request.append("version=\"" + this.protocolHandler.getVersion() + "\" ");
        request.append("releaseAction=\"ALL\" ");
        request.append("service=\"WFS\" ");
        request.append("xmlns:ogc");
        request.append("=\"http://www.opengis.net/ogc\" ");
        request.append("xmlns:wfs");
        request.append("=\"http://www.opengis.net/wfs\" ");
        request.append("xmlns:xsi");
        request.append("=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        request.append("xmlns:gml");
        request.append("=\"http://www.opengis.net/gml\" ");
        request.append("xmlns:" + this.status.getNamespacePrefix());
        request.append("=\"" + this.status.getNamespaceLocation() + "\" ");
        request.append("xsi:schemaLocation");
        request.append("=\"http://www.opengis.net/wfs ");
        request.append(this.getSchemaLocation());
        request.append("\">");
    }

    private void addHttpPostEndRequest(StringBuffer request) {
        request.append("</wfs:");
        request.append("Transaction>");
    }

    protected String getSchemaLocation() {
        return "../wfs/1.0.0/WFS-transaction.xsd";
    }
}

