/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.fieldstree;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.gvsig.wfs.gui.panels.fieldstree.CheckBoxNode;
import org.gvsig.wfs.gui.panels.fieldstree.FieldsTreeTable;

public class CheckBoxTreeCellRenderer
extends DefaultTreeCellRenderer {
    private JTree tree;
    private FieldsTreeTable treetable;

    public CheckBoxTreeCellRenderer(FieldsTreeTable treetable) {
        this.treetable = treetable;
        this.tree = (JTree)treetable.getTree();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object node;
        int[] rows = tree.getSelectionRows();
        TreePath path = tree.getPathForRow(row);
        if (path != null && (node = path.getLastPathComponent()) != null && node instanceof CheckBoxNode) {
            CheckBoxNode selectedNode = (CheckBoxNode)node;
            if (selectedNode.getParent() == null) {
                tree.expandRow(0);
            }
            if (selected) {
                selectedNode.setBackground(UIManager.getColor("Tree.selectionBackground"));
                if (hasFocus && !selectedNode.getFeatureField().isGeometry()) {
                    this.treetable.setApplicable(true);
                    selectedNode.setSelected(!selectedNode.isSelected());
                    selectedNode.setColor(0);
                }
            } else {
                selectedNode.setBackground(UIManager.getColor("Tree.textBackground"));
            }
            return selectedNode;
        }
        JLabel label = new JLabel(CheckBoxNode.fillNameWithBlancs("Feature"));
        return label;
    }
}

