/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.fieldstree;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.JTree;
import org.gvsig.gui.beans.controls.MultiLineToolTip;
import org.gvsig.gui.beans.swing.treeTable.TreeTable;
import org.gvsig.gui.beans.swing.treeTable.TreeTableModel;
import org.gvsig.gui.beans.swing.treeTable.TreeTableModelAdapter;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.wfs.gui.panels.WFSSelectFieldsPanel;
import org.gvsig.wfs.gui.panels.fieldstree.CheckBoxNode;
import org.gvsig.wfs.gui.panels.fieldstree.CheckBoxTreeCellEditor;
import org.gvsig.wfs.gui.panels.fieldstree.CheckBoxTreeCellRenderer;
import org.gvsig.wfs.gui.panels.fieldstree.FieldsTreeTableModel;

public class FieldsTreeTable
extends TreeTable {
    WFSSelectFieldsPanel parent = null;

    public FieldsTreeTable(FieldsTreeTableModel treeTableModel) {
        super((TreeTableModel)treeTableModel);
        JTree tree = (JTree)this.getTree();
        tree.setCellRenderer(new CheckBoxTreeCellRenderer(this));
        tree.setCellEditor(new CheckBoxTreeCellEditor(this));
        tree.setEditable(true);
    }

    public FieldsTreeTable(FieldsTreeTableModel treeTableModel, WFSSelectFieldsPanel parent) {
        super((TreeTableModel)treeTableModel);
        this.parent = parent;
        JTree tree = (JTree)this.getTree();
        tree.setCellRenderer(new CheckBoxTreeCellRenderer(this));
        tree.setCellEditor(new CheckBoxTreeCellEditor(this));
        tree.setEditable(true);
    }

    public void setFields(Vector vFields) {
        Object[] fields = new Object[vFields.size()];
        for (int i = 0; i < vFields.size(); ++i) {
            fields[i] = vFields.get(i);
        }
        this.setModel(new FieldsTreeTableModel(fields));
        this.deleteIcons();
        this.setRootVisible(false);
    }

    public Object[] getSelectedValues() {
        int[] selectedRows = this.getSelectedRows();
        TreeTableModelAdapter obj = (TreeTableModelAdapter)this.getModel();
        Object[] objects = new Object[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            objects[i] = obj.nodeForRow(selectedRows[i]);
        }
        return objects;
    }

    public WFSFeatureField[] getSelectedElements() {
        TreeTableModelAdapter obj = (TreeTableModelAdapter)this.getModel();
        ArrayList<WFSFeatureField> elements = new ArrayList<WFSFeatureField>();
        for (int i = 0; i < obj.getRowCount(); ++i) {
            CheckBoxNode node;
            if (!(obj.nodeForRow(i) instanceof CheckBoxNode) || !(node = (CheckBoxNode)obj.nodeForRow(i)).isSelected()) continue;
            WFSFeatureField featureField = node.getFeatureField();
            CheckBoxNode parentNode = node.getParentNode();
            if (parentNode == null) continue;
            elements.add(featureField);
        }
        WFSFeatureField[] selected = new WFSFeatureField[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            selected[i] = (WFSFeatureField)elements.get(i);
        }
        return selected;
    }

    public void setModel(FieldsTreeTableModel treeTableModel) {
        super.setModel((TreeTableModel)treeTableModel);
        JTree tree = (JTree)this.getTree();
        tree.setCellRenderer(new CheckBoxTreeCellRenderer(this));
        tree.setCellEditor(new CheckBoxTreeCellEditor(this));
        tree.setEditable(true);
    }

    public String getGeometryField() {
        TreeTableModelAdapter obj = (TreeTableModelAdapter)this.getModel();
        ArrayList elements = new ArrayList();
        for (int i = 0; i < obj.getRowCount(); ++i) {
            CheckBoxNode node;
            WFSFeatureField featureField;
            if (!(obj.nodeForRow(i) instanceof CheckBoxNode) || !(featureField = (node = (CheckBoxNode)obj.nodeForRow(i)).getFeatureField()).isGeometry()) continue;
            return featureField.getName();
        }
        return null;
    }

    public void setSelectedFields(List selectedFields) {
        int i;
        TreeTableModelAdapter obj = (TreeTableModelAdapter)this.getModel();
        JTree tree = (JTree)this.getTree();
        for (i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        for (i = 0; i < obj.getRowCount(); ++i) {
            if (!(obj.nodeForRow(i) instanceof CheckBoxNode)) continue;
            WFSFeatureField featureField = ((CheckBoxNode)obj.nodeForRow(i)).getFeatureField();
            for (int j = 0; j < selectedFields.size(); ++j) {
                if (!selectedFields.get(j).equals(featureField.getName())) continue;
                ((CheckBoxNode)obj.nodeForRow(i)).setSelected(true);
            }
        }
    }

    public void setApplicable(boolean applicable) {
        if (this.parent != null) {
            this.parent.setApplicable(applicable);
        }
    }

    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent((JComponent)((Object)this));
        return tip;
    }
}

