/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.ogr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.GeomFieldDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadRuntimeException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.gdal.prov.ogr.OGRConverter;
import org.gvsig.gdal.prov.ogr.OGRDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRFetureSetProvider;
import org.gvsig.gdal.prov.ogr.OGRUnsupportedFormatException;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OGRDataStoreProvider
extends AbstractFeatureStoreProvider
implements FeatureStoreProvider,
ResourceConsumer {
    protected static final Logger LOG = LoggerFactory.getLogger(OGRDataStoreProvider.class);
    public static final String METADATA_DEFINITION_NAME = "OGRDataStoreProvider";
    public static final String NAME = "OGRDataStoreProvider";
    public static final String DESCRIPTION = "OGR provider to open vectorial resources";
    protected DataSource dataSource;
    private Envelope envelope;
    private Layer newLayer;
    protected ResourceProvider resourceProvider;
    private Boolean updateSupport;
    private boolean opened = false;

    protected OGRDataStoreProvider(DataStoreParameters dataParameters, DataStoreProviderServices storeServices, DynObject metadata) throws InitializeException {
        super(dataParameters, storeServices, metadata);
        this.setDynValue("CRS", dataParameters.getDynValue("CRS"));
        this.getResource().addConsumer((ResourceConsumer)this);
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new InitializeException("OGRDataStoreProvider", (Throwable)e);
        }
    }

    protected OGRDataStoreProvider(DataStoreParameters dataParameters, DataStoreProviderServices storeServices) throws InitializeException {
        this(dataParameters, storeServices, FileHelper.newMetadataContainer((String)"OGRDataStoreProvider"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected DataSource getDataSource() throws OGRUnsupportedFormatException {
        if (this.dataSource == null) {
            Class<OGRDataStoreProvider> clazz = OGRDataStoreProvider.class;
            // MONITORENTER : org.gvsig.gdal.prov.ogr.OGRDataStoreProvider.class
            if (StringUtils.isNotBlank((CharSequence)this.getOGRParameters().getConnectionString())) {
                this.dataSource = ogr.Open((String)this.getOGRParameters().getConnectionString(), (int)1);
                if (this.dataSource == null) {
                    this.dataSource = ogr.Open((String)this.getOGRParameters().getConnectionString());
                    this.updateSupport = false;
                } else {
                    this.updateSupport = true;
                }
            } else {
                if (this.getOGRParameters().getFile() == null) throw new IllegalStateException("Invalid parameters. Connection string must not be blank or file must exists");
                if (!this.getOGRParameters().getFile().exists()) throw new IllegalStateException("Invalid parameters. Connection string must not be blank or file must exists");
                this.dataSource = ogr.Open((String)this.getOGRParameters().getFile().getAbsolutePath(), (int)1);
                if (this.dataSource == null) {
                    this.dataSource = ogr.Open((String)this.getOGRParameters().getFile().getAbsolutePath());
                    this.updateSupport = false;
                } else {
                    this.updateSupport = true;
                }
            }
            // MONITOREXIT : clazz
        }
        if (this.dataSource != null) return this.dataSource;
        if (!StringUtils.isNotBlank((CharSequence)this.getOGRParameters().getConnectionString())) return this.dataSource;
        throw new OGRUnsupportedFormatException(this.getOGRParameters().getConnectionString());
    }

    private Boolean hasUpdateSupport() throws OGRUnsupportedFormatException {
        if (this.updateSupport == null) {
            this.getDataSource();
        }
        return this.updateSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layer getLayer() throws OGRUnsupportedFormatException {
        if (this.newLayer == null) {
            DataSource dataSource = this.getDataSource();
            synchronized (dataSource) {
                String layerName = this.getOGRParameters().getLayerName();
                if (StringUtils.isBlank((CharSequence)layerName)) {
                    this.newLayer = this.getDataSource().GetLayer(0);
                    this.getOGRParameters().setLayerName(this.newLayer.GetName());
                } else {
                    this.newLayer = this.getDataSource().GetLayer(layerName);
                    if (this.newLayer == null) {
                        LOG.warn("Can not get layer with {} name. Get first layer of data source", (Object)this.getOGRParameters().getLayerName());
                        this.newLayer = this.getDataSource().GetLayer(0);
                        this.getOGRParameters().setLayerName(this.newLayer.GetName());
                    }
                }
            }
        }
        return this.newLayer;
    }

    public synchronized Envelope getEnvelope() throws DataException {
        this.open();
        if (this.envelope == null) {
            this.envelope = (Envelope)this.getResource().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    DataSource dataSource = OGRDataStoreProvider.this.getDataSource();
                    synchronized (dataSource) {
                        Layer layer = OGRDataStoreProvider.this.getLayer();
                        double[] extent = layer.GetExtent(true);
                        if (extent != null) {
                            return GeometryLocator.getGeometryManager().createEnvelope(extent[0], extent[2], extent[1], extent[3], 0);
                        }
                        Envelope tmpEnvelope = GeometryLocator.getGeometryManager().createEnvelope(0);
                        FeatureType featureType = OGRDataStoreProvider.this.getStoreServices().getDefaultFeatureType();
                        layer.ResetReading();
                        Feature feature = layer.GetNextFeature();
                        while (feature != null) {
                            double[] envelope = new double[4];
                            int geomFieldIndex = layer.GetLayerDefn().GetGeomFieldIndex(featureType.getDefaultGeometryAttributeName());
                            Geometry ogrGeometry = feature.GetGeomFieldRef(geomFieldIndex);
                            ogrGeometry.GetEnvelope(envelope);
                            tmpEnvelope.add(GeometryLocator.getGeometryManager().createEnvelope(envelope[0], envelope[2], envelope[1], envelope[3], 0));
                            feature = layer.GetNextFeature();
                        }
                        return tmpEnvelope;
                    }
                }
            });
        }
        return this.envelope;
    }

    public String getFullName() {
        StringBuilder stb = new StringBuilder();
        stb.append("OGRDataStoreProvider");
        stb.append(":");
        if (StringUtils.isBlank((CharSequence)this.getOGRParameters().getConnectionString())) {
            stb.append(this.getOGRParameters().getFile().getAbsolutePath());
            stb.append(":");
            stb.append(this.getOGRParameters().getLayerName());
        } else {
            stb.append(this.getOGRParameters().getConnectionString());
        }
        return stb.toString();
    }

    public String getName() {
        return this.getOGRParameters().getLayerName();
    }

    public String getProviderName() {
        return "OGRDataStoreProvider";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowWrite() {
        try {
            DataSource dataSource = this.getDataSource();
            synchronized (dataSource) {
                return this.getLayer().TestCapability("AlterFieldDefn") && this.getLayer().TestCapability("CreateField") && this.getLayer().TestCapability("DeleteField") && this.getLayer().TestCapability("DeleteFeature") && this.hasUpdateSupport() != false;
            }
        }
        catch (OGRUnsupportedFormatException e) {
            LOG.error("Can not determinate if data source allows write", (Throwable)((Object)e));
            return false;
        }
    }

    public ResourceProvider getResource() {
        if (this.resourceProvider == null) {
            if (StringUtils.isBlank((CharSequence)this.getOGRParameters().getConnectionString())) {
                try {
                    this.resourceProvider = this.createResource("file", new Object[]{this.getOGRParameters().getFile().getAbsolutePath()});
                }
                catch (InitializeException e) {
                    throw new ReadRuntimeException(String.format("Can not create file resource with %1s path", this.getOGRParameters().getFile().getAbsolutePath()), (Throwable)e);
                }
            }
            try {
                this.resourceProvider = this.createResource("OGRResource", new Object[]{this.getOGRParameters().getConnectionString()});
            }
            catch (InitializeException e) {
                throw new ReadRuntimeException(String.format("Can not create OGR resource with %1s", this.getOGRParameters().getConnectionString()), (Throwable)e);
            }
        }
        return this.resourceProvider;
    }

    public Object getSourceId() {
        return this.getOGRParameters().getFile();
    }

    public void open() throws OpenException {
        if (!this.opened) {
            try {
                this.opened = this.loadFeatureType();
            }
            catch (BaseException e) {
                LOG.error("Can not load feature type", (Throwable)e);
                throw new OpenException(this.getFullName(), (Throwable)e);
            }
        }
    }

    protected synchronized boolean loadFeatureType() throws OGRUnsupportedFormatException, GeometryTypeNotSupportedException, GeometryTypeNotValidException {
        return (Boolean)this.getResource().execute(new ResourceAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                DataSource dataSource = OGRDataStoreProvider.this.getDataSource();
                synchronized (dataSource) {
                    FeatureDefn featureDefn = OGRDataStoreProvider.this.getLayer().GetLayerDefn();
                    OGRConverter converter = new OGRConverter();
                    String defaultGeometryField = OGRDataStoreProvider.this.getOGRParameters().getDefaultGeometryField();
                    FeatureType featureType = converter.convert(featureDefn, defaultGeometryField);
                    if (featureType.getDefaultSRS() != null) {
                        OGRDataStoreProvider.this.setDynValue("CRS", featureType.getDefaultSRS());
                    }
                    ArrayList<FeatureType> featureTypes = new ArrayList<FeatureType>();
                    featureTypes.add(featureType);
                    OGRDataStoreProvider.this.getStoreServices().setFeatureTypes(featureTypes, featureType);
                    return true;
                }
            }
        });
    }

    public void performChanges(final Iterator deleteds, final Iterator inserteds, final Iterator updateds, final Iterator featureTypesChanged) throws DataException {
        this.getResource().execute(new ResourceAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                DataSource dataSource = OGRDataStoreProvider.this.getDataSource();
                synchronized (dataSource) {
                    FeatureProvider featureProvider;
                    OGRConverter converter = new OGRConverter();
                    if (OGRDataStoreProvider.this.getLayer().TestCapability("Transactions")) {
                        OGRDataStoreProvider.this.getLayer().StartTransaction();
                    }
                    while (featureTypesChanged.hasNext()) {
                        FeatureType.FeatureTypeChanged featureTypeChange = (FeatureType.FeatureTypeChanged)featureTypesChanged.next();
                        FeatureType source = featureTypeChange.getSource();
                        FeatureType target = featureTypeChange.getTarget();
                        for (int i = 0; i < source.getAttributeDescriptors().length; ++i) {
                            int index;
                            EditableFeatureAttributeDescriptor eAttDescriptor = source.getEditable().getEditableAttributeDescriptor(i);
                            if (eAttDescriptor.getOriginalName() != null) {
                                index = OGRDataStoreProvider.this.getLayer().GetLayerDefn().GetFieldIndex(eAttDescriptor.getOriginalName());
                                FieldDefn field = converter.convertField((FeatureAttributeDescriptor)eAttDescriptor);
                                OGRDataStoreProvider.this.getLayer().AlterFieldDefn(index, field, 7);
                                continue;
                            }
                            if (target.getAttributeDescriptor(eAttDescriptor.getName()) != null) continue;
                            index = OGRDataStoreProvider.this.getLayer().FindFieldIndex(eAttDescriptor.getName(), 1);
                            OGRDataStoreProvider.this.getLayer().DeleteField(index);
                        }
                        List<FieldDefn> fields = converter.convertFields(target);
                        for (FieldDefn fieldDefn : fields) {
                            int index = OGRDataStoreProvider.this.getLayer().GetLayerDefn().GetFieldIndex(fieldDefn.GetName());
                            if (index == -1) {
                                OGRDataStoreProvider.this.getLayer().CreateField(fieldDefn);
                                continue;
                            }
                            OGRDataStoreProvider.this.getLayer().AlterFieldDefn(index, fieldDefn, 7);
                        }
                        if (OGRDataStoreProvider.this.getLayer().TestCapability("CreateGeomField")) {
                            List<GeomFieldDefn> geometryFields = converter.convertGeometryFields(target, true);
                            for (GeomFieldDefn geomFieldDefn : geometryFields) {
                                int index = OGRDataStoreProvider.this.getLayer().GetLayerDefn().GetGeomFieldIndex(geomFieldDefn.GetName());
                                if (index != -1) continue;
                                OGRDataStoreProvider.this.getLayer().CreateGeomField(geomFieldDefn);
                            }
                            continue;
                        }
                        StringBuilder stb = new StringBuilder();
                        stb.append("Driver '");
                        stb.append(OGRDataStoreProvider.this.getDataSource().GetDriver().GetName());
                        stb.append("' does not support create geometry fields");
                        LOG.warn(stb.toString());
                    }
                    while (deleteds.hasNext()) {
                        FeatureReferenceProviderServices reference = (FeatureReferenceProviderServices)deleteds.next();
                        OGRDataStoreProvider.this.getLayer().DeleteFeature(((Integer)reference.getOID()).intValue());
                    }
                    while (inserteds.hasNext()) {
                        featureProvider = (FeatureProvider)inserteds.next();
                        OGRDataStoreProvider.this.getLayer().CreateFeature(converter.convert(featureProvider));
                    }
                    while (updateds.hasNext()) {
                        featureProvider = (FeatureProvider)updateds.next();
                        Feature ogrFeature = converter.convert(featureProvider);
                        OGRDataStoreProvider.this.getLayer().SetFeature(ogrFeature);
                    }
                    if (OGRDataStoreProvider.this.getLayer().TestCapability("Transactions")) {
                        OGRDataStoreProvider.this.getLayer().CommitTransaction();
                    }
                    OGRDataStoreProvider.this.getDataSource().SyncToDisk();
                    OGRDataStoreProvider.this.repack();
                    OGRDataStoreProvider.this.getResource().notifyChanges();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repack() throws OGRUnsupportedFormatException {
        LOG.debug("Running SQL: REPACK ".concat(this.getLayer().GetName()));
        DataSource dataSource = this.getDataSource();
        synchronized (dataSource) {
            this.getDataSource().ExecuteSQL("REPACK ".concat(this.getLayer().GetName()));
        }
    }

    public Object createNewOID() {
        try {
            return this.getFeatureCount() + 1L;
        }
        catch (DataException e) {
            LOG.error("Can't get feature count", (Throwable)e);
            throw new ReadRuntimeException(this.getFullName(), (Throwable)e);
        }
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType featureType) throws DataException {
        this.open();
        return new OGRFetureSetProvider(this, query, featureType);
    }

    public long getFeatureCount() throws DataException {
        this.open();
        return ((Number)this.getResource().execute(new ResourceAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                DataSource dataSource = OGRDataStoreProvider.this.getDataSource();
                synchronized (dataSource) {
                    int featureCount = OGRDataStoreProvider.this.getLayer().GetFeatureCount(0);
                    if (featureCount == -1) {
                        featureCount = OGRDataStoreProvider.this.getLayer().GetFeatureCount();
                    }
                    return featureCount;
                }
            }
        })).longValue();
    }

    public int getOIDType() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices providerServices, FeatureType featureType) throws DataException {
        DataSource dataSource = this.getDataSource();
        synchronized (dataSource) {
            int oid = (Integer)providerServices.getOID();
            if (this.dataSource.GetDriver().getName().equalsIgnoreCase("SQLite")) {
                ++oid;
            }
            Feature ogrFeature = this.getLayer().GetFeature(oid);
            int fid = ogrFeature.GetFID();
            DefaultFeatureProvider featureProvider = new DefaultFeatureProvider(featureType, (Object)fid);
            OGRConverter converter = new OGRConverter();
            featureProvider = converter.convert((FeatureProvider)featureProvider, featureType, ogrFeature);
            return featureProvider;
        }
    }

    private OGRDataStoreParameters getOGRParameters() {
        return (OGRDataStoreParameters)this.getParameters();
    }

    protected String compoundSelect(FeatureType type, Evaluator evaluator, FeatureQueryOrder featureQueryOrder) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        FeatureAttributeDescriptor[] attributeDescriptors = type.getAttributeDescriptors();
        for (int i = 0; i < attributeDescriptors.length; ++i) {
            query.append("\"");
            query.append(attributeDescriptors[i].getName());
            query.append("\"");
            if (i >= attributeDescriptors.length - 1) continue;
            query.append(",");
        }
        query.append(" FROM ");
        query.append("\"");
        query.append(this.getOGRParameters().getLayerName());
        query.append("\"");
        if (featureQueryOrder != null && featureQueryOrder.iterator().hasNext()) {
            query.append(" ORDER BY ");
            Iterator iterator = featureQueryOrder.iterator();
            while (iterator.hasNext()) {
                FeatureQueryOrder.FeatureQueryOrderMember member = (FeatureQueryOrder.FeatureQueryOrderMember)iterator.next();
                if (!member.hasEvaluator()) {
                    query.append("\"");
                    query.append(member.getAttributeName());
                    query.append("\"");
                }
                if (member.getAscending()) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                if (iterator.hasNext()) {
                    query.append(", ");
                    continue;
                }
                query.append(' ');
                break;
            }
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() throws BaseException {
        DataSource ds;
        DataSource dataSource = ds = this.getDataSource();
        synchronized (dataSource) {
            super.doDispose();
            this.getResource().removeConsumer((ResourceConsumer)this);
            this.resourceProvider = null;
            if (ds != null) {
                ds.delete();
            }
            this.envelope = null;
            this.newLayer = null;
            this.dataSource = null;
            this.opened = false;
            this.updateSupport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeResourceRequested(ResourceProvider resource) {
        try {
            DataSource dataSource = this.getDataSource();
            synchronized (dataSource) {
                this.getDataSource().delete();
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Can not close resource requested %1s", resource), (Throwable)e);
        }
        this.envelope = null;
        this.newLayer = null;
        this.dataSource = null;
        this.opened = false;
        this.updateSupport = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(ResourceProvider resource) {
        try {
            DataSource dataSource = this.getDataSource();
            synchronized (dataSource) {
                this.getDataSource().delete();
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Can not close resource requested %1s", resource), (Throwable)e);
        }
        this.envelope = null;
        this.newLayer = null;
        this.dataSource = null;
        this.opened = false;
        this.updateSupport = null;
    }
}

