/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json.serializers;

import java.util.Locale;
import javax.json.JsonObject;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.JsonObjectBuilderImpl;

public class LocaleSerializer
implements JsonManager.JsonSerializer {
    public Class getObjectClass() {
        return Locale.class;
    }

    public Object toObject(JsonObject json) {
        try {
            Locale locale = Locale.forLanguageTag(json.getString("languageTag"));
            return locale;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public JsonObjectBuilder toJsonBuilder(Object value) {
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl();
        builder.add_class(value);
        this.addAll(builder, value);
        return builder;
    }

    private void addAll(JsonObjectBuilder target, Object source) {
        Locale locale = (Locale)source;
        target.add("languageTag", locale.toLanguageTag());
    }
}

