/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.geodb.TableInfo;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ChangeListenerSupport;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.SupportIsEnable;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.ToolsUtilLocator;

public class TableInfoController
implements SupportIsEnable,
ChangeListenerSupport {
    public static final String CONFIGURABLE_PANEL_ID = "TableInfoController";
    private final ChangeListenerHelper changeListener;
    private JCheckBox chkVisible;
    private final JButton btnDeselectAllColumns;
    private final JButton btnSelectAllColumns;
    private final JList lstColumns;
    private final JTextField txtName;
    private final JComboBox cboIdField;
    private final JComboBox cboGeometryField;
    private final JTextField txtProjection;
    private final JButton btnProjection;
    private final JTextField txtFilter;
    private final JButton btnFilter;
    private final JButton btnFilterBookmarks;
    private final JButton btnFilterHistory;
    private final JButton btnAdvancedProperties;
    private final JLabel lblReadOnlyNotification;
    private JListWithCheckbox lwcColumns;
    private ProjectionPickerController pickerProjection;
    private ExpressionPickerController pickerFilter;
    private TableInfo tableInfo;
    private final JComponent pnlCfgActions;
    private final JButton btnChangeViewProjection;
    private MapContext mapContext;

    public TableInfoController(JButton btnDeselectAllColumns, JButton btnSelectAllColumns, JList lstColumns, JTextField txtName, JComboBox cboIdField, JComboBox cboGeometryField, JTextField txtProjection, JButton btnProjection, JTextField txtFilter, JButton btnFilter, JButton btnFilterBookmarks, JButton btnFilterHistory, JButton btnAdvancedProperties, JLabel lblReadOnlyNotification, JComponent pnlCfgActions, JButton btnChangeViewProjection) {
        this(btnDeselectAllColumns, btnSelectAllColumns, lstColumns, txtName, cboIdField, cboGeometryField, txtProjection, btnProjection, txtFilter, btnFilter, btnFilterBookmarks, btnFilterHistory, btnAdvancedProperties, lblReadOnlyNotification, pnlCfgActions, btnChangeViewProjection, null);
    }

    public TableInfoController(JButton btnDeselectAllColumns, JButton btnSelectAllColumns, JList lstColumns, JTextField txtName, JComboBox cboIdField, JComboBox cboGeometryField, JTextField txtProjection, JButton btnProjection, JTextField txtFilter, JButton btnFilter, JButton btnFilterBookmarks, JButton btnFilterHistory, JButton btnAdvancedProperties, JLabel lblReadOnlyNotification, JComponent pnlCfgActions, JButton btnChangeViewProjection, JCheckBox chkVisible) {
        this.btnDeselectAllColumns = btnDeselectAllColumns;
        this.btnSelectAllColumns = btnSelectAllColumns;
        this.lstColumns = lstColumns;
        this.txtName = txtName;
        this.cboIdField = cboIdField;
        this.cboGeometryField = cboGeometryField;
        this.txtProjection = txtProjection;
        this.btnProjection = btnProjection;
        this.txtFilter = txtFilter;
        this.btnFilter = btnFilter;
        this.btnFilterBookmarks = btnFilterBookmarks;
        this.btnFilterHistory = btnFilterHistory;
        this.btnAdvancedProperties = btnAdvancedProperties;
        this.lblReadOnlyNotification = lblReadOnlyNotification;
        this.pnlCfgActions = pnlCfgActions;
        this.btnChangeViewProjection = btnChangeViewProjection == null ? new JButton() : btnChangeViewProjection;
        this.chkVisible = chkVisible == null ? new JCheckBox() : chkVisible;
        this.changeListener = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        if (this.pnlCfgActions != null) {
            ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
            JComponent c = cfgActionsManager.getConfigurableActionsComponent(CONFIGURABLE_PANEL_ID, (Object)this);
            this.pnlCfgActions.setLayout(new BorderLayout(0, 0));
            this.pnlCfgActions.add((Component)c, "Center");
        }
        toolsSwingManager.translate((AbstractButton)this.btnDeselectAllColumns);
        toolsSwingManager.translate((AbstractButton)this.btnSelectAllColumns);
        toolsSwingManager.translate((AbstractButton)this.btnAdvancedProperties);
        toolsSwingManager.addClearButton((JTextComponent)this.txtName);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtName);
        this.lwcColumns = toolsSwingManager.createJListWithCheckbox(this.lstColumns);
        this.pickerProjection = dataSwingManager.createProjectionPickerController(this.txtProjection, this.btnProjection);
        this.pickerFilter = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtFilter, this.btnFilter, this.btnFilterBookmarks, this.btnFilterHistory);
        this.pickerProjection.addChangeListener(e -> this.doChangeProjection());
        this.btnChangeViewProjection.addActionListener(e -> this.doChangeViewProjection());
        this.cboIdField.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.doChangeIdField();
            }
        });
        this.cboGeometryField.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.doChangeGeometryField();
                this.updateLabel();
                this.changeListener.fireEvent();
            }
        });
        this.btnDeselectAllColumns.addActionListener(e -> this.doDeselectAllColumns());
        this.btnSelectAllColumns.addActionListener(e -> this.doSelectAllColumns());
        this.btnAdvancedProperties.addActionListener(e -> this.doShowAdvancedProperties());
        this.btnSelectAllColumns.setCursor(Cursor.getPredefinedCursor(12));
        this.btnDeselectAllColumns.setCursor(Cursor.getPredefinedCursor(12));
        this.btnProjection.setCursor(Cursor.getPredefinedCursor(12));
        this.btnFilter.setCursor(Cursor.getPredefinedCursor(12));
        this.btnFilterBookmarks.setCursor(Cursor.getPredefinedCursor(12));
        this.btnFilterHistory.setCursor(Cursor.getPredefinedCursor(12));
        this.btnAdvancedProperties.setCursor(Cursor.getPredefinedCursor(12));
    }

    protected TableInfo getTableInfo() {
        return this.tableInfo;
    }

    private void doChangeIdField() {
        TableInfo info = this.getCurrentTableInfo();
        if (info == null) {
            return;
        }
        info.setIdFieldSelected(this.cboIdField.getSelectedIndex());
        this.updateLabel();
        this.changeListener.fireEvent();
    }

    private void doChangeProjection() {
        TableInfo info = this.getCurrentTableInfo();
        if (info == null) {
            return;
        }
        info.setProjection((IProjection)this.pickerProjection.get());
        this.updateChangeViewProjection();
        this.updateLabel();
        this.changeListener.fireEvent();
    }

    private void doChangeGeometryField() {
        TableInfo info = this.getCurrentTableInfo();
        if (info == null) {
            return;
        }
        String attrName = (String)this.cboGeometryField.getSelectedItem();
        info.setGeomFieldSelected(this.cboGeometryField.getSelectedIndex());
        if (StringUtils.isBlank((CharSequence)attrName)) {
            this.pickerProjection.set(null);
            return;
        }
        FeatureAttributeDescriptor attr = info.getAttributeDescriptor(attrName);
        IProjection srs = attr.getSRS();
        if (srs == null) {
            return;
        }
        this.pickerProjection.set((Object)srs);
        this.tableInfo.setProjection((IProjection)this.pickerProjection.get());
        if (this.tableInfo.getGeometryType() == -1) {
            this.tableInfo.setGeometryType(attr.getGeomType().getType());
        }
        if (this.tableInfo.getGeometrySubtype() == 4) {
            this.tableInfo.setGeometrySubtype(attr.getGeomType().getSubType());
        }
    }

    private void doDeselectAllColumns() {
        TableInfo info = this.getCurrentTableInfo();
        if (info == null) {
            return;
        }
        info.getColumnChecksModel().clearSelection();
    }

    private void doSelectAllColumns() {
        TableInfo info = this.getCurrentTableInfo();
        if (info == null) {
            return;
        }
        info.getColumnChecksModel().setSelectionInterval(0, info.getAttributeDescriptors().size());
    }

    private void doShowAdvancedProperties() {
        TableInfo info = this.getCurrentTableInfo();
        if (info == null) {
            return;
        }
        this.fetch(info);
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DataStoreParametersPanelManager paramsPanelManager = DALSwingLocator.getDataStoreParametersPanelManager();
        DataStoreParametersPanel panel = paramsPanelManager.createDataStoreParametersPanel((DynObject)info.getParameters());
        Dialog dialog = winmgr.createDialog(panel.asJComponent(), i18n.getTranslation("_Connection_parameters"), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                JDBCStoreParameters parameters = info.getParameters();
                panel.fetchParameters((DynObject)parameters);
                info.fetch(parameters);
                this.put(info);
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public void put(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        boolean enableEvents = this.changeListener.isEnabledEvents();
        try {
            this.changeListener.setEnabledEvents(false);
            if (tableInfo == null) {
                this.lwcColumns.setModel(new DefaultListModel());
                this.lwcColumns.setCheckedModel((ListSelectionModel)new DefaultListSelectionModel());
                this.txtName.setText("");
                this.cboGeometryField.setModel(new DefaultComboBoxModel());
                this.cboIdField.setModel(new DefaultComboBoxModel());
                this.pickerProjection.set(null);
                this.pickerFilter.set(null);
                this.chkVisible.setSelected(true);
                if (this.lblReadOnlyNotification != null) {
                    this.lblReadOnlyNotification.setText("");
                }
                this.btnChangeViewProjection.setEnabled(false);
            } else {
                this.lwcColumns.setModel(tableInfo.getColumnsListModel());
                this.lwcColumns.setCheckedModel(tableInfo.getColumnChecksModel());
                this.txtName.setText(tableInfo.getDocumentName());
                this.cboGeometryField.setModel(tableInfo.getGeomFieldComboModel());
                this.cboGeometryField.setSelectedIndex(tableInfo.getGeomFieldSelected());
                this.cboIdField.setModel(tableInfo.getIdFieldComboModel());
                this.cboIdField.setSelectedIndex(tableInfo.getIdFieldSelected());
                this.pickerProjection.set((Object)tableInfo.getProjection());
                this.pickerFilter.set((Object)tableInfo.getFilter());
                this.chkVisible.setSelected(BooleanUtils.toBooleanDefaultIfNull((Boolean)tableInfo.getVisible(), (boolean)true));
            }
        }
        finally {
            this.changeListener.setEnabledEvents(enableEvents);
        }
        this.updateChangeViewProjection();
        this.updateLabel();
        this.changeListener.fireEvent();
    }

    private void updateLabel() throws LocatorException {
        if (this.tableInfo == null) {
            if (this.lblReadOnlyNotification != null) {
                this.lblReadOnlyNotification.setText("");
            }
            return;
        }
        if (this.lblReadOnlyNotification != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("<html>");
            builder.append("<font color='#00008B'>");
            this.updateLabel(builder);
            builder.append("</font>");
            builder.append("</html>");
            this.lblReadOnlyNotification.setText(builder.toString());
        }
    }

    protected void updateLabel(StringBuilder builder) throws LocatorException {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (this.tableInfo.isView()) {
            builder.append(i18n.getTranslation("_View"));
        } else {
            builder.append(i18n.getTranslation("_Table"));
        }
        boolean readOnly = this.tableInfo.isReadOnly();
        if (readOnly) {
            builder.append(" - <b>");
            builder.append(i18n.getTranslation("_Read_only"));
            builder.append("</b>");
        }
        if (StringUtils.isBlank((CharSequence)this.tableInfo.getFieldId())) {
            builder.append(" - ");
            builder.append(i18n.getTranslation("_PrimaryKey_field_recommended"));
        }
        if (this.tableInfo.requireGeometry()) {
            FeatureType featType = this.tableInfo.getFeatureType();
            if (StringUtils.isBlank((CharSequence)this.tableInfo.getGeomField())) {
                builder.append(" - <b>");
                builder.append(i18n.getTranslation("_Geometry_field_required"));
                builder.append("</b>");
            }
            if (this.tableInfo.getGeometryType() == 16 || this.tableInfo.getGeometryType() == -1) {
                builder.append(" - <b>");
                builder.append(i18n.getTranslation("_GeometryType_required"));
                builder.append("</b>");
            }
            if (this.tableInfo.getGeometrySubtype() == 4) {
                builder.append(" - <b>");
                builder.append(i18n.getTranslation("_GeometrySubType_required"));
                builder.append("</b>");
            }
            if (this.tableInfo.getProjection() == null) {
                builder.append(" - ");
                builder.append(i18n.getTranslation("_Projection_recommended"));
            } else if (this.mapContext != null && !this.tableInfo.getProjection().equals(this.mapContext.getProjection())) {
                builder.append(" - ");
                builder.append(i18n.getTranslation("_reprojected_on_the_fly"));
            }
        } else {
            FeatureType featType = this.tableInfo.getFeatureType();
            if (StringUtils.isNotBlank((CharSequence)this.tableInfo.getGeomField())) {
                if (this.tableInfo.getGeometryType() == 16 || this.tableInfo.getGeometryType() == -1) {
                    builder.append(" - ");
                    builder.append(i18n.getTranslation("_GeometryType_recommended"));
                }
                if (this.tableInfo.getGeometrySubtype() == 4) {
                    builder.append(" - ");
                    builder.append(i18n.getTranslation("_GeometrySubType_recommended"));
                }
                if (StringUtils.isNotBlank((CharSequence)this.tableInfo.getGeomField()) && this.tableInfo.getProjection() == null) {
                    builder.append(" - ");
                    builder.append(i18n.getTranslation("_Projection_recommended"));
                }
                if (this.mapContext != null && this.tableInfo.getProjection() != null && !this.tableInfo.getProjection().equals(this.mapContext.getProjection())) {
                    builder.append(" - ");
                    builder.append(i18n.getTranslation("_reprojected_on_the_fly"));
                }
            }
        }
    }

    public void fetch(TableInfo tableInfo) {
        tableInfo.setIdFieldSelected(this.cboIdField.getSelectedIndex());
        tableInfo.setGeomFieldSelected(this.cboGeometryField.getSelectedIndex());
        tableInfo.setFilter(this.pickerFilter.get());
        tableInfo.setVisible(this.chkVisible.isSelected());
        tableInfo.setProjection((IProjection)this.pickerProjection.get());
        tableInfo.setDocumentName(this.txtName.getText());
    }

    private TableInfo getCurrentTableInfo() {
        return this.tableInfo;
    }

    public void setEditable(boolean enable) {
        this.lstColumns.setEnabled(enable);
        this.txtName.setEditable(enable);
        this.cboGeometryField.setEnabled(enable);
        this.cboIdField.setEnabled(enable);
        this.pickerProjection.setEditable(enable);
        this.pickerFilter.setEditable(enable);
        this.btnDeselectAllColumns.setEnabled(enable);
        this.btnSelectAllColumns.setEnabled(enable);
        this.btnAdvancedProperties.setEnabled(enable);
    }

    public void setEnabled(boolean enable) {
        this.lstColumns.setEnabled(enable);
        this.txtName.setEnabled(enable);
        this.cboGeometryField.setEnabled(enable);
        this.cboIdField.setEnabled(enable);
        this.pickerProjection.setEnabled(enable);
        this.pickerFilter.setEnabled(enable);
        this.btnDeselectAllColumns.setEnabled(enable);
        this.btnSelectAllColumns.setEnabled(enable);
        this.btnAdvancedProperties.setEnabled(enable);
    }

    public String getId() {
        if (this.tableInfo == null) {
            return null;
        }
        return this.getCurrentTableInfo().getId();
    }

    public void clear() {
        this.put(null);
    }

    public boolean isEnabled(Object component) {
        try {
            if (component instanceof RemoveDALInformationAction) {
                TableInfo info = this.getCurrentTableInfo();
                if (info == null) {
                    return false;
                }
                this.fetch(info);
                return info.existsDALInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void selfRegister() {
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        cfgActionsManager.addConfigurableAction(CONFIGURABLE_PANEL_ID, (Action)new RemoveDALInformationAction());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListener.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListener.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListener.hasChangeListeners();
    }

    public void setMapContext(MapContext mapContext) {
        this.mapContext = mapContext;
    }

    private void updateChangeViewProjection() {
        if (this.tableInfo == null || !this.tableInfo.requireGeometry() || this.mapContext == null) {
            this.btnChangeViewProjection.setEnabled(false);
            return;
        }
        if (!this.mapContext.getLayers().isEmpty()) {
            this.btnChangeViewProjection.setEnabled(false);
            return;
        }
        IProjection projection = (IProjection)this.pickerProjection.get();
        if (projection == null) {
            this.btnChangeViewProjection.setEnabled(false);
            return;
        }
        if (projection.equals(this.mapContext.getProjection())) {
            this.btnChangeViewProjection.setEnabled(false);
        } else {
            this.btnChangeViewProjection.setEnabled(true);
        }
    }

    private void doChangeViewProjection() {
        if (this.tableInfo == null || !this.tableInfo.requireGeometry() || this.mapContext == null) {
            return;
        }
        if (!this.mapContext.getLayers().isEmpty()) {
            return;
        }
        IProjection projection = (IProjection)this.pickerProjection.get();
        if (projection == null) {
            return;
        }
        this.mapContext.setProjection(projection);
        this.updateChangeViewProjection();
        this.updateLabel();
    }

    public static class RemoveDALInformationAction
    extends AbstractAction {
        public RemoveDALInformationAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Remove_metadata"));
            this.putValue("ActionCommandKey", "RemoveDALInformation");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Remove_metadata");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableInfoController controller = (TableInfoController)e.getSource();
            TableInfo info = controller.getCurrentTableInfo();
            if (info == null) {
                return;
            }
            controller.fetch(info);
            info.removeDALInfo();
            controller.put(info);
        }
    }
}

