/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb.databaseworkspace;

import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.geodb.databaseworkspace.ConnectToDatabaseWorkspacePanelView;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;

public class ConnectToDatabaseWorkspacePanel
extends ConnectToDatabaseWorkspacePanelView
implements Component {
    private Dialog dialog;
    private PickerController<JDBCServerExplorerParameters> connectionPicker;

    public ConnectToDatabaseWorkspacePanel() {
        this.initComponents();
    }

    public boolean connect() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        JDBCServerExplorerParameters conn = this.getConnection();
        if (conn == null) {
            return false;
        }
        return dataSwingManager.connectToDatabaseWorkspace(conn);
    }

    public void disconnect() {
        String id = this.getID();
        DataManager dataManager = DALLocator.getDataManager();
        DatabaseWorkspaceManager workspace = dataManager.getDatabaseWorkspace(id);
        if (workspace != null) {
            workspace.disconnect();
        }
    }

    private void initComponents() {
        this.connectionPicker = DALSwingLocator.getSwingManager().createJDBCConnectionPickerController(this.cboConnection, this.btnConnection);
        this.connectionPicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConnectToDatabaseWorkspacePanel.this.doUpdateStoresRepositoryInfo();
            }
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)7, (int)110, (int)10, (int)160);
        this.doUpdateStoresRepositoryInfo();
    }

    public JComponent asJComponent() {
        return this;
    }

    public JDBCServerExplorerParameters getConnection() {
        JDBCServerExplorerParameters conn = (JDBCServerExplorerParameters)this.connectionPicker.get();
        if (conn == null) {
            return null;
        }
        DataManager dataManager = DALLocator.getDataManager();
        DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)conn);
        if (!workspace.isValidStoresRepository()) {
            return null;
        }
        return conn;
    }

    private void doUpdateEnableComponents() {
        boolean theEnabled;
        DataManager dataManager = DALLocator.getDataManager();
        boolean bl = theEnabled = this.getConnection() != null;
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, theEnabled);
            String id = this.getID();
            this.dialog.setButtonEnabled(4, dataManager.getDatabaseWorkspace(id) != null);
        }
    }

    private void doUpdateStoresRepositoryInfo() {
        if (this.getConnection() != null) {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters conn = this.getConnection();
            DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)conn);
            String id = workspace.get("StoresRepository.id");
            String label = workspace.get("StoresRepository.label");
            String url = conn.getUrl();
            this.txtID.setText((String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)""));
            this.txtLabel.setText((String)StringUtils.defaultIfBlank((CharSequence)label, (CharSequence)""));
            this.txtUrl.setText((String)StringUtils.defaultIfBlank((CharSequence)url, (CharSequence)""));
            this.connectionPicker.set((Object)conn);
        } else {
            this.txtID.setText("");
            this.txtLabel.setText("");
            this.txtUrl.setText("");
            this.connectionPicker.set(null);
        }
        this.doUpdateEnableComponents();
    }

    public String getID() {
        return this.txtID.getText();
    }

    public String getLabel() {
        return this.txtLabel.getText();
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateEnableComponents();
    }
}

