/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb.vectorialdb.visibility;

import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.db.DBStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.geodb.ExtDB_Spatial;
import org.gvsig.geodb.vectorialdb.visibility.LayerScaleVisibility;
import org.gvsig.geodb.vectorialdb.visibility.VisibilityScaleSelector;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.reminder.DialogReminderManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerScaleVisibilityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayerScaleVisibilityUtils.class);
    public static final int NUMBER_OF_FEATURES_TO_ASK_FOR_VISIBILITY_SCALE = 10000;
    public static final String LAYERS_SCALE_VISIBILITY_PARAMETER = "layersScaleVisibility";

    public static void initPluginProperties() {
        PluginsManager pluginManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginManager.getPlugin(ExtDB_Spatial.class);
        DynObject pluginProperties = plugin.getPluginProperties();
        HashMap layersScaleVisibility = new HashMap();
        Map tmp = (Map)pluginProperties.getDynValue(LAYERS_SCALE_VISIBILITY_PARAMETER);
        if (tmp != null) {
            layersScaleVisibility.putAll(tmp);
        }
        pluginProperties.setDynValue(LAYERS_SCALE_VISIBILITY_PARAMETER, layersScaleVisibility);
    }

    public static void checkForVisibilityScale(FLayer layer) throws DataException, ValidateDataParametersException {
        LayerScaleVisibilityUtils.checkForVisibilityScale(layer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForVisibilityScale(FLayer layer, boolean checkScale) throws DataException, ValidateDataParametersException {
        LayerScaleVisibility layerScaleVisibility;
        if (layer.getMaxScale() >= 0.0 && layer.getMinScale() >= 0.0) {
            return;
        }
        PluginsManager pluginManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginManager.getPlugin(ExtDB_Spatial.class);
        DynObject pluginProperties = plugin.getPluginProperties();
        Map layersScaleVisibility = (Map)pluginProperties.getDynValue(LAYERS_SCALE_VISIBILITY_PARAMETER);
        String layerKey = LayerScaleVisibilityUtils.buildLayerKey(layer);
        if (layerKey != null && (layerScaleVisibility = (LayerScaleVisibility)layersScaleVisibility.get(layerKey)) != null) {
            int scaleAboveDenominator = layerScaleVisibility.getScaleAboveDenominator();
            int scaleBelowDenominator = layerScaleVisibility.getScaleBelowDenominator();
            layer.setMaxScale((double)scaleAboveDenominator);
            layer.setMinScale((double)scaleBelowDenominator);
            return;
        }
        if (!checkScale) {
            return;
        }
        DialogReminderManager dialogReminder = ToolsSwingLocator.getDialogReminderManager();
        if (dialogReminder.exists("_Do_not_ask_the_scale_again")) {
            return;
        }
        if (layer instanceof FLyrVect) {
            FLyrVect lyrVect = (FLyrVect)layer;
            FeatureStore store = lyrVect.getFeatureStore();
            DataServerExplorer explorer = null;
            try {
                explorer = store.getExplorer();
                if (explorer instanceof JDBCServerExplorer) {
                    FeatureSet fset = store.getFeatureSet();
                    if (fset.size() > 10000) {
                        LayerScaleVisibilityUtils.askUserForVisibilityScale(layer);
                    }
                    DisposeUtils.disposeQuietly((Disposable)fset);
                }
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)explorer);
            }
        }
    }

    private static void askUserForVisibilityScale(FLayer layer) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> LayerScaleVisibilityUtils.askUserForVisibilityScale(layer));
            }
            catch (Exception ex) {
                LOGGER.warn("Con show selection wisivility scale dialog.", (Throwable)ex);
            }
            return;
        }
        DialogReminderManager dialogReminder = ToolsSwingLocator.getDialogReminderManager();
        if (dialogReminder.exists("_Do_not_ask_the_scale_again")) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        VisibilityScaleSelector visibilityScaleSelector = new VisibilityScaleSelector();
        Dialog dialog = winManager.createDialog(visibilityScaleSelector.asJComponent(), i18n.getTranslation("_Select_visibility_scale") + " - " + layer.getName(), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                layer.setMaxScale((double)visibilityScaleSelector.getScaleAboveDenominator());
                layer.setMinScale((double)visibilityScaleSelector.getScaleBelowDenominator());
                if (visibilityScaleSelector.getRememberAnswer()) {
                    PluginsManager pluginManager = PluginsLocator.getPluginsManager();
                    PluginServices plugin = pluginManager.getPlugin(ExtDB_Spatial.class);
                    DynObject pluginProperties = plugin.getPluginProperties();
                    String layerKey = LayerScaleVisibilityUtils.buildLayerKey(layer);
                    String layerLabel = LayerScaleVisibilityUtils.buildLayerLabel(layer);
                    if (layerKey != null && layerLabel != null) {
                        Map layersScaleVisibility = (Map)pluginProperties.getDynValue(LAYERS_SCALE_VISIBILITY_PARAMETER);
                        LayerScaleVisibility layerScaleVisibility = new LayerScaleVisibility();
                        layerScaleVisibility.setScaleAboveDenominator(visibilityScaleSelector.getScaleAboveDenominator());
                        layerScaleVisibility.setScaleBelowDenominator(visibilityScaleSelector.getScaleBelowDenominator());
                        layerScaleVisibility.setLabel(layerLabel);
                        layersScaleVisibility.put(layerKey, layerScaleVisibility);
                    }
                }
            }
            if (visibilityScaleSelector.getDoNotAskScaleAgain()) {
                dialogReminder.add("_Do_not_ask_the_scale_again", 1);
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private static String buildLayerKey(FLayer layer) {
        DataStoreParameters parameters;
        DataStore dataStore;
        if (layer != null && (dataStore = ((FLyrVect)layer).getDataStore()) != null && (parameters = dataStore.getParameters()) != null) {
            return Hex.encodeHexString((byte[])parameters.toByteArray());
        }
        return null;
    }

    private static String buildLayerLabel(FLayer layer) {
        DataStore dataStore;
        if (layer != null && (dataStore = ((FLyrVect)layer).getDataStore()) != null) {
            StringBuilder builder = new StringBuilder();
            DataStoreParameters parameters = dataStore.getParameters();
            if (parameters != null && parameters instanceof DBStoreParameters) {
                JDBCStoreParameters jdbcParameters = (JDBCStoreParameters)parameters;
                builder.append(jdbcParameters.getDBName());
                builder.append(".");
                builder.append(jdbcParameters.getSchema());
                builder.append(".");
                builder.append(jdbcParameters.getTable());
                return builder.toString();
            }
        }
        return null;
    }
}

