/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb.vectorialdb.visibility.preferences;

import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bouncycastle.util.StoreException;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.geodb.ExtDB_Spatial;
import org.gvsig.geodb.vectorialdb.visibility.LayerScaleVisibility;
import org.gvsig.geodb.vectorialdb.visibility.preferences.LayersVisibilityReminderView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class LayersVisibilityReminderPage
extends LayersVisibilityReminderView
implements IPreference {
    private JListWithCheckbox lstCheckdsRemembers;
    public static String id = LayersVisibilityReminderPage.class.getName();
    private ImageIcon icon;

    public LayersVisibilityReminderPage() {
        this.initComponents();
    }

    private void initComponents() {
        this.icon = IconThemeHelper.getImageIcon((String)"layers-visibility-remember-preferences");
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        this.lstCheckdsRemembers = swingManager.createJListWithCheckbox(this.lstRemembers);
        final ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        checkModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int n = e.getFirstIndex();
                if (n <= LayersVisibilityReminderPage.this.lstCheckdsRemembers.getModel().getSize()) {
                    return;
                }
                LayersScaleVisibilityListElement element = (LayersScaleVisibilityListElement)((Object)LayersVisibilityReminderPage.this.lstCheckdsRemembers.getModel().getElementAt(n));
                if (element == null) {
                    return;
                }
                if (checkModel.isSelectedIndex(n) && element.getValue() != null) {
                    checkModel.removeIndexInterval(n, n);
                }
            }
        });
        this.translateAll();
    }

    private void translateAll() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.lblTitle.setText(i18n.getTranslation(this.lblTitle.getText()));
    }

    public boolean isResizeable() {
        return true;
    }

    public void initializeValues() {
        Map<String, LayerScaleVisibility> layersScaleVisibility = this.getLayersScaleVisibility();
        DefaultListModel<LayersScaleVisibilityListElement> model = new DefaultListModel<LayersScaleVisibilityListElement>();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        checkModel.clearSelection();
        int n = 0;
        for (Map.Entry<String, LayerScaleVisibility> entry : layersScaleVisibility.entrySet()) {
            model.addElement(new LayersScaleVisibilityListElement(entry.getKey(), entry));
            if (entry.getValue() != null) {
                checkModel.addSelectionInterval(n, n);
            }
            ++n;
        }
        this.lstCheckdsRemembers.setModel(model);
    }

    private Map<String, LayerScaleVisibility> getLayersScaleVisibility() throws DynFieldNotFoundException, LocatorException {
        PluginsManager pluginManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginManager.getPlugin(ExtDB_Spatial.class);
        DynObject pluginProperties = plugin.getPluginProperties();
        Map layersScaleVisibility = (Map)pluginProperties.getDynValue("layersScaleVisibility");
        return layersScaleVisibility;
    }

    public void initializeDefaults() {
        Map<String, LayerScaleVisibility> layersScaleVisibility = this.getLayersScaleVisibility();
        DefaultListModel<LayersScaleVisibilityListElement> model = new DefaultListModel<LayersScaleVisibilityListElement>();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        for (Map.Entry<String, LayerScaleVisibility> entry : layersScaleVisibility.entrySet()) {
            model.addElement(new LayersScaleVisibilityListElement(entry.getKey(), entry));
        }
        this.lstCheckdsRemembers.setModel(model);
        checkModel.clearSelection();
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Remembered_layers_visibility");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        Map<String, LayerScaleVisibility> layersScaleVisibility = this.getLayersScaleVisibility();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        int n = 0;
        for (Map.Entry<String, LayerScaleVisibility> entry : layersScaleVisibility.entrySet()) {
            if (!checkModel.isSelectedIndex(n)) {
                layersScaleVisibility.remove(entry.getKey());
            }
            ++n;
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        Map<String, LayerScaleVisibility> layersScaleVisibility = this.getLayersScaleVisibility();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        int n = 0;
        for (Map.Entry<String, LayerScaleVisibility> entry : layersScaleVisibility.entrySet()) {
            if (checkModel.isSelectedIndex(n) != (entry.getValue() != null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setChangesApplied() {
    }

    private class LayersScaleVisibilityListElement
    extends ListElement<Map.Entry<String, LayerScaleVisibility>> {
        public LayersScaleVisibilityListElement(String label, Map.Entry<String, LayerScaleVisibility> value) {
            super(label, value);
        }

        public String getLabel() {
            LayerScaleVisibility layerScaleVisibility;
            Map.Entry entry = (Map.Entry)this.getValue();
            if (entry != null && (layerScaleVisibility = (LayerScaleVisibility)entry.getValue()) != null) {
                return layerScaleVisibility.getLabel();
            }
            return null;
        }
    }
}

