/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.dataStoreParameters;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelFactory;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.fmap.dal.swing.impl.dataStoreParameters.DataStoreDynObjectParametersPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStoreParametersPanelManager
implements DataStoreParametersPanelManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultDataStoreParametersPanelManager.class);
    private List<DataStoreParametersPanelFactory> factories = new ArrayList<DataStoreParametersPanelFactory>();

    public void registerFactory(DataStoreParametersPanelFactory factory) {
        if (this.factories.contains(factory)) {
            return;
        }
        this.factories.add(factory);
    }

    public DataStoreParametersPanelFactory getFactory(DynObject parameters) {
        DataStoreParametersPanelFactory factory = null;
        for (DataStoreParametersPanelFactory currentFactory : this.factories) {
            if (!currentFactory.canBeApplied(parameters)) continue;
            if (factory == null) {
                factory = currentFactory;
                continue;
            }
            if (factory.getPriority() >= currentFactory.getPriority()) continue;
            factory = currentFactory;
        }
        return factory;
    }

    public DataStoreParametersPanel createDataStoreParametersPanel(DynObject parameters) {
        DataStoreParametersPanelFactory factory = this.getFactory(parameters);
        if (factory == null) {
            return null;
        }
        return factory.create(parameters);
    }

    public int showPropertiesDialog(DynObject parameters) {
        DataStoreParametersPanel panel = this.createDataStoreParametersPanel(parameters);
        return this.showPropertiesDialog(parameters, panel);
    }

    public int showPropertiesDialog(DynObject parameters, DataStoreParametersPanel panel) {
        return this.showPropertiesDialog(parameters, panel, WindowManager.MODE.DIALOG);
    }

    public int showPropertiesDialog(DynObject parameters, DataStoreParametersPanel panel, WindowManager.MODE showMode) {
        Dialog dialog = this.createPropertiesDialog(parameters, panel);
        dialog.addActionListener(ae -> {
            switch (ae.getID()) {
                case 4: {
                    panel.fetchParameters(parameters);
                    this.showAdvancedPropertiesDialog(parameters);
                    break;
                }
                case 1: {
                    panel.fetchParameters(parameters);
                    break;
                }
            }
        });
        dialog.show(showMode);
        return dialog.getAction();
    }

    public Dialog createPropertiesDialog(DynObject parameters, DataStoreParametersPanel panel) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String title = parameters.getDynClass().getDescription();
        if (StringUtils.isBlank((CharSequence)title)) {
            title = parameters.getDynClass().getName();
        }
        if (title.startsWith("_")) {
            title = i18n.getTranslation(title);
        }
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winmanager.createDialog(panel.asJComponent(), title, null, 7);
        if (panel instanceof DataStoreDynObjectParametersPanel) {
            dialog.setButtons(3);
        } else {
            dialog.setButtonLabel(4, i18n.getTranslation("Avanzado"));
        }
        return dialog;
    }

    public void showAdvancedPropertiesDialog(DynObject parameters) {
        DataStoreDynObjectParametersPanel panel = new DataStoreDynObjectParametersPanel(parameters);
        this.showPropertiesDialog(parameters, (DataStoreParametersPanel)panel);
    }
}

