/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.expressionevaluator.suggestions;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.SuggestionProvider;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.Factory;
import org.gvsig.tools.visitor.VisitCanceledException;

public class CheckTableFieldsSuggestionProviderFactory
implements Factory {
    private final FeatureStore store;
    private FeatureType featureType;

    public CheckTableFieldsSuggestionProviderFactory(FeatureStore store) {
        this.store = store;
        try {
            this.featureType = store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            this.featureType = null;
        }
    }

    public String getName() {
        return "CheckTableFieldsSuggestion";
    }

    public Object create(Object ... parameters) {
        CheckTableFieldsSuggestionProvider suggestionProvider = new CheckTableFieldsSuggestionProvider();
        return suggestionProvider;
    }

    private String getSuggestedAttrName(String nameSearched, int maxdistance) {
        LevenshteinDistance comparator = LevenshteinDistance.getDefaultInstance();
        nameSearched = nameSearched.toLowerCase();
        String found_name = null;
        int found_distance = Integer.MAX_VALUE;
        for (FeatureAttributeDescriptor attr : this.featureType) {
            String name = attr.getName();
            int distance = comparator.apply((CharSequence)name.toLowerCase(), (CharSequence)nameSearched);
            if (distance >= found_distance) continue;
            found_name = name;
            found_distance = distance;
        }
        if (found_distance <= maxdistance) {
            return found_name;
        }
        return null;
    }

    private class CheckTableFieldsSuggestionProvider
    implements SuggestionProvider {
        private CheckTableFieldsSuggestionProvider() {
        }

        public String getSuggestion(String expression) {
            if (StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            MutableObject suggestion = new MutableObject();
            try {
                Code code = ExpressionUtils.compile((String)expression);
                if (code == null) {
                    return null;
                }
                String storename = CheckTableFieldsSuggestionProviderFactory.this.store.getName();
                code.accept(obj -> {
                    Code.Callable callable;
                    if (obj instanceof Code.Callable && StringUtils.equalsIgnoreCase((CharSequence)(callable = (Code.Callable)obj).name(), (CharSequence)"GETATTR")) {
                        String theStoreName;
                        Code arg0 = (Code)callable.parameters().get(0);
                        Code arg1 = (Code)callable.parameters().get(1);
                        if (arg0 instanceof Code.Identifier && arg1 instanceof Code.Constant && StringUtils.equalsIgnoreCase((CharSequence)storename, (CharSequence)(theStoreName = ((Code.Identifier)arg0).name()))) {
                            String attrname = Objects.toString(((Code.Constant)arg1).value(), "");
                            if (CheckTableFieldsSuggestionProviderFactory.this.featureType.getAttributeDescriptor(attrname) == null) {
                                String suggestedAttrName = CheckTableFieldsSuggestionProviderFactory.this.getSuggestedAttrName(attrname, 3);
                                I18nManager i18n = ToolsLocator.getI18nManager();
                                if (StringUtils.isBlank((CharSequence)suggestedAttrName)) {
                                    suggestion.setValue((Object)(i18n.getTranslation("_The_indicated_field_does_not_exist_in_the_table") + String.format(" (%s.%s)", storename, attrname)));
                                } else {
                                    suggestion.setValue((Object)(i18n.getTranslation("_The_indicated_field_does_not_exist_in_the_table") + String.format("\n(%s.%s --> %s.%s)", storename, attrname, storename, suggestedAttrName)));
                                }
                                throw new VisitCanceledException();
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return (String)suggestion.getValue();
        }
    }
}

