/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featurequery;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.featurequery.FeatureQueryOrderPanel;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributeListCellRenderer;
import org.gvsig.fmap.dal.swing.impl.featurequery.DefaultFeatureQueryOrderPanelView;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.LabeledValue;

public class DefaultFeatureQueryOrderPanel
extends DefaultFeatureQueryOrderPanelView
implements FeatureQueryOrderPanel {
    private FeatureQuery query;
    private FeatureType featureType;
    private final ActionListenerSupport actionListenerSupport = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
    private final ButtonGroup ascendingGroup = new ButtonGroup();
    private FilteredListController availableFieldsController;

    public DefaultFeatureQueryOrderPanel() {
        this.initComponents();
    }

    public FeatureQuery fetch(FeatureQuery query) {
        if (query == null) {
            return this.query.getCopy();
        }
        query.getOrder().copyFrom(this.query.getOrder());
        return query;
    }

    public FeatureQuery fetch() {
        return this.fetch(null);
    }

    public void put(FeatureQuery query) {
        this.query.copyFrom(query);
        this.updateControls();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.btnColumnAdd);
        toolsSwingManager.translate((AbstractButton)this.btnColumnDown);
        toolsSwingManager.translate((AbstractButton)this.btnColumnRemove);
        toolsSwingManager.translate((AbstractButton)this.btnColumnSortAscending);
        toolsSwingManager.translate((AbstractButton)this.btnColumnSortDescending);
        toolsSwingManager.translate((AbstractButton)this.btnColumnUp);
        toolsSwingManager.translate((AbstractButton)this.btnColumnsFilter);
        FeatureAttributeListCellRenderer renderer = DALSwingLocator.getDataSwingManager().createDefaultFeatureAttributeListCellRenderer();
        this.lstAvailableColumns.setCellRenderer(renderer);
        this.lstOrderColumns.setCellRenderer(renderer);
        this.ascendingGroup.add(this.btnColumnSortAscending);
        this.ascendingGroup.add(this.btnColumnSortDescending);
        this.lstAvailableColumns.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doSelectAvailableColumn();
        });
        this.lstOrderColumns.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doSelectOrderColumn();
        });
        this.btnColumnAdd.addActionListener(e -> this.doColumnAdd());
        this.btnColumnRemove.addActionListener(e -> this.doColumnRemove());
        this.btnColumnDown.addActionListener(e -> this.doColumnDown());
        this.btnColumnUp.addActionListener(e -> this.doColumnUp());
        this.btnColumnSortAscending.addActionListener(e -> this.doColumnSortAscending());
        this.btnColumnSortDescending.addActionListener(e -> this.doColumnSortDescending());
        this.availableFieldsController = toolsSwingManager.createFilteredListController(this.lstAvailableColumns, (JTextComponent)this.txtColumnsFilter, this.btnColumnsFilter);
        Dimension sz = this.getPreferredSize();
        if (sz.width < 650) {
            sz.width = 650;
        }
        if (sz.height < 320) {
            sz.height = 320;
        }
        this.setPreferredSize(sz);
    }

    private void doSelectAvailableColumn() {
        if (this.lstAvailableColumns.getSelectedIndex() >= 0) {
            this.btnColumnAdd.setEnabled(true);
            return;
        }
        this.btnColumnAdd.setEnabled(false);
    }

    private void doSelectOrderColumn() {
        FeatureQueryOrder.FeatureQueryOrderMember member;
        FeatureAttributeDescriptor attr;
        int indexOrder = this.lstOrderColumns.getSelectedIndex();
        ListModel modelOrder = this.lstOrderColumns.getModel();
        this.btnColumnUp.setEnabled(indexOrder >= 1);
        this.btnColumnDown.setEnabled(indexOrder >= 0 && indexOrder < modelOrder.getSize() - 1);
        if (indexOrder >= 0 && (attr = (FeatureAttributeDescriptor)this.lstOrderColumns.getSelectedValue()) != null && (member = this.query.getOrder().get(attr.getName())) != null) {
            this.btnColumnRemove.setEnabled(true);
            this.btnColumnSortAscending.setEnabled(true);
            this.btnColumnSortDescending.setEnabled(true);
            if (member.getAscending()) {
                this.btnColumnSortAscending.setSelected(true);
                this.btnColumnSortDescending.setSelected(false);
            } else {
                this.btnColumnSortAscending.setSelected(false);
                this.btnColumnSortDescending.setSelected(true);
            }
            return;
        }
        this.btnColumnRemove.setEnabled(false);
        this.btnColumnDown.setEnabled(false);
        this.btnColumnSortDescending.setEnabled(false);
        this.btnColumnSortAscending.setSelected(false);
        this.btnColumnSortDescending.setSelected(false);
    }

    private void doColumnSortAscending() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstOrderColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        FeatureQueryOrder.FeatureQueryOrderMember member = this.query.getOrder().get(attr.getName());
        member.setAscending(true);
    }

    private void doColumnSortDescending() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstOrderColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        FeatureQueryOrder.FeatureQueryOrderMember member = this.query.getOrder().get(attr.getName());
        member.setAscending(false);
    }

    private void doColumnUp() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstOrderColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        int selectedIndex = this.lstOrderColumns.getSelectedIndex();
        if (selectedIndex < 1) {
            return;
        }
        this.query.getOrder().movePrevious(attr.getName());
        this.lstOrderColumns.setSelectedIndex(selectedIndex - 1);
        this.updateControls();
    }

    private void doColumnDown() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstOrderColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        int selectedIndex = this.lstOrderColumns.getSelectedIndex();
        if (selectedIndex >= this.lstOrderColumns.getModel().getSize() - 1) {
            return;
        }
        this.query.getOrder().moveNext(attr.getName());
        this.lstOrderColumns.setSelectedIndex(selectedIndex + 1);
        this.updateControls();
    }

    private void doColumnRemove() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstOrderColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        FeatureQueryOrder.FeatureQueryOrderMember member = this.query.getOrder().get(attr.getName());
        this.query.getOrder().remove(member);
        this.updateControls();
    }

    private void doColumnAdd() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstAvailableColumns.getSelectedValue();
        if (attr == null) {
            return;
        }
        this.query.getOrder().add(attr.getName(), true);
        this.updateControls();
    }

    public void setStore(FeatureStore store) {
        try {
            this.featureType = store.getDefaultFeatureType();
            this.query = store.createFeatureQuery();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't assign store", ex);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void updateControls() {
        int indexAvailables = this.lstAvailableColumns.getSelectedIndex();
        int indexOrder = this.lstOrderColumns.getSelectedIndex();
        FilteredListModel modelAvailables = ToolsSwingLocator.getToolsSwingManager().createFilteredListModel();
        DefaultListModel<FeatureAttributeDescriptor> modelOrder = new DefaultListModel<FeatureAttributeDescriptor>();
        for (Object attr : this.featureType) {
            if (this.query.getOrder() != null && this.query.getOrder().contains(attr.getName())) continue;
            modelAvailables.addElement((LabeledValue)attr);
        }
        for (Object attr : this.query.getExtraColumn().getColumns()) {
            if (this.query.getOrder() != null && this.query.getOrder().contains(attr.getName())) continue;
            modelAvailables.addElement((LabeledValue)attr);
        }
        ArrayList<FeatureQueryOrder.FeatureQueryOrderMember> membersToRemove = new ArrayList<FeatureQueryOrder.FeatureQueryOrderMember>();
        for (FeatureQueryOrder.FeatureQueryOrderMember member : this.query.getOrder().members()) {
            FeatureAttributeDescriptor attr = this.featureType.getAttributeDescriptor(member.getAttributeName());
            if (attr == null) {
                attr = this.query.getExtraColumn().get(member.getAttributeName());
            }
            if (attr == null) {
                membersToRemove.add(member);
                continue;
            }
            modelOrder.addElement(attr);
        }
        for (FeatureQueryOrder.FeatureQueryOrderMember member : membersToRemove) {
            this.query.getOrder().remove(member);
        }
        modelAvailables.setFilter(this.txtColumnsFilter.getText());
        modelAvailables.sort(true);
        this.lstAvailableColumns.setModel(modelAvailables);
        this.lstOrderColumns.setModel(modelOrder);
        if (indexAvailables >= 0 && modelAvailables.getSize() > 0) {
            if (indexAvailables >= modelAvailables.getSize()) {
                indexAvailables = modelAvailables.getSize() - 1;
            }
            this.lstAvailableColumns.setSelectedIndex(indexAvailables);
            this.btnColumnAdd.setEnabled(true);
        } else {
            this.btnColumnAdd.setEnabled(false);
        }
        if (indexOrder >= 0 && modelOrder.getSize() > 0) {
            FeatureQueryOrder.FeatureQueryOrderMember member;
            Object attr;
            if (indexOrder >= modelOrder.getSize()) {
                indexOrder = modelOrder.getSize() - 1;
            }
            this.lstOrderColumns.setSelectedIndex(indexOrder);
            this.btnColumnUp.setEnabled(indexOrder >= 1);
            this.btnColumnDown.setEnabled(indexOrder < modelOrder.getSize() - 1);
            attr = (FeatureAttributeDescriptor)modelOrder.get(indexOrder);
            member = this.query.getOrder().get(attr.getName());
            if (member == null) {
                this.btnColumnSortAscending.setSelected(true);
                this.btnColumnSortDescending.setSelected(false);
                this.btnColumnSortAscending.setEnabled(false);
                this.btnColumnSortDescending.setEnabled(false);
            } else {
                this.btnColumnSortAscending.setEnabled(true);
                this.btnColumnSortDescending.setEnabled(true);
                if (member.getAscending()) {
                    this.btnColumnSortAscending.setSelected(true);
                    this.btnColumnSortDescending.setSelected(false);
                } else {
                    this.btnColumnSortAscending.setSelected(false);
                    this.btnColumnSortDescending.setSelected(true);
                }
            }
            this.btnColumnRemove.setEnabled(true);
        } else {
            this.btnColumnSortAscending.setSelected(true);
            this.btnColumnSortDescending.setSelected(false);
            this.btnColumnSortAscending.setEnabled(false);
            this.btnColumnSortDescending.setEnabled(false);
            this.btnColumnRemove.setEnabled(false);
            this.btnColumnUp.setEnabled(false);
            this.btnColumnDown.setEnabled(false);
        }
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public static void selfRegister() {
    }
}

