/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype.featurerule;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.fmap.dal.feature.FeatureRuleExpression;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class FeatureRuleItemController
implements AggregateController.AggregateItemController<FeatureRule> {
    private final JTextComponent txtRuleName;
    private final JTextComponent txtRuleDescription;
    private final JCheckBox chkRuleCheckAtFinishEditing;
    private final JCheckBox chkRuleCheckAtUpdate;
    private final JCheckBox chkRuleCheckAtEditFeature;
    private final JTextComponent txtRuleValidation;
    private final JButton btnRuleValidation;
    private final JButton btnRuleValidationBookmarks;
    private final JButton btnRuleValidationHistory;
    private ExpressionPickerController pickervalidation;
    private FeatureStoreElement featureStoreElement;
    private boolean ruleIsAExpression;
    private AggregateController.AggregateModel aggregateModel;

    public FeatureRuleItemController(JTextComponent txtRuleName, JTextComponent txtRuleDescription, JCheckBox chkRuleCheckAtFinishEditing, JCheckBox chkRuleCheckAtUpdate, JCheckBox chkRuleCheckAtEditFeature, JTextComponent txtRuleValidation, JButton btnRuleValidation, JButton btnRuleValidationBookmarks, JButton btnRuleValidationHistory) {
        this.txtRuleName = txtRuleName;
        this.txtRuleDescription = txtRuleDescription;
        this.chkRuleCheckAtFinishEditing = chkRuleCheckAtFinishEditing;
        this.chkRuleCheckAtUpdate = chkRuleCheckAtUpdate;
        this.chkRuleCheckAtEditFeature = chkRuleCheckAtEditFeature;
        this.txtRuleValidation = txtRuleValidation;
        this.btnRuleValidation = btnRuleValidation;
        this.btnRuleValidationBookmarks = btnRuleValidationBookmarks;
        this.btnRuleValidationHistory = btnRuleValidationHistory;
        this.ruleIsAExpression = false;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        ExpressionEvaluatorSwingManager evaluatorSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        toolsSwingManager.addClearButton(this.txtRuleName);
        toolsSwingManager.addClearButton(this.txtRuleDescription);
        toolsSwingManager.setDefaultPopupMenu(this.txtRuleName);
        toolsSwingManager.setDefaultPopupMenu(this.txtRuleDescription);
        this.featureStoreElement = dataSwingManager.createFeatureStoreElement();
        this.pickervalidation = evaluatorSwingManager.createExpressionPickerController(this.txtRuleValidation, this.btnRuleValidation, this.btnRuleValidationBookmarks, this.btnRuleValidationHistory);
        this.pickervalidation.getConfig().addElement((Element)this.featureStoreElement);
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStoreElement.setFeatureStore(featureStore);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.ruleIsAExpression) {
            enabled = false;
        }
        if (enabled && this.featureStoreElement.getFeatureStore() == null) {
            this.pickervalidation.setEnabled(false);
        } else {
            this.pickervalidation.setEnabled(enabled);
        }
        this.txtRuleName.setEnabled(enabled);
        this.txtRuleDescription.setEnabled(enabled);
        this.chkRuleCheckAtFinishEditing.setEnabled(enabled);
        this.chkRuleCheckAtUpdate.setEnabled(enabled);
        this.chkRuleCheckAtEditFeature.setEnabled(enabled);
    }

    @Override
    public void put(FeatureRule rule) {
        this.ruleIsAExpression = rule instanceof FeatureRuleExpression;
        this.txtRuleName.setText(rule.getName());
        this.txtRuleDescription.setText(rule.getDescription());
        this.chkRuleCheckAtFinishEditing.setSelected(rule.checkAtFinishEditing());
        this.chkRuleCheckAtUpdate.setSelected(rule.checkAtUpdate());
        this.chkRuleCheckAtEditFeature.setSelected(rule.checkWhen(4));
        if (this.ruleIsAExpression) {
            this.pickervalidation.set((Object)((FeatureRuleExpression)rule).getExpression());
        }
    }

    @Override
    public boolean fetch(FeatureRule rule) {
        if (!(rule instanceof FeatureRuleExpression)) {
            return true;
        }
        FeatureRuleExpression theRule = (FeatureRuleExpression)rule;
        String s = this.txtRuleName.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        theRule.setName(s);
        theRule.setDescription(this.txtRuleDescription.getText());
        theRule.setCheckAtFinishEditing(this.chkRuleCheckAtFinishEditing.isSelected());
        theRule.setCheckAtUpdate(this.chkRuleCheckAtUpdate.isSelected());
        theRule.setCheckWhen(this.chkRuleCheckAtEditFeature.isSelected() ? 4 : 0);
        theRule.setExpression(this.pickervalidation.get());
        return true;
    }

    @Override
    public void clean() {
        this.ruleIsAExpression = false;
        this.txtRuleName.setText("");
        this.txtRuleDescription.setText("");
        this.chkRuleCheckAtFinishEditing.setSelected(false);
        this.chkRuleCheckAtUpdate.setSelected(false);
        this.chkRuleCheckAtEditFeature.setSelected(false);
        this.pickervalidation.set(null);
    }

    @Override
    public boolean isEditing() {
        return this.txtRuleName.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.txtRuleName.isEnabled();
    }

    @Override
    public void setAggregateModel(AggregateController.AggregateModel model) {
        this.aggregateModel = model;
    }
}

