/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype.tags;

import java.util.ArrayList;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.Tag;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.TagsModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.UnmodifiableBasicMap;

public class TagItemController
implements AggregateController.AggregateItemController<Tag> {
    private final JComboBox cboName;
    private final JComboBox cboValue;
    private final JLabel lblDescription;
    private final UnmodifiableBasicMap<String, DynField> tagDefinitions;
    private AggregateController.AggregateModel tagsModel;

    public TagItemController(JComboBox cboName, JComboBox cboValue, JLabel lblDescription) {
        this.cboName = cboName;
        this.cboValue = cboValue;
        this.lblDescription = lblDescription;
        this.tagDefinitions = ToolsLocator.getDynObjectManager().getTags();
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.setDefaultPopupMenu(this.cboName);
        swingManager.setDefaultPopupMenu(this.cboValue);
        swingManager.addClearButton(this.cboValue);
        ArrayList<String> tagsNames = new ArrayList<String>();
        for (String tag : this.tagDefinitions.keySet()) {
            tagsNames.add(tag);
        }
        tagsNames.sort(null);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        for (String tag : tagsNames) {
            model.addElement(tag);
        }
        this.cboName.setModel(model);
        this.cboName.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.doChangeTagName();
            }
        });
    }

    private void doChangeTagName() {
        String tagname = (String)this.cboName.getSelectedItem();
        if (StringUtils.isBlank((CharSequence)tagname)) {
            this.lblDescription.setText("");
            return;
        }
        for (DynField tagDefinition : this.tagDefinitions) {
            DynObjectValueItem[] values;
            if (!tagname.equalsIgnoreCase(tagDefinition.getName())) continue;
            this.lblDescription.setText("<html>" + tagDefinition.getDescription() + "<html>");
            DefaultComboBoxModel<DynObjectValueItem> model = new DefaultComboBoxModel<DynObjectValueItem>();
            if (tagDefinition instanceof DynField_v2) {
                DynMethod method = ((DynField_v2)tagDefinition).getAvailableValuesMethod();
                try {
                    values = (LabeledValue[])method.invoke(null, new Object[]{this.getAggregateModel().getTags()});
                }
                catch (Throwable t) {
                    values = null;
                }
                if (values == null) {
                    values = tagDefinition.getAvailableValues();
                }
            } else {
                values = tagDefinition.getAvailableValues();
            }
            if (values != null) {
                for (DynObjectValueItem value : values) {
                    model.addElement(value);
                }
            }
            this.cboValue.setModel(model);
            return;
        }
        this.lblDescription.setText("");
    }

    @Override
    public void put(Tag item) {
        this.cboName.setSelectedItem(item.getName());
        this.cboValue.setSelectedItem(Objects.toString(item.getValue(), ""));
    }

    @Override
    public boolean fetch(Tag item) {
        String s = Objects.toString(this.cboName.getSelectedItem());
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        item.setName(s);
        item.setValue(Objects.toString(this.cboValue.getSelectedItem()));
        return true;
    }

    @Override
    public void clean() {
        this.cboName.setSelectedIndex(-1);
        this.cboValue.setSelectedIndex(-1);
        this.lblDescription.setText("");
    }

    @Override
    public boolean isEditing() {
        return this.cboName.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.cboName.setEnabled(b);
        this.cboValue.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.cboName.isEnabled();
    }

    @Override
    public void setAggregateModel(AggregateController.AggregateModel model) {
        this.tagsModel = model;
    }

    public TagsModel getAggregateModel() {
        return (TagsModel)this.tagsModel;
    }
}

