/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.AggregateOperation;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.DistinctOnFactory;
import org.gvsig.fmap.dal.swing.searchPostProcess.AbstractSearchPostProcess;
import org.gvsig.fmap.dal.swing.searchPostProcess.SearchPostProcess;
import org.gvsig.fmap.dal.swing.searchPostProcess.SearchPostProcessFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.HasAFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistinctOn
extends AbstractSearchPostProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistinctOnFactory.class);
    private static final String DISTINCT_ON_PRIMARY_KEY = "PK$$";
    private static Map<String, AggregateOperation.AggregateOperationFactory> aggregatesOperationFactories = new HashMap<String, AggregateOperation.AggregateOperationFactory>();

    public DistinctOn(SearchPostProcessFactory factory, FeatureStore input, FeatureQuery query, DynObject parameters) {
        super(factory, input, query, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchPostProcess.SearchPostProcessResult execute(FeatureStore inputStore, FeatureQuery query, DynObject parameters, SimpleTaskStatus status) {
        String uniqueFieldName = (String)parameters.getDynValue("field");
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Executing_post_process"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
            status.setTitle(i18n.getTranslation("_Executing_post_process"));
        }
        status.message(i18n.getTranslation("_Creating_data_base"));
        try {
            FoldersManager foldersManager = ToolsLocator.getFoldersManager();
            File tempFile = foldersManager.getUniqueTemporaryFile(new String[]{"distinctOn_process_" + UUID.randomUUID().toString()});
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters serverParameters = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)serverParameters).setFile(tempFile);
            JDBCServerExplorer serverExplorer = (JDBCServerExplorer)dataManager.openServerExplorer("H2Spatial", (DataServerExplorerParameters)serverParameters);
            JDBCNewStoreParameters parametersResults = serverExplorer.getAddParameters();
            parametersResults.setDynValue("Table", (Object)"results");
            FeatureType ft_inputStore = inputStore.getDefaultFeatureType();
            EditableFeatureType ft_outputStoreNoContainer = dataManager.createFeatureType();
            ft_outputStoreNoContainer.add(DISTINCT_ON_PRIMARY_KEY, 4).setIsPrimaryKey(true).setIsAutomatic(false).setLabel("pk");
            ft_outputStoreNoContainer.addAll(ft_inputStore);
            for (Object attr : ft_inputStore) {
                DataType dataType = attr.getDataType();
                EditableFeatureAttributeDescriptor eattr = ft_outputStoreNoContainer.getEditableAttributeDescriptor(attr.getName());
                if (!dataType.isContainer()) continue;
                ft_outputStoreNoContainer.remove(attr.getName());
            }
            HashMap<String, EditableFeatureAttributeDescriptor> allExtraColumns = new HashMap<String, EditableFeatureAttributeDescriptor>();
            for (Object column : ft_inputStore.getExtraColumns().getColumns()) {
                allExtraColumns.put(column.getName(), (EditableFeatureAttributeDescriptor)column);
            }
            for (Object column : query.getExtraColumn().getColumns()) {
                allExtraColumns.put(column.getName(), (EditableFeatureAttributeDescriptor)column);
            }
            if (allExtraColumns.size() > 0) {
                for (Object column : allExtraColumns.values()) {
                    DataType dataType = column.getDataType();
                    if (dataType.isContainer()) continue;
                    EditableFeatureAttributeDescriptor eattr = ft_outputStoreNoContainer.add(column.getName(), column.getType(), column.getSize());
                    eattr.copyFrom((DynField)column);
                }
            }
            HashMap<String, AggregateOperation> aggregates = new HashMap<String, AggregateOperation>();
            for (FeatureAttributeDescriptor attr : ft_outputStoreNoContainer) {
                if (StringUtils.equalsIgnoreCase((CharSequence)attr.getName(), (CharSequence)DISTINCT_ON_PRIMARY_KEY) || !parameters.hasDynValue(attr.getName())) continue;
                String operationName = (String)parameters.getDynValue(attr.getName());
                AggregateOperation operation = aggregatesOperationFactories.get(operationName).create(new Object[0]);
                operation.fixAttributeDescriptor((EditableFeatureAttributeDescriptor)attr);
                aggregates.put(attr.getName(), operation);
            }
            parametersResults.setDefaultFeatureType((FeatureType)ft_outputStoreNoContainer);
            serverExplorer.add("H2Spatial", (NewDataStoreParameters)parametersResults, true);
            DataStoreParameters storeParametersResults = dataManager.createStoreParameters("H2Spatial");
            storeParametersResults.setDynValue("database_file", (Object)tempFile);
            storeParametersResults.setDynValue("Table", (Object)"results");
            FeatureStore storeResults = (FeatureStore)dataManager.openStore("H2Spatial", storeParametersResults);
            storeResults.edit(2);
            status.message(i18n.getTranslation("_Getting_features_from_query"));
            FeatureSet features = query != null ? inputStore.getFeatureSet(query) : inputStore.getFeatureSet();
            Feature previousFeature = null;
            status.message(i18n.getTranslation("_Processing_features"));
            status.setRangeOfValues(0L, (long)features.size());
            long counter = 1L;
            for (Object feature : features) {
                AggregateOperation operation;
                if (status.isCancellationRequested()) {
                    DisposeUtils.disposeQuietly((Disposable)features);
                    if (storeResults.isEditing()) {
                        storeResults.cancelEditingQuietly();
                    }
                    status.setTitle(i18n.getTranslation("_Post_process_canceled"));
                    status.message("");
                    status.cancel();
                    SearchPostProcess.SearchPostProcessResult searchPostProcessResult = null;
                    return searchPostProcessResult;
                }
                if (previousFeature == null) {
                    previousFeature = feature.getCopy();
                }
                if (!Objects.equals(feature.get(uniqueFieldName), previousFeature.get(uniqueFieldName))) {
                    EditableFeature editableFeature = storeResults.createNewFeature(previousFeature);
                    for (Map.Entry entry : aggregates.entrySet()) {
                        String name = (String)entry.getKey();
                        AggregateOperation operation2 = (AggregateOperation)entry.getValue();
                        editableFeature.set(name, operation2.getValue());
                    }
                    editableFeature.set(DISTINCT_ON_PRIMARY_KEY, (Object)counter++);
                    storeResults.insert(editableFeature);
                    for (Map.Entry entry : aggregates.entrySet()) {
                        operation = (AggregateOperation)entry.getValue();
                        operation.reset();
                    }
                    previousFeature = feature.getCopy();
                }
                for (Map.Entry entry : aggregates.entrySet()) {
                    Object value;
                    String name = (String)entry.getKey();
                    operation = (AggregateOperation)entry.getValue();
                    if (!operation.isApplicable(new Object[]{value = feature.get(name)})) continue;
                    operation.perform(value);
                }
                status.incrementCurrentValue();
            }
            EditableFeature resultFeature = storeResults.createNewFeature(previousFeature);
            for (Map.Entry entry : aggregates.entrySet()) {
                String string = (String)entry.getKey();
                AggregateOperation operation = (AggregateOperation)entry.getValue();
                resultFeature.set(string, operation.getValue());
            }
            resultFeature.set(DISTINCT_ON_PRIMARY_KEY, (Object)counter++);
            storeResults.insert(resultFeature);
            storeResults.finishEditing();
            storeResults.setTemporary(Boolean.valueOf(true));
            Boolean addTableToProject = (Boolean)parameters.getDynValue("addTableToProject");
            if (addTableToProject.booleanValue()) {
                StoresRepository storesRepository = dataManager.getStoresRepository().getSubrepository("PROJECT_TABLES");
                storesRepository.add(this.getName(), storeResults);
            }
            AbstractSearchPostProcess.DefaultSearchPostProcessResult defaultSearchPostProcessResult = new AbstractSearchPostProcess.DefaultSearchPostProcessResult((AbstractSearchPostProcess)this, storeResults, null);
            status.setTitle(i18n.getTranslation("_Post_process_ended"));
            status.message("");
            AbstractSearchPostProcess.DefaultSearchPostProcessResult defaultSearchPostProcessResult2 = defaultSearchPostProcessResult;
            return defaultSearchPostProcessResult2;
        }
        catch (DataException | ValidateDataParametersException ex) {
            LOGGER.warn("Can't execute distinct on search post process.", ex);
        }
        finally {
            status.pop();
        }
        return null;
    }

    public static void registerAggregateOperation(AggregateOperation.AggregateOperationFactory aggregateOperationFactory) {
        aggregatesOperationFactories.put(aggregateOperationFactory.getName(), aggregateOperationFactory);
    }

    public static Collection<AggregateOperation.AggregateOperationFactory> getAggregatesOperationFactories() {
        return aggregatesOperationFactories.values();
    }

    public static AggregateOperation.AggregateOperationFactory getAggregatesOperationFactory(String name) {
        return aggregatesOperationFactories.get(name);
    }
}

