/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchpanel;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.DALExpressionBuilder;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributeSelectionPanel;
import org.gvsig.fmap.dal.swing.impl.searchpanel.SearchConditionFieldView;
import org.gvsig.fmap.dal.swing.impl.searchpanel.SelectGeometryPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.DatePickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchConditionFieldController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchConditionFieldController.class);
    private static final Class LOAD_MORE_ELEMENTS = SearchConditionFieldController.class;
    private static final int MAXLEN_IN_COMBOS = 70;
    static final String FUNCTION_ISNOTEMPTY = "IsNotEmpty";
    static final String FUNCTION_ISNOTVALID = "IsNotValid";
    static final String FUNCTION_INTERSECTSWITHBBOX = "IntersectsWithBBox";
    static final int GEOM_OPERAND_MODE_EMPTY = 0;
    static final int GEOM_OPERAND_MODE_CLIPBOARD = 1;
    static final int GEOM_OPERAND_MODE_LAYER_SELECTION = 2;
    static final int GEOM_OPERAND_MODE_CONSTANT = 3;
    static final int GEOM_OPERAND_MODE_CURRENT_BOUNDINGBOX = 4;
    private static final String OPERATOR_CONTAINS = "CONTAINS";
    private FeatureStore store;
    private SearchParameters parameters;
    private final JLabel lblFields;
    private final JLabel lblExtraFields;
    private final JLabel lblLogicalOperators;
    private final JLabel lblRelationalOperators;
    private final JComboBox cboValue;
    private final JTextField txtValue;
    private final JButton btnValue;
    private final JLabel lblNull;
    private Object valueAssigned = null;
    private DropDown ddnFields;
    private DropDown ddnLogicalOperators;
    private DropDown ddnRelationalOperators;
    private DropDown ddnNullBehavior;
    private LabeledValue[] relationalOperators;
    private LabeledValue[] logicalOperators;
    private LabeledValue[] nullBehaviors;
    private ArrayList<ImageIcon> nullOperatorsIcons;
    private final int SIZE_ORDERED_ATTRIBUTES = 20;
    private DatePickerController dateController = null;
    private int updateValuesTimeLimit;
    private int updateValuesFeaturesLimit;
    private UpdateValueList updateValueListTask;
    private LabeledValue[] geometryRelationalOperators;
    private DefaultComboBoxModel modelRelationalOperators;
    private DefaultComboBoxModel modelGeometryRelationalOperators;
    private int geometryOperandMode;
    private boolean useBox2dInGeometryOperand = false;
    private String geometryOperandStoreId;
    private Geometry geometryOperandConstant;
    private String lastNameInUpdateValuesList = null;
    private int lastUpdateValuesFeaturesLimit = -1;
    private int lastUpdateValuesTimeLimit = -1;

    public SearchConditionFieldController(SearchParameters parameters, FeatureStore store, SearchConditionFieldView view) {
        this.parameters = parameters;
        this.store = store;
        this.lblFields = view.lblFields;
        this.lblExtraFields = view.lblExtraFields;
        this.lblRelationalOperators = view.lblRelationalOperators;
        this.cboValue = view.cboValue;
        this.txtValue = view.txtValue;
        this.btnValue = view.btnValue;
        this.lblNull = view.lblNull;
        this.lblLogicalOperators = view.lblLogicalOperators;
        this.updateValuesTimeLimit = 60;
        this.updateValuesFeaturesLimit = 1000;
        this.initComponents();
    }

    public boolean isAValidRelationOperator(String name) {
        for (LabeledValue relationalOperator : this.relationalOperators) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)((CharSequence)relationalOperator.getValue()))) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        try {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            this.relationalOperators = new LabeledValue[]{new LabeledValueImpl(i18n.getTranslation("_Contains"), (Object)OPERATOR_CONTAINS), new LabeledValueImpl(i18n.getTranslation("_Equals_to"), (Object)"="), new LabeledValueImpl(i18n.getTranslation("_Like_to"), (Object)"ILIKE"), new LabeledValueImpl(i18n.getTranslation("_Not_equals_to"), (Object)"<>"), new LabeledValueImpl(i18n.getTranslation("_Greater_than"), (Object)">"), new LabeledValueImpl(i18n.getTranslation("_Greater_or_equal_to"), (Object)">="), new LabeledValueImpl(i18n.getTranslation("_Less_than"), (Object)"<"), new LabeledValueImpl(i18n.getTranslation("_Less_or_equal_to"), (Object)"<="), new LabeledValueImpl(i18n.getTranslation("_Is_null"), (Object)"IS NULL"), new LabeledValueImpl(i18n.getTranslation("_Is_not_null"), (Object)"IS NOT NULL")};
            this.geometryRelationalOperators = new LabeledValue[]{new LabeledValueImpl(i18n.getTranslation("_Is_covered_by"), (Object)"ST_CoveredBy"), new LabeledValueImpl(i18n.getTranslation("_Covers_to"), (Object)"ST_Covers"), new LabeledValueImpl(i18n.getTranslation("_Contains_to"), (Object)"ST_Contains"), new LabeledValueImpl(i18n.getTranslation("_Crosses_to"), (Object)"ST_Crosses"), new LabeledValueImpl(i18n.getTranslation("_Is_disjoint_with"), (Object)"ST_Disjoint"), new LabeledValueImpl(i18n.getTranslation("_Intersects_with"), (Object)"ST_Intersects"), new LabeledValueImpl(i18n.getTranslation("_Intersects_with_boundingbox"), (Object)FUNCTION_INTERSECTSWITHBBOX), new LabeledValueImpl(i18n.getTranslation("_Overlaps_with"), (Object)"ST_Overlaps"), new LabeledValueImpl(i18n.getTranslation("_Touches_with"), (Object)"ST_Touches"), new LabeledValueImpl(i18n.getTranslation("_Is_within_of"), (Object)"ST_Within"), new LabeledValueImpl(i18n.getTranslation("_Is_equals_to"), (Object)"ST_Equals"), new LabeledValueImpl(i18n.getTranslation("_Is_null"), (Object)"IS NULL"), new LabeledValueImpl(i18n.getTranslation("_Is_not_null"), (Object)"IS NOT NULL"), new LabeledValueImpl(i18n.getTranslation("_Is_valid"), (Object)"ST_IsValid"), new LabeledValueImpl(i18n.getTranslation("_Is_not_valid"), (Object)FUNCTION_ISNOTVALID), new LabeledValueImpl(i18n.getTranslation("_Is_empty"), (Object)"ST_IsEmpty"), new LabeledValueImpl(i18n.getTranslation("_Is_not_empty"), (Object)FUNCTION_ISNOTEMPTY)};
            this.logicalOperators = new LabeledValue[]{new LabeledValueImpl(i18n.getTranslation("_Or"), (Object)"OR"), new LabeledValueImpl(i18n.getTranslation("_And"), (Object)"AND")};
            this.nullBehaviors = new LabeledValue[]{new LabeledValueImpl(i18n.getTranslation("_Not_handle_null_values"), (Object)0), new LabeledValueImpl(i18n.getTranslation("_Null_values_as_true"), (Object)1), new LabeledValueImpl(i18n.getTranslation("_Null_values_as_false"), (Object)2)};
            this.nullOperatorsIcons = new ArrayList();
            this.nullOperatorsIcons.add(ToolsSwingLocator.getIconThemeManager().getCurrent().get("search-nullbehavior-null"));
            this.nullOperatorsIcons.add(ToolsSwingLocator.getIconThemeManager().getCurrent().get("search-nullbehavior-true"));
            this.nullOperatorsIcons.add(ToolsSwingLocator.getIconThemeManager().getCurrent().get("search-nullbehavior-false"));
            this.lblExtraFields.setCursor(Cursor.getPredefinedCursor(12));
            this.ddnFields = toolsSwingManager.createDropDown(this.lblFields);
            this.ddnFields.setVisibleDropdownArrow(false);
            this.ddnRelationalOperators = toolsSwingManager.createDropDown(this.lblRelationalOperators);
            this.ddnRelationalOperators.setVisibleDropdownArrow(false);
            if (this.lblLogicalOperators != null) {
                this.ddnLogicalOperators = toolsSwingManager.createDropDown(this.lblLogicalOperators);
                this.ddnLogicalOperators.setVisibleDropdownArrow(false);
            }
            this.modelRelationalOperators = new DefaultComboBoxModel();
            for (LabeledValue op : this.relationalOperators) {
                this.modelRelationalOperators.addElement(op);
            }
            this.modelGeometryRelationalOperators = new DefaultComboBoxModel();
            for (LabeledValue op : this.geometryRelationalOperators) {
                this.modelGeometryRelationalOperators.addElement(op);
            }
            this.ddnRelationalOperators.setModel((ComboBoxModel)this.modelRelationalOperators);
            this.ddnRelationalOperators.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    SearchConditionFieldController.this.doUpdateControllerByRelationalOperator();
                }
            });
            if (this.ddnLogicalOperators != null) {
                DefaultComboBoxModel<LabeledValue> modelLogicalOperators = new DefaultComboBoxModel<LabeledValue>();
                for (LabeledValue op : this.logicalOperators) {
                    modelLogicalOperators.addElement(op);
                }
                this.ddnLogicalOperators.setModel(modelLogicalOperators);
                this.ddnLogicalOperators.setSelectedIndex(1);
            }
            this.ddnNullBehavior = toolsSwingManager.createDropDownIcon(this.lblNull);
            this.ddnNullBehavior.setVisibleDropdownArrow(false);
            DefaultComboBoxModel<LabeledValue> modelNullOperators = new DefaultComboBoxModel<LabeledValue>();
            for (LabeledValue op : this.nullBehaviors) {
                modelNullOperators.addElement(op);
            }
            this.ddnNullBehavior.setModel(modelNullOperators);
            this.ddnNullBehavior.setIcons(this.nullOperatorsIcons);
            this.ddnNullBehavior.setSelectedIndex(0);
            FeatureType featureType = this.parameters.getFeatureType(this.store);
            Search search = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)featureType);
            List orderedAttributes = search.getOrderedAttributes(Search.BASIC_TYPES_FILTER.or(t -> t.getType() == 66), Search.STR_INT_LONG_LABEL_ORDER, 20);
            ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
            DefaultComboBoxModel<Field> model = new DefaultComboBoxModel<Field>();
            for (Search.OrderedAttribute attr : orderedAttributes) {
                FeatureAttributeDescriptor attrdesc = attr.getDescriptor();
                Field field = new Field(new FeatureAttributeDescriptor[]{attrdesc}, this.store, attrdesc, attr.getType());
                model.addElement(field);
                String iconName = attrdesc.getDataType().getIconName();
                if (iconTheme.exists(iconName)) {
                    icons.add(iconTheme.get(iconName));
                    continue;
                }
                icons.add(null);
            }
            this.ddnFields.setIcons(icons);
            this.ddnFields.setModel(model);
            this.ddnFields.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        SearchConditionFieldController.this.doUpdateValuesList();
                    }
                }
            });
            this.cboValue.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && SearchConditionFieldController.this.cboValue.getSelectedItem() != null && SearchConditionFieldController.this.cboValue.getSelectedItem() instanceof LabeledValue && Objects.equals(((LabeledValue)SearchConditionFieldController.this.cboValue.getSelectedItem()).getValue(), LOAD_MORE_ELEMENTS)) {
                        SearchConditionFieldController.this.setUpdateValuesLimits(SearchConditionFieldController.this.updateValuesTimeLimit + 10, SearchConditionFieldController.this.updateValuesFeaturesLimit + 1000);
                    }
                }
            });
            this.lblExtraFields.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SearchConditionFieldController.this.doSelectMoreFields();
                }
            });
            this.txtValue.setVisible(false);
            this.btnValue.setVisible(false);
            this.geometryOperandMode = 0;
            this.geometryOperandStoreId = null;
            this.geometryOperandConstant = null;
            this.useBox2dInGeometryOperand = false;
            this.btnValue.addActionListener(e -> this.doSelectGeometryOperand());
            this.doUpdateControllerByRelationalOperator();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void doUpdateControllerByRelationalOperator() {
        Object item = ((LabeledValue)this.ddnRelationalOperators.getSelectedItem()).getValue();
        if ("IS NULL".equals(item) || "IS NOT NULL".equals(item)) {
            this.lblNull.setEnabled(false);
            this.cboValue.setEnabled(false);
            this.cboValue.setSelectedIndex(-1);
        } else {
            this.lblNull.setEnabled(true);
            this.cboValue.setEnabled(true);
        }
        this.doUpdateCurrentValue();
    }

    private void doUpdateCurrentValue() {
        Field field = this.getCurrentField();
        if (field != null) {
            FeatureAttributeDescriptor desc = field.getDescriptor();
            int type = desc == null ? 4 : desc.getType();
            switch (type) {
                case 66: {
                    this.cboValue.setVisible(false);
                    this.txtValue.setVisible(true);
                    this.btnValue.setVisible(true);
                    switch (this.geometryOperandMode) {
                        case 3: {
                            if (this.geometryOperandConstant == null) {
                                this.txtValue.setText("");
                                break;
                            }
                            this.txtValue.setText(Objects.toString(GeometryUtils.toWKT((Geometry)this.geometryOperandConstant), ""));
                            break;
                        }
                        case 2: {
                            if (this.geometryOperandStoreId != null) {
                                StoresRepository repo = DALLocator.getDataManager().getStoresRepository();
                                this.txtValue.setText(repo.getLabelOrName(this.geometryOperandStoreId));
                                break;
                            }
                            this.geometryOperandMode = 1;
                        }
                        case 1: {
                            this.txtValue.setText("Contenido del portapapeles");
                            break;
                        }
                        case 4: {
                            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
                            Supplier bbox = dataSwingManager.getCurrentBoundingBox();
                            if (bbox != null) {
                                Envelope env = (Envelope)bbox.get();
                                if (env != null && !env.isEmpty() && !env.isCollapsed()) {
                                    this.txtValue.setText(Objects.toString(GeometryUtils.toWKT((Geometry)env.getGeometry()), ""));
                                    break;
                                }
                                this.txtValue.setText("");
                                break;
                            }
                            this.txtValue.setText("");
                        }
                    }
                    break;
                }
                default: {
                    if (this.txtValue.isVisible()) {
                        this.ddnRelationalOperators.setSelectedIndex(1);
                    }
                    this.cboValue.setVisible(true);
                    this.txtValue.setVisible(false);
                    this.btnValue.setVisible(false);
                }
            }
        }
    }

    private FeatureType getFeatureType() {
        try {
            return this.store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            return null;
        }
    }

    private void doSelectMoreFields() {
        DefaultFeatureAttributeSelectionPanel panel = new DefaultFeatureAttributeSelectionPanel(this.store, this.parameters.getFeatureType(this.store), this.parameters.getQuery());
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winManager.createDialog((JComponent)panel, "Select attribute", null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                this.doAddAndSelect(panel.getSelectedStore(), panel.getSelectedAttributeDescriptor(), panel.getSelectedPath());
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private void doAddAndSelect(FeatureStore theStore, FeatureAttributeDescriptor attrdesc, FeatureAttributeDescriptor[] path) {
        ThreadSafeDialogsManager dialogManager = ToolsSwingLocator.getThreadSafeDialogsManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.ddnFields.getModel();
        if (attrdesc == null) {
            dialogManager.messageDialog(i18n.getTranslation("_It_is_not_supported_to_search_through_this_field") + "\n" + i18n.getTranslation("_Field_not_found"), "_Warning", 2);
            return;
        }
        for (int i = 0; i < model.getSize(); ++i) {
            Field field = (Field)((Object)model.getElementAt(i));
            FeatureAttributeDescriptor attrdescN = field.getDescriptor();
            if (theStore == null || attrdescN.getStore() == null || !this.isTheSameStore((DataStore)theStore, (DataStore)attrdescN.getStore()) || !StringUtils.equalsIgnoreCase((CharSequence)attrdesc.getName(), (CharSequence)attrdescN.getName())) continue;
            this.setAttribute(i);
            return;
        }
        Field field = new Field(path, theStore, attrdesc, 0, !this.isTheSameStore((DataStore)this.store, (DataStore)theStore));
        if (field.getPath().length > 2) {
            dialogManager.messageDialog(i18n.getTranslation("_It_is_not_supported_to_search_through_this_field") + "\n" + i18n.getTranslation("_To_many_links"), "_Warning", 2);
            return;
        }
        FeatureAttributeDescriptor parentDescriptor = field.getParentDescriptor();
        if (parentDescriptor != null) {
            switch (parentDescriptor.getRelationType()) {
                case 3: 
                case 4: {
                    if (this.getForeingKeyName(field.getFeatureStore(), this.store) == null) {
                        dialogManager.messageDialog("It not supported to search through this field.\nThe link field was not found.", "_Warning", 2);
                        return;
                    }
                    if (this.getPrimaryKeyName(this.store) != null) break;
                    dialogManager.messageDialog("It not supported to search through this field.\nA simple primary key was not found.", "_Warning", 2);
                    return;
                }
            }
        }
        model.addElement(field);
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        this.ddnFields.getIcons().add(iconTheme.get(attrdesc.getDataType().getIconName()));
        this.setAttribute(model.getSize() - 1);
    }

    public void clear() {
        this.ddnRelationalOperators.setSelectedIndex(0);
        if (this.ddnLogicalOperators != null) {
            this.ddnLogicalOperators.setSelectedIndex(1);
        }
        this.cboValue.setSelectedIndex(-1);
        this.ddnNullBehavior.setSelectedIndex(0);
        this.geometryOperandStoreId = null;
        this.geometryOperandMode = 0;
        this.doUpdateControllerByRelationalOperator();
    }

    private void doUpdateValuesList() {
        Field field = (Field)((Object)this.ddnFields.getSelectedItem());
        if (field == null) {
            return;
        }
        FeatureAttributeDescriptor descriptor = field.getDescriptor();
        if (StringUtils.equalsIgnoreCase((CharSequence)this.lastNameInUpdateValuesList, (CharSequence)descriptor.getName()) && this.updateValuesFeaturesLimit == this.lastUpdateValuesFeaturesLimit && this.updateValuesTimeLimit == this.lastUpdateValuesTimeLimit) {
            return;
        }
        this.lastNameInUpdateValuesList = descriptor.getName();
        this.lastUpdateValuesFeaturesLimit = this.updateValuesFeaturesLimit;
        this.lastUpdateValuesTimeLimit = this.updateValuesTimeLimit;
        if (this.updateValueListTask != null) {
            this.updateValueListTask.cancelRequest();
        }
        switch (descriptor.getType()) {
            case 66: {
                this.ddnRelationalOperators.setModel((ComboBoxModel)this.modelGeometryRelationalOperators);
                if (!this.txtValue.isVisible()) {
                    this.ddnRelationalOperators.setSelectedIndex(0);
                }
                this.cboValue.setVisible(false);
                this.txtValue.setVisible(true);
                this.btnValue.setVisible(true);
                break;
            }
            case 9: {
                if (this.dateController == null) {
                    this.dateController = ToolsSwingLocator.getToolsSwingManager().createDatePickerController((JTextComponent)this.cboValue.getEditor().getEditorComponent(), null);
                }
                this.ddnRelationalOperators.setModel((ComboBoxModel)this.modelRelationalOperators);
                if (this.txtValue.isVisible()) {
                    this.ddnRelationalOperators.setSelectedIndex(0);
                }
                this.cboValue.setVisible(true);
                this.txtValue.setVisible(false);
                this.btnValue.setVisible(false);
                this.updateValueListTask = new UpdateValueList(field);
                Thread updateTask = new Thread(this.updateValueListTask);
                updateTask.start();
                break;
            }
            default: {
                this.ddnRelationalOperators.setModel((ComboBoxModel)this.modelRelationalOperators);
                if (this.txtValue.isVisible()) {
                    this.ddnRelationalOperators.setSelectedIndex(0);
                }
                this.cboValue.setVisible(true);
                this.txtValue.setVisible(false);
                this.btnValue.setVisible(false);
                if (this.dateController != null) {
                    this.dateController.uninstall();
                    this.dateController = null;
                }
                this.updateValueListTask = new UpdateValueList(field);
                Thread updateTask = new Thread(this.updateValueListTask);
                updateTask.start();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.ddnFields.setEnabled(enabled);
        if (this.ddnLogicalOperators != null) {
            this.ddnLogicalOperators.setEnabled(enabled);
        }
        this.ddnRelationalOperators.setEnabled(enabled);
        this.lblExtraFields.setEnabled(enabled);
        this.cboValue.setEnabled(enabled);
        this.doUpdateControllerByRelationalOperator();
    }

    public String getRelationalOperator() {
        LabeledValue op = (LabeledValue)this.ddnRelationalOperators.getSelectedItem();
        if (op == null) {
            return null;
        }
        return (String)op.getValue();
    }

    public int setRelationalOperator(String name) {
        int n = 0;
        for (LabeledValue relationalOperator : this.relationalOperators) {
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)((CharSequence)relationalOperator.getValue()))) break;
            ++n;
        }
        if (this.relationalOperators.length <= n) {
            return -1;
        }
        this.ddnRelationalOperators.setSelectedIndex(n);
        this.doUpdateControllerByRelationalOperator();
        return n;
    }

    public String getLogicalOperator() {
        if (this.ddnLogicalOperators == null) {
            return null;
        }
        LabeledValue rel = (LabeledValue)this.ddnLogicalOperators.getSelectedItem();
        if (rel == null) {
            return null;
        }
        return (String)rel.getValue();
    }

    public void setLogicalOperator(String operator) {
        if (this.ddnLogicalOperators == null) {
            return;
        }
        ComboBoxModel model = this.ddnLogicalOperators.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValue modelValue = (LabeledValue)model.getElementAt(i);
            String value = (String)modelValue.getValue();
            if (!StringUtils.equals((CharSequence)value, (CharSequence)operator)) continue;
            this.ddnLogicalOperators.setSelectedIndex(i);
            break;
        }
    }

    public Object getValue() {
        return this.getValue(true);
    }

    public Object getValue(boolean coerce) {
        Field field = (Field)((Object)this.ddnFields.getSelectedItem());
        if (field == null) {
            return null;
        }
        Object v = this.dateController == null ? this.cboValue.getSelectedItem() : (this.dateController.isValid() ? this.dateController.get() : null);
        if (v == null) {
            return null;
        }
        if (v instanceof LabeledValue && ((v = ((LabeledValue)v).getValue()) == null || v == LOAD_MORE_ELEMENTS)) {
            return null;
        }
        if (v instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)v))) {
            return null;
        }
        if (coerce) {
            Coercion coercion = field.getDescriptor().getDataType().getCoercion();
            try {
                return coercion.coerce(v);
            }
            catch (CoercionException ex) {
                return null;
            }
        }
        return v;
    }

    public void setValue(final Object value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultComboBoxModel model = (DefaultComboBoxModel)SearchConditionFieldController.this.cboValue.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    Object item = model.getElementAt(i);
                    if (!item.equals(value)) continue;
                    SearchConditionFieldController.this.cboValue.setSelectedIndex(i);
                    SearchConditionFieldController.this.valueAssigned = value;
                    return;
                }
                Field field = (Field)((Object)SearchConditionFieldController.this.ddnFields.getSelectedItem());
                if (field != null) {
                    String key;
                    DynObjectValueItem[] availableValues = field.getDescriptor().getAvailableValues();
                    HashMap<String, String> availableValuesMap = new HashMap<String, String>();
                    if (availableValues != null) {
                        for (DynObjectValueItem availableValue : availableValues) {
                            availableValuesMap.put(Objects.toString(availableValue.getValue()), availableValue.getLabel());
                        }
                    }
                    if (value instanceof Date) {
                        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
                        df.setLenient(false);
                        key = df.format(value);
                    } else {
                        key = Objects.toString(value);
                    }
                    String label = availableValuesMap.getOrDefault(key, key);
                    LabeledValueImpl newItem = new LabeledValueImpl(label, value);
                    model.addElement(newItem);
                    SearchConditionFieldController.this.cboValue.setSelectedItem(newItem);
                    SearchConditionFieldController.this.valueAssigned = newItem;
                }
            }
        });
    }

    private Field getCurrentField() {
        Field field = (Field)((Object)this.ddnFields.getSelectedItem());
        return field;
    }

    public int setAttribute(String name) {
        ComboBoxModel model = this.ddnFields.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Field x = (Field)((Object)model.getElementAt(i));
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)((CharSequence)x.getValue()))) continue;
            this.setAttribute(i);
            return i;
        }
        this.setAttribute(-1);
        return -1;
    }

    public void setAttribute(int index) {
        try {
            this.ddnFields.setSelectedIndex(index);
        }
        catch (Exception ex) {
            this.ddnFields.setSelectedIndex(-1);
        }
        this.doUpdateValuesList();
    }

    public int setAttributePath(String[][] pathNames) {
        try {
            int i;
            if (pathNames.length == 1) {
                String[] path = pathNames[pathNames.length - 1];
                String name = path[0];
                int index = this.setAttribute(name);
                if (index == -1) {
                    try {
                        FeatureQuery query;
                        FeatureAttributeDescriptor attrDescriptor = this.store.getDefaultFeatureType().getAttributeDescriptorFromAll(name);
                        if (attrDescriptor == null && (query = this.parameters.getQuery()) != null) {
                            attrDescriptor = query.getExtraColumns().get(name);
                        }
                        if (attrDescriptor == null) {
                            I18nManager i18n = ToolsLocator.getI18nManager();
                            ThreadSafeDialogsManager dialogManager = ToolsSwingLocator.getThreadSafeDialogsManager();
                            dialogManager.messageDialog(i18n.getTranslation("_It_is_not_supported_to_search_through_this_field") + ":\n " + name + "\n" + i18n.getTranslation("_Field_not_found_in_this_table"), "_Warning", 2);
                            this.cboValue.setModel(new DefaultComboBoxModel());
                        } else {
                            FeatureAttributeDescriptor[] attributePath = new FeatureAttributeDescriptor[]{attrDescriptor};
                            this.doAddAndSelect(this.store, attrDescriptor, attributePath);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Not able to set single path into controller", (Throwable)ex);
                        return -1;
                    }
                }
                return index;
            }
            ComboBoxModel model = this.ddnFields.getModel();
            Object[] singleArrayPathNameDescriptors = new String[pathNames.length];
            for (i = 0; i < pathNames.length; ++i) {
                singleArrayPathNameDescriptors[i] = pathNames[i][0];
            }
            for (i = 0; i < model.getSize(); ++i) {
                Field x = (Field)((Object)model.getElementAt(i));
                Object[] arrayDescriptors = new String[x.getPath().length];
                FeatureAttributeDescriptor[] path = x.getPath();
                for (int j = 0; j < path.length; ++j) {
                    arrayDescriptors[j] = path[j].getName();
                }
                if (!Arrays.equals(singleArrayPathNameDescriptors, arrayDescriptors)) continue;
                this.setAttribute(i);
                return i;
            }
            DataManager dataManager = DALLocator.getDataManager();
            String tableName = pathNames[pathNames.length - 1][1];
            FeatureStore theStore = (FeatureStore)dataManager.getStoresRepository().getStore(tableName);
            String attributeName = pathNames[pathNames.length - 1][0];
            if (theStore != null) {
                try {
                    FeatureAttributeDescriptor firstAttr;
                    FeatureAttributeDescriptor attr = theStore.getDefaultFeatureType().getAttributeDescriptor(attributeName);
                    FeatureAttributeDescriptor[] attributePath = new FeatureAttributeDescriptor[2];
                    String firstAttrName = pathNames[0][0];
                    attributePath[0] = firstAttr = this.store.getDefaultFeatureType().getAttributeDescriptor(firstAttrName);
                    attributePath[1] = attr;
                    this.doAddAndSelect(theStore, attr, attributePath);
                    return 19;
                }
                catch (Exception ex) {
                    LOGGER.warn("Not able to set foreign path into controller", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Controller not set.", (Throwable)ex);
        }
        this.setAttribute(-1);
        return -1;
    }

    private boolean isTheSameStore(DataStore store1, DataStore store2) {
        String store1FullName = store1.getFullName();
        String store2FullName = store2.getFullName();
        return StringUtils.equalsIgnoreCase((CharSequence)store1FullName, (CharSequence)store2FullName);
    }

    private String getPrimaryKeyName(FeatureStore store) {
        try {
            FeatureAttributeDescriptor[] pk = store.getDefaultFeatureType().getPrimaryKey();
            if (pk == null || pk.length != 1) {
                return null;
            }
            return pk[0].getName();
        }
        catch (DataException ex) {
            return null;
        }
    }

    private String getForeingKeyName(FeatureStore store, FeatureStore foreingStore) {
        try {
            for (FeatureAttributeDescriptor descriptor : store.getDefaultFeatureType()) {
                ForeingKey foreingKey;
                if (!descriptor.isForeingKey() || !this.isTheSameStore((DataStore)foreingStore, (DataStore)(foreingKey = descriptor.getForeingKey()).getFeatureStore(null))) continue;
                return descriptor.getName();
            }
        }
        catch (DataException ex) {
            return null;
        }
        return null;
    }

    public boolean isValid(StringBuilder message) {
        try {
            Object value = this.getValue();
            if (value == null) {
                return true;
            }
            Field field = this.getCurrentField();
            if (field == null) {
                return true;
            }
            if (field.getPath().length > 2) {
                message.append("Invalid field '").append(field.getLabel()).append("'.\n");
                return false;
            }
            FeatureAttributeDescriptor descriptor = field.getDescriptor();
            switch (this.getRelationalOperator()) {
                case "=": 
                case "<>": 
                case ">": 
                case ">=": 
                case "<": 
                case "<=": {
                    try {
                        descriptor.getDataType().coerce(value);
                        break;
                    }
                    catch (CoercionException ex) {
                        message.append("Invalid value '").append(Objects.toString(value)).append("' for field '").append(descriptor.getLabel()).append("'.");
                        message.append("\n");
                        message.append(ex.getMessage());
                        message.append("\n");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception ex) {
            message.append("Invalid values '").append(ex.toString());
            return false;
        }
    }

    public ExpressionBuilder.Value getFilter() {
        StringBuilder warns = new StringBuilder();
        return this.getFilter(warns);
    }

    public ExpressionBuilder.Value getFilter(StringBuilder warnings) {
        String operator;
        ExpressionBuilder.Value filter = null;
        Field field = this.getCurrentField();
        if (field == null) {
            return null;
        }
        if (field.getPath().length > 2) {
            warnings.append("Lookups are only supported on directly related tables.");
            return null;
        }
        DataManager dataManager = DALLocator.getDataManager();
        DALExpressionBuilder builder = dataManager.createDALExpressionBuilder();
        FeatureAttributeDescriptor parentDescriptor = field.getParentDescriptor();
        FeatureAttributeDescriptor descriptor = field.getDescriptor();
        switch (descriptor.getType()) {
            case 66: {
                filter = this.createGeometryFilter(builder, parentDescriptor, descriptor, field, warnings);
                if (filter == null) {
                    return null;
                }
                filter = builder.expression().group(filter);
                return filter;
            }
        }
        Object value = null;
        ExpressionBuilder.Constant value_constant = null;
        switch (operator = this.getRelationalOperator()) {
            case "IS NULL": {
                value = this.getValue();
                filter = this.getFilterForOperatorNull(parentDescriptor, descriptor, builder, field);
                return filter;
            }
            case "IS NOT NULL": {
                value = this.getValue();
                filter = this.getFilterForOperatorNotNull(parentDescriptor, descriptor, builder, field);
                return filter;
            }
            case "=": 
            case "<>": 
            case ">": 
            case ">=": 
            case "<": 
            case "<=": {
                value = this.getValue();
                if (value == null) {
                    return null;
                }
                try {
                    value_constant = builder.expression().constant(descriptor.getDataType().coerce(value));
                    break;
                }
                catch (CoercionException ex) {
                    return null;
                }
            }
            case "ILIKE": {
                value = this.getValue(false);
                if (value == null) {
                    return null;
                }
                value_constant = builder.expression().constant(value);
                break;
            }
            default: {
                value = this.getValue(false);
                if (value == null) {
                    return null;
                }
                value_constant = builder.expression().constant((Object)("%" + value + "%"));
                operator = "ILIKE";
            }
        }
        ExpressionBuilder.Value fieldOp = null;
        if (parentDescriptor == null) {
            fieldOp = builder.expression().column(this.store.getName(), descriptor.getName());
            if (StringUtils.equalsIgnoreCase((CharSequence)operator, (CharSequence)"ILIKE") && descriptor.getType() != 8) {
                fieldOp = builder.expression().cast(fieldOp, 8);
            }
            filter = builder.expression().binaryOperator(operator, fieldOp, (ExpressionBuilder.Value)value_constant);
            ExpressionBuilder.Value nullValue = builder.expression().column(this.store.getName(), descriptor.getName());
            filter = this.addNullBehavior(builder, filter, nullValue);
        } else {
            switch (parentDescriptor.getRelationType()) {
                case 1: 
                case 2: {
                    fieldOp = builder.foreing_value(parentDescriptor.getName(), descriptor.getName());
                    if (StringUtils.equalsIgnoreCase((CharSequence)operator, (CharSequence)"ILIKE") && descriptor.getType() != 8) {
                        fieldOp = builder.expression().cast(fieldOp, 8);
                    }
                    filter = builder.expression().binaryOperator(operator, fieldOp, (ExpressionBuilder.Value)value_constant);
                    ExpressionBuilder.Function nullValue = builder.foreing_value(parentDescriptor.getName(), descriptor.getName());
                    filter = this.addNullBehavior(builder, filter, (ExpressionBuilder.Value)nullValue);
                    break;
                }
                case 3: 
                case 4: {
                    ExpressionBuilder.BinaryOperator op_composition = null;
                    fieldOp = builder.expression().column(field.getFeatureStore().getName(), descriptor.getName());
                    if (StringUtils.equalsIgnoreCase((CharSequence)operator, (CharSequence)"ILIKE") && descriptor.getType() != 8) {
                        fieldOp = builder.expression().cast(fieldOp, 8);
                    }
                    op_composition = builder.expression().binaryOperator(operator, fieldOp, (ExpressionBuilder.Value)value_constant);
                    ExpressionBuilder.Value null_value = builder.expression().column(field.getFeatureStore().getName(), descriptor.getName());
                    op_composition = this.addNullBehavior(builder, (ExpressionBuilder.Value)op_composition, null_value);
                    filter = this.buildExists(builder, field, (ExpressionBuilder.Value)op_composition);
                }
            }
        }
        filter = builder.expression().group(filter);
        return filter;
    }

    private ExpressionBuilder.Value buildExists(DALExpressionBuilder builder, Field field, ExpressionBuilder.Value op_composition) {
        SQLBuilder.SelectBuilder select = builder.select();
        select.from().table().name(field.getFeatureStore().getName());
        select.column().value((ExpressionBuilder.Value)builder.expression().constant((Object)1));
        select.limit(1L);
        select.where().value((ExpressionBuilder.Value)builder.expression().and((ExpressionBuilder.Value)builder.expression().eq(builder.expression().column(field.getFeatureStore().getName(), this.getForeingKeyName(field.getFeatureStore(), this.store)), builder.expression().column(this.store.getName(), this.getPrimaryKeyName(this.store))), op_composition));
        ExpressionBuilder.Function filter = builder.exists((ExpressionBuilder.Value)select);
        return filter;
    }

    public JsonObject toJson() {
        JsonObjectBuilder fieldBuilder = Json.createObjectBuilder();
        org.gvsig.json.JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        Field currentField = this.getCurrentField();
        FeatureAttributeDescriptor[] path = currentField.getPath();
        for (int i = 0; i < path.length; ++i) {
            FeatureAttributeDescriptor featureAttributeDescriptor = path[i];
            org.gvsig.json.JsonArrayBuilder pathArray = Json.createArrayBuilder();
            String fieldName = featureAttributeDescriptor.getName();
            pathArray.add(fieldName);
            if (i == 0) {
                pathArray.add(this.store.getName());
            } else {
                FeatureType featureType = featureAttributeDescriptor.getFeatureType();
                String storeName = featureType.getStore().getName();
                pathArray.add(storeName);
            }
            arrayBuilder.add((JsonArrayBuilder)pathArray);
        }
        String relational = this.getRelationalOperator();
        Object value = this.getValue(false);
        String strValue = DataTypeUtils.toString((Object)value);
        String logical = this.getLogicalOperator();
        fieldBuilder.add("fieldPath", (JsonArrayBuilder)arrayBuilder);
        fieldBuilder.add("relational", relational);
        if (!StringUtils.isEmpty((CharSequence)strValue)) {
            fieldBuilder.add("strValue", strValue);
        }
        if (!StringUtils.isEmpty((CharSequence)logical)) {
            fieldBuilder.add("logical", logical);
        }
        int nullBehavior = this.getNullBehavior();
        fieldBuilder.add("nullBehavior", nullBehavior);
        fieldBuilder.add("geometryOperandMode", this.geometryOperandMode);
        fieldBuilder.add("geometryOperandStoreName", this.geometryOperandStoreId);
        fieldBuilder.add("geometryOperandConstant", (Object)this.geometryOperandConstant);
        fieldBuilder.add("useBox2dInGeometryOperand", this.useBox2dInGeometryOperand);
        return fieldBuilder.build();
    }

    public void put(SearchParameters params, int index) {
        this.parameters = params;
        Map values = params.getValues();
        if (values == null) {
            return;
        }
        JsonObject panelState = values.getOrDefault("SearchConditionPanelSimplified", null);
        if (panelState == null) {
            return;
        }
        String name = DataTypeUtils.toString((Object)index);
        this.fromJson(panelState.getJsonObject(name));
    }

    public void fromJson(JsonObject jsonState) {
        if (jsonState == null) {
            return;
        }
        JsonArray fieldPath = jsonState.getJsonArray("fieldPath");
        String[][] arrayNew = new String[fieldPath.size()][2];
        for (int i = 0; i < fieldPath.size(); ++i) {
            String[] arrayField = new String[]{fieldPath.getJsonArray(i).getString(0), fieldPath.getJsonArray(i).getString(1)};
            arrayNew[i] = arrayField;
        }
        this.setAttributePath(arrayNew);
        String relational = jsonState.getString("relational");
        this.setRelationalOperator(relational);
        if (jsonState.containsKey((Object)"strValue")) {
            String strValue = jsonState.getString("strValue");
            this.setValue(strValue);
        }
        if (jsonState.containsKey((Object)"logical")) {
            String logical = jsonState.getString("logical");
            this.setLogicalOperator(logical);
        }
        if (jsonState.containsKey((Object)"nullBehavior")) {
            int nullBehavior = jsonState.getInt("nullBehavior");
            this.setNullBehavior(nullBehavior);
        }
        this.geometryOperandMode = jsonState.getInt("geometryOperandMode", 1);
        this.geometryOperandStoreId = jsonState.getString("geometryOperandStoreName", null);
        this.geometryOperandConstant = (Geometry)Json.toObject((JsonObject)jsonState, (String)"geometryOperandConstant");
        this.useBox2dInGeometryOperand = jsonState.getBoolean("geometryOperandStoreName", false);
    }

    public void setUpdateValuesLimits(int limit, int featuresLimit) {
        this.updateValuesTimeLimit = limit;
        this.updateValuesFeaturesLimit = featuresLimit;
        this.doUpdateValuesList();
    }

    public int getNullBehavior() {
        return (Integer)((LabeledValue)this.ddnNullBehavior.getSelectedItem()).getValue();
    }

    public int setNullBehavior(int nullBehaviorValue) {
        LabeledValue nullBehavior;
        int toInt;
        int n = 0;
        LabeledValue[] labeledValueArray = this.nullBehaviors;
        int n2 = labeledValueArray.length;
        for (int i = 0; i < n2 && nullBehaviorValue != (toInt = ((Integer)(nullBehavior = labeledValueArray[i]).getValue()).intValue()); ++i) {
            ++n;
        }
        if (this.nullBehaviors.length <= n) {
            return -1;
        }
        this.ddnNullBehavior.setSelectedIndex(n);
        return n;
    }

    private ExpressionBuilder.Value addNullBehavior(DALExpressionBuilder builder, ExpressionBuilder.Value filter, ExpressionBuilder.Value nullValue) {
        if (this.getRelationalOperator() != "IS NULL" && this.getRelationalOperator() != "IS NOT NULL") {
            if (this.getNullBehavior() == 1) {
                ExpressionBuilder.Function null_function = builder.expression().is_null(nullValue);
                filter = builder.expression().or((ExpressionBuilder.Value)null_function, filter);
            } else if (this.getNullBehavior() == 2) {
                ExpressionBuilder.Function null_function = builder.expression().not_is_null(nullValue);
                filter = builder.expression().and((ExpressionBuilder.Value)null_function, filter);
            }
        }
        return filter;
    }

    private ExpressionBuilder.Value getFilterForOperatorNull(FeatureAttributeDescriptor parentDescriptor, FeatureAttributeDescriptor descriptor, DALExpressionBuilder builder, Field field) {
        ExpressionBuilder.Group filter = null;
        if (parentDescriptor == null) {
            filter = builder.expression().is_null(builder.expression().column(this.store.getName(), descriptor.getName()));
        } else {
            switch (parentDescriptor.getRelationType()) {
                case 1: 
                case 2: {
                    filter = builder.expression().is_null((ExpressionBuilder.Value)builder.foreing_value(parentDescriptor.getName(), descriptor.getName()));
                    break;
                }
                case 3: 
                case 4: {
                    ExpressionBuilder.Function op_composition = null;
                    op_composition = builder.expression().is_null(builder.expression().column(field.getFeatureStore().getName(), descriptor.getName()));
                    filter = this.buildExists(builder, field, (ExpressionBuilder.Value)op_composition);
                }
            }
        }
        filter = builder.expression().group(filter);
        return filter;
    }

    private ExpressionBuilder.Value getFilterForOperatorNotNull(FeatureAttributeDescriptor parentDescriptor, FeatureAttributeDescriptor descriptor, DALExpressionBuilder builder, Field field) {
        ExpressionBuilder.Group filter = null;
        if (parentDescriptor == null) {
            filter = builder.expression().not_is_null(builder.expression().column(this.store.getName(), descriptor.getName()));
        } else {
            switch (parentDescriptor.getRelationType()) {
                case 1: 
                case 2: {
                    filter = builder.expression().not_is_null((ExpressionBuilder.Value)builder.foreing_value(parentDescriptor.getName(), descriptor.getName()));
                    break;
                }
                case 3: 
                case 4: {
                    ExpressionBuilder.Function op_composition = null;
                    op_composition = builder.expression().not_is_null(builder.expression().column(field.getFeatureStore().getName(), descriptor.getName()));
                    filter = this.buildExists(builder, field, (ExpressionBuilder.Value)op_composition);
                }
            }
        }
        filter = builder.expression().group(filter);
        return filter;
    }

    private ExpressionBuilder.Value getFilterForOperatorIsNotValid(FeatureAttributeDescriptor parentDescriptor, FeatureAttributeDescriptor descriptor, DALExpressionBuilder builder, Field field) {
        ExpressionBuilder.Group filter = null;
        if (parentDescriptor == null) {
            filter = builder.expression().not((ExpressionBuilder.Value)builder.expression().ST_IsValid(builder.expression().column(this.store.getName(), descriptor.getName())));
        } else {
            switch (parentDescriptor.getRelationType()) {
                case 1: 
                case 2: {
                    filter = builder.expression().not((ExpressionBuilder.Value)builder.expression().ST_IsValid((ExpressionBuilder.Value)builder.foreing_value(parentDescriptor.getName(), descriptor.getName())));
                    break;
                }
                case 3: 
                case 4: {
                    ExpressionBuilder.Function op_composition = null;
                    op_composition = builder.expression().not((ExpressionBuilder.Value)builder.expression().ST_IsValid(builder.expression().column(field.getFeatureStore().getName(), descriptor.getName())));
                    filter = this.buildExists(builder, field, (ExpressionBuilder.Value)op_composition);
                }
            }
        }
        filter = builder.expression().group(filter);
        return filter;
    }

    private ExpressionBuilder.Value getFilterForOperatorIsNotEmpty(FeatureAttributeDescriptor parentDescriptor, FeatureAttributeDescriptor descriptor, DALExpressionBuilder builder, Field field) {
        ExpressionBuilder.Group filter = null;
        if (parentDescriptor == null) {
            filter = builder.expression().not((ExpressionBuilder.Value)builder.expression().ST_IsEmpty(builder.expression().column(this.store.getName(), descriptor.getName())));
        } else {
            switch (parentDescriptor.getRelationType()) {
                case 1: 
                case 2: {
                    filter = builder.expression().not((ExpressionBuilder.Value)builder.expression().ST_IsEmpty((ExpressionBuilder.Value)builder.foreing_value(parentDescriptor.getName(), descriptor.getName())));
                    break;
                }
                case 3: 
                case 4: {
                    ExpressionBuilder.Function op_composition = null;
                    op_composition = builder.expression().not((ExpressionBuilder.Value)builder.expression().ST_IsEmpty(builder.expression().column(field.getFeatureStore().getName(), descriptor.getName())));
                    filter = this.buildExists(builder, field, (ExpressionBuilder.Value)op_composition);
                }
            }
        }
        filter = builder.expression().group(filter);
        return filter;
    }

    private ExpressionBuilder.Value getFilterForOperatorIsValid(FeatureAttributeDescriptor parentDescriptor, FeatureAttributeDescriptor descriptor, DALExpressionBuilder builder, Field field) {
        ExpressionBuilder.Group filter = null;
        if (parentDescriptor == null) {
            filter = builder.expression().ST_IsValid(builder.expression().column(this.store.getName(), descriptor.getName()));
        } else {
            switch (parentDescriptor.getRelationType()) {
                case 1: 
                case 2: {
                    filter = builder.expression().ST_IsValid((ExpressionBuilder.Value)builder.foreing_value(parentDescriptor.getName(), descriptor.getName()));
                    break;
                }
                case 3: 
                case 4: {
                    ExpressionBuilder.Function op_composition = null;
                    op_composition = builder.expression().ST_IsValid(builder.expression().column(field.getFeatureStore().getName(), descriptor.getName()));
                    filter = this.buildExists(builder, field, (ExpressionBuilder.Value)op_composition);
                }
            }
        }
        filter = builder.expression().group(filter);
        return filter;
    }

    private ExpressionBuilder.Value getFilterForOperatorIsEmpty(FeatureAttributeDescriptor parentDescriptor, FeatureAttributeDescriptor descriptor, DALExpressionBuilder builder, Field field) {
        ExpressionBuilder.Group filter = null;
        if (parentDescriptor == null) {
            filter = builder.expression().ST_IsEmpty(builder.expression().column(this.store.getName(), descriptor.getName()));
        } else {
            switch (parentDescriptor.getRelationType()) {
                case 1: 
                case 2: {
                    filter = builder.expression().ST_IsEmpty((ExpressionBuilder.Value)builder.foreing_value(parentDescriptor.getName(), descriptor.getName()));
                    break;
                }
                case 3: 
                case 4: {
                    ExpressionBuilder.Function op_composition = null;
                    op_composition = builder.expression().ST_IsEmpty(builder.expression().column(field.getFeatureStore().getName(), descriptor.getName()));
                    filter = this.buildExists(builder, field, (ExpressionBuilder.Value)op_composition);
                }
            }
        }
        filter = builder.expression().group(filter);
        return filter;
    }

    private ExpressionBuilder.Value createGeometryFilter(DALExpressionBuilder builder, FeatureAttributeDescriptor parentDescriptor, FeatureAttributeDescriptor descriptor, Field field, StringBuilder warnings) {
        String s;
        String operator;
        ExpressionBuilder.Value filter = null;
        if (parentDescriptor != null) {
            return null;
        }
        Geometry geometry = this.getGeometryOperand(descriptor.getSRS(), warnings);
        switch (operator = this.getRelationalOperator()) {
            case "IS NULL": {
                filter = this.getFilterForOperatorNull(parentDescriptor, descriptor, builder, field);
                break;
            }
            case "IS NOT NULL": {
                filter = this.getFilterForOperatorNotNull(parentDescriptor, descriptor, builder, field);
                break;
            }
            case "ST_IsValid": {
                filter = this.getFilterForOperatorIsValid(parentDescriptor, descriptor, builder, field);
                break;
            }
            case "ST_IsEmpty": {
                filter = this.getFilterForOperatorIsEmpty(parentDescriptor, descriptor, builder, field);
                break;
            }
            case "IsNotValid": {
                filter = this.getFilterForOperatorIsNotValid(parentDescriptor, descriptor, builder, field);
                break;
            }
            case "IsNotEmpty": {
                filter = this.getFilterForOperatorIsNotEmpty(parentDescriptor, descriptor, builder, field);
                break;
            }
            case "IntersectsWithBBox": {
                if (geometry == null) {
                    return null;
                }
                filter = builder.expression().ST_Intersects((ExpressionBuilder.Value)builder.expression().ST_Envelope((ExpressionBuilder.Value)builder.expression().column(descriptor.getName())), (ExpressionBuilder.Value)builder.expression().geometry(geometry));
                break;
            }
            case "ST_Contains": 
            case "ST_Covers": 
            case "ST_CoveredBy": 
            case "ST_Crosses": 
            case "ST_Disjoint": 
            case "ST_Equals": 
            case "ST_Intersects": 
            case "ST_Overlaps": 
            case "ST_Within": 
            case "ST_Touches": {
                if (geometry == null) {
                    return null;
                }
                filter = builder.expression().function(operator, new ExpressionBuilder.Value[]{builder.expression().column(descriptor.getName()), builder.expression().geometry(geometry)});
                break;
            }
            case "ST_IsClosed": {
                filter = builder.expression().function(operator, new ExpressionBuilder.Value[]{builder.expression().column(descriptor.getName())});
                break;
            }
            default: {
                return null;
            }
        }
        if (filter != null && (s = filter.toString()).length() > 10000) {
            warnings.append("There are many selected geometries or they are very large.");
            warnings.append("\n");
        }
        return filter;
    }

    private Geometry getGeometryOperand(IProjection proj, StringBuilder warnings) {
        List<Geometry> geoms;
        switch (this.geometryOperandMode) {
            case 2: {
                geoms = this.getGeometryOperandFromLayerSelection(this.geometryOperandStoreId, warnings);
                break;
            }
            case 3: {
                geoms = this.getGeometryOperandConstant(proj, warnings);
                break;
            }
            case 1: {
                geoms = this.getGeometryOperandFromClipboard(proj, warnings);
                break;
            }
            case 4: {
                geoms = this.getCurrentBoundingBoxGeometry(proj, warnings);
                break;
            }
            default: {
                return null;
            }
        }
        if (geoms == null || geoms.isEmpty()) {
            return null;
        }
        if (geoms.size() == 1) {
            return geoms.get(0);
        }
        Geometry geom = GeometryUtils.toAggregate(geoms, (StringBuilder)warnings);
        if (geom != null && geom.getProjection() == null) {
            geom.setProjection(proj);
        }
        return geom;
    }

    private List<Geometry> getGeometryOperandConstant(IProjection proj, StringBuilder warnings) {
        if (this.geometryOperandConstant == null) {
            warnings.append("The geometry with which to operate has not been indicated");
            warnings.append("\n");
            return null;
        }
        if (this.geometryOperandConstant.getProjection() == null) {
            this.geometryOperandConstant.setProjection(proj);
        }
        return Collections.singletonList(this.geometryOperandConstant);
    }

    private List<Geometry> getGeometryOperandFromClipboard(IProjection proj, StringBuilder warnings) {
        try {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            String s = toolsSwingManager.getFromClipboard();
            if (StringUtils.isBlank((CharSequence)s)) {
                warnings.append("The clipboard is empty");
                warnings.append("\n");
                return null;
            }
            List geom = GeometryUtils.extractFrom((String)s, (IProjection)proj);
            if (geom == null) {
                warnings.append("Can't locate geometries in clipboard");
                warnings.append("\n");
                return null;
            }
            return geom;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get geometry value.", (Throwable)ex);
            warnings.append("Can't extract a geometry from clipboard");
            warnings.append("\n(");
            warnings.append(ex.getLocalizedMessage());
            warnings.append(")\n");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<Geometry> getGeometryOperandFromLayerSelection(String storeId, StringBuilder warnings) {
        ArrayList<Geometry> arrayList;
        String geomAttrName;
        FeatureStore theStore;
        block10: {
            block9: {
                block8: {
                    if (StringUtils.isBlank((CharSequence)storeId)) {
                        return null;
                    }
                    StoresRepository repo = null;
                    theStore = null;
                    repo = DALLocator.getDataManager().getStoresRepository();
                    theStore = (FeatureStore)repo.getStore(storeId);
                    if (theStore != null) break block8;
                    warnings.append("Table not found in project.");
                    warnings.append("\n");
                    List<Geometry> list = null;
                    DisposeUtils.dispose((Disposable)theStore);
                    return list;
                }
                geomAttrName = theStore.getDefaultFeatureTypeQuietly().getDefaultGeometryAttributeName();
                if (!StringUtils.isEmpty((CharSequence)geomAttrName)) break block9;
                warnings.append("The selected table can't have geometries");
                warnings.append("\n");
                List<Geometry> list = null;
                DisposeUtils.dispose((Disposable)theStore);
                return list;
            }
            if (!theStore.isFeatureSelectionEmpty()) break block10;
            warnings.append("The selection of the selected table is empty.");
            warnings.append("\n");
            List<Geometry> list = null;
            DisposeUtils.dispose((Disposable)theStore);
            return list;
        }
        try {
            Iterator it = theStore.getFeatureSelectionQuietly().referenceIterator();
            ArrayList<Geometry> geoms = new ArrayList<Geometry>();
            for (Feature feature : theStore.getFeaturesIterable(it)) {
                if (this.useBox2dInGeometryOperand) {
                    geoms.add(feature.getGeometry(geomAttrName).getEnvelope().getBox2D());
                    continue;
                }
                geoms.add(feature.getGeometry(geomAttrName));
            }
            arrayList = geoms;
        }
        catch (Throwable throwable) {
            DisposeUtils.dispose(theStore);
            throw throwable;
        }
        DisposeUtils.dispose((Disposable)theStore);
        return arrayList;
    }

    private void doSelectGeometryOperand() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        SelectGeometryPanel panel = new SelectGeometryPanel();
        Dialog dialog = windowManager.createDialog((JComponent)panel, i18n.getTranslation("_Indicate_where_to_obtain_the_geometries"), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                this.geometryOperandMode = panel.getMode();
                this.geometryOperandConstant = panel.getGeometry();
                this.geometryOperandStoreId = panel.getStoreId();
                this.useBox2dInGeometryOperand = panel.useBox2dInGeometryOperand();
                this.doUpdateCurrentValue();
            }
        });
        panel.setMode(this.geometryOperandMode);
        panel.setGeometry(this.geometryOperandConstant);
        panel.setStoreId(this.geometryOperandStoreId);
        panel.setUseBox2dInGeometryOperand(this.useBox2dInGeometryOperand);
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public String getWarnings() {
        StringBuilder warns = new StringBuilder();
        ExpressionBuilder.Value filter = this.getFilter(warns);
        String s = warns.toString();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s;
    }

    private List<Geometry> getCurrentBoundingBoxGeometry(IProjection proj, StringBuilder warnings) {
        Envelope env;
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        Supplier bbox = dataSwingManager.getCurrentBoundingBox();
        if (bbox != null && (env = (Envelope)bbox.get()) != null && !env.isEmpty() && !env.isCollapsed()) {
            return Collections.singletonList(env.getGeometry());
        }
        return null;
    }

    private static class Field
    extends LabeledValueImpl<String> {
        FeatureAttributeDescriptor attrdesc;
        private final FeatureStore store;
        private final int presentationMode;
        private final boolean showStoreName;
        private final FeatureAttributeDescriptor[] path;

        public Field(FeatureAttributeDescriptor[] path, FeatureStore store, FeatureAttributeDescriptor attrdesc, int presentationMode) {
            this(path, store, attrdesc, presentationMode, false);
        }

        public Field(FeatureAttributeDescriptor[] path, FeatureStore store, FeatureAttributeDescriptor attrdesc, int presentationMode, boolean showStoreName) {
            super(DALSwingLocator.getDataSwingManager().getAttributeDescriptorLabel(attrdesc, store.getName()), (Object)attrdesc.getName());
            this.path = path;
            this.store = store;
            this.attrdesc = attrdesc;
            this.presentationMode = presentationMode;
            this.showStoreName = showStoreName;
        }

        public FeatureAttributeDescriptor[] getPath() {
            return this.path;
        }

        public String getLabel() {
            String theLabel;
            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
            FeatureAttributeDescriptor parentDescriptor = this.getParentDescriptor();
            if (parentDescriptor == null) {
                theLabel = dataSwingManager.getAttributeDescriptorLabel(this.attrdesc, this.showStoreName ? this.store.getName() : null);
            } else {
                switch (parentDescriptor.getRelationType()) {
                    case 1: 
                    case 2: {
                        theLabel = dataSwingManager.getAttributeDescriptorLabel(this.attrdesc) + " de " + this.store.getName();
                        break;
                    }
                    case 3: 
                    case 4: {
                        theLabel = "\u2203 " + this.store.getName() + " que " + dataSwingManager.getAttributeDescriptorLabel(this.attrdesc);
                        break;
                    }
                    default: {
                        theLabel = dataSwingManager.getAttributeDescriptorLabel(this.attrdesc, this.showStoreName ? this.store.getName() : null);
                    }
                }
            }
            switch (this.presentationMode) {
                case 0: {
                    break;
                }
                case 2: {
                    theLabel = "<html><b>" + theLabel + "</b></html>";
                    break;
                }
                case 1: {
                    theLabel = "<html><i><b>" + theLabel + "</b></i></html>";
                }
            }
            return theLabel;
        }

        public FeatureAttributeDescriptor getParentDescriptor() {
            int l = this.path.length;
            if (l < 2) {
                return null;
            }
            return this.path[l - 2];
        }

        public FeatureAttributeDescriptor getDescriptor() {
            return this.attrdesc;
        }

        public FeatureStore getFeatureStore() {
            return this.store;
        }
    }

    private class UpdateValueList
    implements Runnable,
    CancellableTask {
        private final Field field;
        private boolean cancelled;

        public UpdateValueList(Field field) {
            this.field = field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Loose catch block
         */
        @Override
        public void run() {
            MutableBoolean canHasMoreElements;
            DefaultComboBoxModel<Object> model;
            ArrayList values;
            FeatureSet set;
            FeatureQuery query;
            FeatureStore theStore;
            block22: {
                if (this.isCancellationRequested()) {
                    return;
                }
                theStore = this.field.getFeatureStore();
                query = theStore.createFeatureQuery();
                query.addAttributeName(this.field.getDescriptor().getName());
                query.setFilter("");
                query.setLimit((long)SearchConditionFieldController.this.updateValuesFeaturesLimit);
                query.getGroupByColumns().clear();
                query.getAggregateFunctions().clear();
                set = null;
                values = new ArrayList();
                model = new DefaultComboBoxModel<Object>();
                canHasMoreElements = new MutableBoolean();
                canHasMoreElements.setFalse();
                if (!this.isCancellationRequested()) break block22;
                DisposeUtils.disposeQuietly(set);
                return;
            }
            try {
                set = theStore.getFeatureSet(query);
                if (set.size() >= SearchConditionFieldController.this.updateValuesFeaturesLimit) {
                    canHasMoreElements.setTrue();
                }
                long timeLimit = System.currentTimeMillis() + (long)(SearchConditionFieldController.this.updateValuesTimeLimit * 1000);
                set.accept(o -> {
                    if (this.isCancellationRequested()) {
                        throw new VisitCanceledException();
                    }
                    Object value = ((Feature)o).get(this.field.getDescriptor().getName());
                    if (value != null && !values.contains(value)) {
                        values.add(value);
                    }
                    if (System.currentTimeMillis() > timeLimit) {
                        canHasMoreElements.setTrue();
                        throw new VisitCanceledException();
                    }
                    if (values.size() > SearchConditionFieldController.this.updateValuesFeaturesLimit) {
                        canHasMoreElements.setTrue();
                        throw new VisitCanceledException();
                    }
                });
                DisposeUtils.disposeQuietly((Disposable)set);
            }
            catch (VisitCanceledException ex) {
                canHasMoreElements.setTrue();
            }
            catch (Exception ex2) {
                canHasMoreElements.setFalse();
                LOGGER.warn("Can't update list of values of '" + this.field.getLabel() + "'.", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)set);
            }
            finally {
                DisposeUtils.disposeQuietly(set);
            }
            if (this.isCancellationRequested()) {
                return;
            }
            ArrayList<LabeledValueImpl> elements = new ArrayList<LabeledValueImpl>();
            if (!values.isEmpty()) {
                DynObjectValueItem[] availableValues = this.field.getDescriptor().getAvailableValues();
                HashMap<String, String> availableValuesMap = new HashMap<String, String>();
                if (availableValues != null) {
                    for (DynObjectValueItem availableValue : availableValues) {
                        availableValuesMap.put(Objects.toString(availableValue.getValue()), availableValue.getLabel());
                    }
                }
                elements.add(new LabeledValueImpl("", null, 70));
                for (Object value : values) {
                    String key = DataTypeUtils.toString(value);
                    String label = availableValuesMap.getOrDefault(key, key);
                    elements.add(new LabeledValueImpl(label, value, 70));
                }
                CompareUtils.NullSafeComparator comparator = null;
                if (availableValues == null) {
                    switch (this.field.getDescriptor().getType()) {
                        case 9: 
                        case 10: 
                        case 11: {
                            comparator = new CompareUtils.NullSafeComparator(){

                                public int safeCompare(Object o1, Object o2) {
                                    Comparable v2;
                                    Comparable v1 = (Comparable)((LabeledValue)o1).getValue();
                                    if (v1 == (v2 = (Comparable)((LabeledValue)o2).getValue())) {
                                        return 0;
                                    }
                                    if (v1 == null) {
                                        return -1;
                                    }
                                    if (v2 == null) {
                                        return 1;
                                    }
                                    return v1.compareTo(v2);
                                }
                            };
                        }
                    }
                }
                elements.sort((Comparator<LabeledValueImpl>)comparator);
            }
            for (LabeledValue element : elements) {
                model.addElement(element);
            }
            if (canHasMoreElements.isTrue()) {
                model.addElement(new LabeledValueImpl("...", (Object)LOAD_MORE_ELEMENTS));
            }
            if (this.isCancellationRequested()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (UpdateValueList.this.isCancellationRequested()) {
                        return;
                    }
                    SearchConditionFieldController.this.setEnabled(false);
                    Dimension sz = SearchConditionFieldController.this.cboValue.getPreferredSize();
                    SearchConditionFieldController.this.cboValue.setModel(model);
                    SearchConditionFieldController.this.cboValue.setPreferredSize(sz);
                    if (SearchConditionFieldController.this.valueAssigned != null) {
                        SearchConditionFieldController.this.cboValue.setSelectedItem(SearchConditionFieldController.this.valueAssigned);
                        SearchConditionFieldController.this.valueAssigned = null;
                    }
                    SearchConditionFieldController.this.setEnabled(true);
                }
            });
        }

        public boolean isCancellationRequested() {
            return this.cancelled;
        }

        public void cancelRequest() {
            this.cancelled = true;
        }
    }
}

