/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlpull.prov.stax.stream;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;
import org.gvsig.xmlpull.prov.stax.stream.StaxQName;

public class StaxXmlStreamReader
implements IXmlStreamReader {
    private XMLStreamReader parser;

    public StaxXmlStreamReader(InputStream in) throws XmlStreamException {
        this.setInput(in);
    }

    private void setInput(InputStream inputStream) throws XmlStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.parser = factory.createXMLStreamReader(inputStream, null);
        }
        catch (XMLStreamException e) {
            Throwable nestedException = e.getNestedException();
            String msg = "Error creating StAX parser: " + e.getMessage();
            if (nestedException != null) {
                msg = msg + "(" + nestedException.getMessage() + ")";
            }
            throw new XmlStreamException(msg, (Throwable)e);
        }
    }

    public int getAttributeCount() throws XmlStreamException {
        return this.parser.getAttributeCount();
    }

    public IQName getAttributeName(int i) throws XmlStreamException {
        return new StaxQName(this.parser.getAttributeName(i));
    }

    public String getAttributeValue(int i) throws XmlStreamException {
        return this.parser.getAttributeValue(i);
    }

    public int getEventType() throws XmlStreamException {
        int xmlPullEventType = this.parser.getEventType();
        return this.pullEventToGpeEventType(xmlPullEventType);
    }

    public IQName getName() throws XmlStreamException {
        int eventType = this.parser.getEventType();
        if (eventType != 1 && eventType != 2) {
            return null;
        }
        return new StaxQName(this.parser.getName());
    }

    public String getText() throws XmlStreamException {
        return this.parser.getText();
    }

    public boolean isWhitespace() throws XmlStreamException {
        return this.parser.isWhiteSpace();
    }

    public int next() throws XmlStreamException {
        int xmlPullEventType;
        try {
            xmlPullEventType = this.parser.next();
        }
        catch (XMLStreamException e) {
            String msg = "Failed to call XmlStreamReader.next()";
            if (e.getNestedException() != null) {
                msg = msg + ": " + e.getNestedException().getMessage();
            }
            throw new XmlStreamException(msg, e.getNestedException() == null ? e : e.getNestedException());
        }
        int pullEventToGpeEventType = this.pullEventToGpeEventType(xmlPullEventType);
        return pullEventToGpeEventType;
    }

    public int nextTag() throws XmlStreamException {
        int xmlPullEventType;
        try {
            xmlPullEventType = this.parser.nextTag();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new XmlStreamException((Throwable)e);
        }
        int pullEventToGpeEventType = this.pullEventToGpeEventType(xmlPullEventType);
        return pullEventToGpeEventType;
    }

    private int pullEventToGpeEventType(int xmlPullEventType) {
        switch (xmlPullEventType) {
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 12: {
                return 12;
            }
            case 9: {
                return 9;
            }
            case 6: {
                return 6;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 11: {
                return 11;
            }
        }
        throw new IllegalStateException("Unknown tag type, this should't happen!: " + xmlPullEventType);
    }
}

