/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.jml.JMLObjectOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public abstract class JETAProperty
extends AbstractJETAPersistable {
    static final long serialVersionUID = -7709719636185198546L;
    public static final int VERSION = 1;
    private String m_name;
    private Class m_type;
    private transient boolean m_preferred = true;

    public JETAProperty() {
        this(null);
    }

    public JETAProperty(String name) {
        this.m_name = name;
    }

    public boolean equals(Object object) {
        if (object instanceof JETAProperty) {
            JETAProperty jp = (JETAProperty)object;
            return super.equals(object) && JETAProperty.isEqual(this.m_name, jp.m_name) && JETAProperty.isEqual(this.m_type, jp.m_type) && this.m_preferred == jp.m_preferred;
        }
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    protected static boolean isCollectionsEqual(Collection c1, Collection c2) {
        if (c1 != null) {
            if (c2 == null || c1.size() != c2.size()) {
                return false;
            }
            Iterator i1 = c1.iterator();
            Iterator i2 = c2.iterator();
            while (i1.hasNext()) {
                if (i1.next().equals(i2.next())) continue;
                return false;
            }
            return true;
        }
        return c2 == null;
    }

    protected static boolean isEqual(Object o1, Object o2) {
        if (o1 instanceof Collection && o2 instanceof Collection) {
            return JETAProperty.isCollectionsEqual((Collection)o1, (Collection)o2);
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    public boolean isPreferred() {
        return this.m_preferred;
    }

    public boolean isTransient() {
        return false;
    }

    public void postInitialize(FormPanel panel, JETABean jbean) {
    }

    public void setPreferred(boolean pref) {
        this.m_preferred = pref;
    }

    public abstract void setValue(Object var1);

    public abstract void updateBean(JETABean var1);

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        int version = in.readVersion();
        this.m_name = in.readString("name");
        Class type = (Class)in.readObject("type");
    }

    public void write(JETAObjectOutput out) throws IOException {
        if (!(out instanceof JMLObjectOutput)) {
            out.writeVersion(1);
        }
        out.writeObject("name", this.m_name);
        if (!(out instanceof JMLObjectOutput)) {
            out.writeObject("type", this.m_type);
        }
    }
}

