/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.cts;

import java.awt.geom.Point2D;
import org.cresques.cts.IProjection;

public class GeoCalc {
    IProjection proj;

    public GeoCalc(IProjection proj) {
        this.proj = proj;
    }

    public double distanceGeo(Point2D pt1, Point2D pt2) {
        double R2 = Math.pow(this.proj.getDatum().getESemiMajorAxis(), 2.0);
        double dLat = Math.toRadians(pt2.getY() - pt1.getY());
        double dLong = Math.toRadians(pt2.getX() - pt1.getX());
        double alfa = Math.toRadians(pt1.getY());
        double alfa2 = Math.toRadians(pt2.getY());
        if (Math.abs(alfa2) < Math.abs(alfa)) {
            alfa = alfa2;
        }
        double ds2 = R2 * dLat * dLat + R2 * Math.cos(alfa) * Math.cos(alfa) * dLong * dLong;
        return Math.sqrt(ds2);
    }

    public double distanceEli(Point2D pt1, Point2D pt2) {
        double lat1 = Math.toRadians(pt1.getY());
        double lon1 = -Math.toRadians(pt1.getX());
        double lat2 = Math.toRadians(pt2.getY());
        double lon2 = -Math.toRadians(pt2.getX());
        double F = (lat1 + lat2) / 2.0;
        double G = (lat1 - lat2) / 2.0;
        double L = (lon1 - lon2) / 2.0;
        double sing = Math.sin(G);
        double cosl = Math.cos(L);
        double cosf = Math.cos(F);
        double sinl = Math.sin(L);
        double sinf = Math.sin(F);
        double cosg = Math.cos(G);
        double flat = 1.0 / this.proj.getDatum().getEIFlattening();
        double S = sing * sing * cosl * cosl + cosf * cosf * sinl * sinl;
        double C = cosg * cosg * cosl * cosl + sinf * sinf * sinl * sinl;
        double W = Math.atan2(Math.sqrt(S), Math.sqrt(C));
        double R = Math.sqrt(S * C) / W;
        double H1 = (3.0 * R - 1.0) / (2.0 * C);
        double H2 = (3.0 * R + 1.0) / (2.0 * S);
        double D = 2.0 * W * this.proj.getDatum().getESemiMajorAxis();
        return D * (1.0 + flat * H1 * sinf * sinf * cosg * cosg - flat * H2 * cosf * cosf * sing * sing);
    }

    public double distanceVincenty(Point2D pt1, Point2D pt2) {
        return this.distanceAzimutVincenty((Point2D)pt1, (Point2D)pt2).dist;
    }

    protected GeoData distanceAzimutVincenty(Point2D pt1, Point2D pt2) {
        GeoData gd = new GeoData(0.0, 0.0);
        double f = 1.0 / this.proj.getDatum().getEIFlattening();
        double a = this.proj.getDatum().getESemiMajorAxis();
        double phi1 = pt1.getY();
        double lembda1 = pt1.getX();
        double phi2 = pt2.getY();
        double lembda2 = pt2.getX();
        if (Math.abs(phi2 - phi1) < 1.0E-8 && Math.abs(lembda2 - lembda1) < 1.0E-8) {
            return gd;
        }
        double piD4 = Math.atan(1.0);
        double two_pi = piD4 * 8.0;
        phi1 = phi1 * piD4 / 45.0;
        lembda1 = lembda1 * piD4 / 45.0;
        phi2 = phi2 * piD4 / 45.0;
        lembda2 = lembda2 * piD4 / 45.0;
        double b = a * (1.0 - f);
        double TanU1 = (1.0 - f) * Math.tan(phi1);
        double TanU2 = (1.0 - f) * Math.tan(phi2);
        double U1 = Math.atan(TanU1);
        double U2 = Math.atan(TanU2);
        double lembda = lembda2 - lembda1;
        double last_lembda = -4000000.0;
        double omega = lembda;
        double Sin_sigma = 0.0;
        double Cos_sigma = 0.0;
        double Cos2sigma_m = 0.0;
        double alpha = 0.0;
        double sigma = 0.0;
        double sqr_sin_sigma = 0.0;
        while (last_lembda < -3000000.0 || lembda != 0.0 && Math.abs((last_lembda - lembda) / lembda) > 1.0E-9) {
            sqr_sin_sigma = Math.pow(Math.cos(U2) * Math.sin(lembda), 2.0) + Math.pow(Math.cos(U1) * Math.sin(U2) - Math.sin(U1) * Math.cos(U2) * Math.cos(lembda), 2.0);
            Sin_sigma = Math.sqrt(sqr_sin_sigma);
            Cos_sigma = Math.sin(U1) * Math.sin(U2) + Math.cos(U1) * Math.cos(U2) * Math.cos(lembda);
            sigma = Math.atan2(Sin_sigma, Cos_sigma);
            double Sin_alpha = Math.cos(U1) * Math.cos(U2) * Math.sin(lembda) / Math.sin(sigma);
            alpha = Math.asin(Sin_alpha);
            Cos2sigma_m = Math.cos(sigma) - 2.0 * Math.sin(U1) * Math.sin(U2) / Math.pow(Math.cos(alpha), 2.0);
            double C = f / 16.0 * Math.pow(Math.cos(alpha), 2.0) * (4.0 + f * (4.0 - 3.0 * Math.pow(Math.cos(alpha), 2.0)));
            last_lembda = lembda;
            lembda = omega + (1.0 - C) * f * Math.sin(alpha) * (sigma + C * Math.sin(sigma) * (Cos2sigma_m + C * Math.cos(sigma) * (-1.0 + 2.0 * Math.pow(Cos2sigma_m, 2.0))));
        }
        double u2 = Math.pow(Math.cos(alpha), 2.0) * (a * a - b * b) / (b * b);
        double A = 1.0 + u2 / 16384.0 * (4096.0 + u2 * (-768.0 + u2 * (320.0 - 175.0 * u2)));
        double B = u2 / 1024.0 * (256.0 + u2 * (-128.0 + u2 * (74.0 - 47.0 * u2)));
        double delta_sigma = B * Sin_sigma * (Cos2sigma_m + B / 4.0 * (Cos_sigma * (-1.0 + 2.0 * Math.pow(Cos2sigma_m, 2.0)) - B / 6.0 * Cos2sigma_m * (-3.0 + 4.0 * sqr_sin_sigma) * (-3.0 + 4.0 * Math.pow(Cos2sigma_m, 2.0))));
        double s = b * A * (sigma - delta_sigma);
        double alpha12 = Math.atan2(Math.cos(U2) * Math.sin(lembda), Math.cos(U1) * Math.sin(U2) - Math.sin(U1) * Math.cos(U2) * Math.cos(lembda));
        double alpha21 = Math.atan2(Math.cos(U1) * Math.sin(lembda), -Math.sin(U1) * Math.cos(U2) + Math.cos(U1) * Math.sin(U2) * Math.cos(lembda));
        if (alpha12 < 0.0) {
            alpha12 += two_pi;
        }
        if (alpha12 > two_pi) {
            alpha12 -= two_pi;
        }
        if ((alpha21 += two_pi / 2.0) < 0.0) {
            alpha21 += two_pi;
        }
        if (alpha21 > two_pi) {
            alpha21 -= two_pi;
        }
        alpha12 = alpha12 * 45.0 / piD4;
        alpha21 = alpha21 * 45.0 / piD4;
        return new GeoData(0.0, 0.0, s, alpha12, alpha21);
    }

    protected GeoData getPointVincenty(Point2D pt, double azimut, double dist) {
        GeoData ret = new GeoData(0.0, 0.0);
        double f = 1.0 / this.proj.getDatum().getEIFlattening();
        double a = this.proj.getDatum().getESemiMajorAxis();
        double phi1 = pt.getY();
        double lembda1 = pt.getX();
        double alpha12 = azimut;
        double s = dist;
        double piD4 = Math.atan(1.0);
        double two_pi = piD4 * 8.0;
        phi1 = phi1 * piD4 / 45.0;
        lembda1 = lembda1 * piD4 / 45.0;
        if ((alpha12 = alpha12 * piD4 / 45.0) < 0.0) {
            alpha12 += two_pi;
        }
        if (alpha12 > two_pi) {
            alpha12 -= two_pi;
        }
        double b = a * (1.0 - f);
        double TanU1 = (1.0 - f) * Math.tan(phi1);
        double U1 = Math.atan(TanU1);
        double sigma1 = Math.atan2(TanU1, Math.cos(alpha12));
        double Sinalpha = Math.cos(U1) * Math.sin(alpha12);
        double cosalpha_sq = 1.0 - Sinalpha * Sinalpha;
        double u2 = cosalpha_sq * (a * a - b * b) / (b * b);
        double A = 1.0 + u2 / 16384.0 * (4096.0 + u2 * (-768.0 + u2 * (320.0 - 175.0 * u2)));
        double B = u2 / 1024.0 * (256.0 + u2 * (-128.0 + u2 * (74.0 - 47.0 * u2)));
        double sigma = s / (b * A);
        double last_sigma = 2.0 * sigma + 2.0;
        double two_sigma_m = 0.0;
        while (Math.abs((last_sigma - sigma) / sigma) > 1.0E-9) {
            two_sigma_m = 2.0 * sigma1 + sigma;
            double delta_sigma = B * Math.sin(sigma) * (Math.cos(two_sigma_m) + B / 4.0 * (Math.cos(sigma) * (-1.0 + 2.0 * Math.pow(Math.cos(two_sigma_m), 2.0) - B / 6.0 * Math.cos(two_sigma_m) * (-3.0 + 4.0 * Math.pow(Math.sin(sigma), 2.0)) * (-3.0 + 4.0 * Math.pow(Math.cos(two_sigma_m), 2.0)))));
            last_sigma = sigma;
            sigma = s / (b * A) + delta_sigma;
        }
        double phi2 = Math.atan2(Math.sin(U1) * Math.cos(sigma) + Math.cos(U1) * Math.sin(sigma) * Math.cos(alpha12), (1.0 - f) * Math.sqrt(Math.pow(Sinalpha, 2.0) + Math.pow(Math.sin(U1) * Math.sin(sigma) - Math.cos(U1) * Math.cos(sigma) * Math.cos(alpha12), 2.0)));
        double lembda = Math.atan2(Math.sin(sigma) * Math.sin(alpha12), Math.cos(U1) * Math.cos(sigma) - Math.sin(U1) * Math.sin(sigma) * Math.cos(alpha12));
        double C = f / 16.0 * cosalpha_sq * (4.0 + f * (4.0 - 3.0 * cosalpha_sq));
        double omega = lembda - (1.0 - C) * f * Sinalpha * (sigma + C * Math.sin(sigma) * (Math.cos(two_sigma_m) + C * Math.cos(sigma) * (-1.0 + 2.0 * Math.pow(Math.cos(two_sigma_m), 2.0))));
        double lembda2 = lembda1 + omega;
        double alpha21 = Math.atan2(Sinalpha, -Math.sin(U1) * Math.sin(sigma) + Math.cos(U1) * Math.cos(sigma) * Math.cos(alpha12));
        if ((alpha21 += two_pi / 2.0) < 0.0) {
            alpha21 += two_pi;
        }
        if (alpha21 > two_pi) {
            alpha21 -= two_pi;
        }
        phi2 = phi2 * 45.0 / piD4;
        lembda2 = lembda2 * 45.0 / piD4;
        alpha21 = alpha21 * 45.0 / piD4;
        ret.pt = new Point2D.Double(lembda2, phi2);
        ret.azimut = alpha21;
        return ret;
    }

    public double surfaceSphere(Point2D pt1, Point2D pt2, Point2D pt3) {
        double sup = -1.0;
        double A = this.distanceGeo(pt1, pt2);
        double B = this.distanceGeo(pt2, pt3);
        double C = this.distanceGeo(pt3, pt1);
        sup = (A + B + C - Math.toRadians(180.0)) * Math.PI * this.proj.getDatum().getESemiMajorAxis() / Math.toRadians(180.0);
        return sup;
    }

    protected class GeoData {
        Point2D pt;
        double azimut;
        double revAzimut;
        double dist;

        public GeoData(double x, double y) {
            this.pt = new Point2D.Double(x, y);
            this.dist = 0.0;
            this.revAzimut = 0.0;
            this.azimut = 0.0;
        }

        public GeoData(double x, double y, double dist, double azi, double rAzi) {
            this.pt = new Point2D.Double(x, y);
            this.azimut = azi;
            this.revAzimut = rAzi;
            this.dist = dist;
        }
    }
}

