/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.BorderProperty;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.ColorProxy;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class EtchedBorderProperty
extends BorderProperty {
    static final long serialVersionUID = -8742021440405641715L;
    public static final int VERSION = 2;
    private int m_type;
    private ColorProperty m_highlightColor = new ColorProperty("default");
    private ColorProperty m_shadowColor = new ColorProperty("default");
    static final /* synthetic */ boolean $assertionsDisabled;

    public EtchedBorderProperty() {
        this.setBorder(new EtchedBorder(0));
    }

    public EtchedBorderProperty(int etchType) {
        this.setBorder(new EtchedBorder(etchType));
    }

    public Border createBorder(Component comp) {
        ColorProxy h = null;
        ColorProxy s = null;
        ColorProperty cprop = this.getHighlightColorProperty();
        if (!cprop.getColorKey().equals("default") && cprop.getColor() != null) {
            h = new ColorProxy(cprop);
        }
        if (!(cprop = this.getShadowColorProperty()).getColorKey().equals("default") && cprop.getColor() != null) {
            s = new ColorProxy(cprop);
        }
        EtchedBorder b = new EtchedBorder(this.getEtchType(), h, s);
        return this.createTitle(b);
    }

    public int getEtchType() {
        return this.m_type;
    }

    public Color getHighlightColor() {
        return this.m_highlightColor.getColor();
    }

    public Color getShadowColor() {
        return this.m_shadowColor.getColor();
    }

    public ColorProperty getHighlightColorProperty() {
        return this.m_highlightColor;
    }

    public ColorProperty getShadowColorProperty() {
        return this.m_shadowColor;
    }

    public void setBorder(EtchedBorder bb) {
        this.m_type = bb.getEtchType();
    }

    public void setEtchType(int type) {
        this.m_type = type;
    }

    public void setHighlightColorProperty(ColorProperty c) {
        this.m_highlightColor = c;
    }

    public void setShadowColorProperty(ColorProperty c) {
        this.m_shadowColor = c;
    }

    public void setValue(Object prop) {
        super.setValue(prop);
        if (prop instanceof EtchedBorderProperty) {
            EtchedBorderProperty bp = (EtchedBorderProperty)prop;
            this.m_type = bp.m_type;
            this.m_highlightColor = bp.m_highlightColor;
            this.m_shadowColor = bp.m_shadowColor;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_type = in.readInt("type");
        if (version == 1) {
            this.m_highlightColor.setConstantColor((Color)in.readObject("highlightclor"));
            this.m_shadowColor.setConstantColor((Color)in.readObject("shadowcolor"));
        } else {
            this.m_highlightColor.setValue((ColorProperty)in.readObject("highlightcolor"));
            this.m_shadowColor.setValue((ColorProperty)in.readObject("shadowcolor"));
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(BorderProperty.class));
        out.writeVersion(2);
        out.writeInt("type", this.m_type);
        out.writeObject("highlightcolor", this.m_highlightColor);
        out.writeObject("shadowcolor", this.m_shadowColor);
    }

    public String toString() {
        return "ETCHED";
    }

    static {
        $assertionsDisabled = !EtchedBorderProperty.class.desiredAssertionStatus();
    }
}

