/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.time.DefaultDimension;
import org.gvsig.raster.wms.io.time.RemoteTimeDimension;
import org.gvsig.raster.wms.io.time.TimeDimension;
import org.gvsig.remoteclient.wms.WMSStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class WMSLayerNode
implements Persistent {
    private String _name = null;
    private String _title = null;
    private List<String> srs = null;
    private boolean queryable;
    private boolean transparency;
    private String lAbstract = null;
    private String latLonBox = null;
    private int selectedStyleIndex = 0;
    private List<RemoteWMSStyle> styles = new ArrayList<RemoteWMSStyle>();
    private List<RemoteTimeDimension> dimensions = null;
    private List<String> keywords = null;
    private List<WMSLayerNode> children = new ArrayList<WMSLayerNode>();
    private WMSLayerNode _parent = null;
    private Dimension fixedSize = null;

    public void loadFromState(PersistentState state) throws PersistenceException {
        this._name = state.getString("_name");
        this._title = state.getString("_title");
        this.srs = state.getList("srs");
        this.queryable = state.getBoolean("queryable");
        this.transparency = state.getBoolean("transparency");
        this.lAbstract = state.getString("lAbstract");
        this.latLonBox = state.getString("latLonBox");
        this.selectedStyleIndex = state.getInt("selectedStyleIndex");
        this.styles = state.getList("styles");
        this.dimensions = state.getList("dimensions");
        this.keywords = state.getList("keywords");
        this.children = state.getList("children");
        this._parent = (WMSLayerNode)state.get("_parent");
        this.fixedSize = (Dimension)state.get("fixedSize");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("_name", this._name);
        state.set("_title", this._title);
        state.set("srs", this.srs);
        state.set("queryable", this.queryable);
        state.set("transparency", this.transparency);
        state.set("lAbstract", this.lAbstract);
        state.set("latLonBox", this.latLonBox);
        state.set("selectedStyleIndex", this.selectedStyleIndex);
        state.set("styles", this.styles);
        state.set("dimensions", this.dimensions);
        state.set("keywords", this.keywords);
        state.set("children", this.children);
        state.set("_parent", (Persistent)this._parent);
        state.set("fixedSize", (Object)this.fixedSize);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("WMSLayerNode_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(WMSLayerNode.class, "WMSLayerNode_Persistent", "WMSLayerNode Persistence", null, null);
        }
        definition.addDynFieldString("_name").setMandatory(false);
        definition.addDynFieldString("_title").setMandatory(false);
        definition.addDynFieldList("srs").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldBoolean("queryable").setMandatory(false);
        definition.addDynFieldBoolean("transparency").setMandatory(false);
        definition.addDynFieldString("lAbstract").setMandatory(false);
        definition.addDynFieldString("latLonBox").setMandatory(false);
        definition.addDynFieldInt("selectedStyleIndex").setMandatory(false);
        definition.addDynFieldList("styles").setClassOfItems(RemoteWMSStyle.class).setMandatory(false);
        definition.addDynFieldList("dimensions").setClassOfItems(RemoteTimeDimension.class).setMandatory(false);
        definition.addDynFieldList("keywords").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldList("children").setClassOfItems(WMSLayerNode.class).setMandatory(false);
        definition.addDynFieldObject("_parent").setClassOfValue(WMSLayerNode.class).setMandatory(false);
        definition.addDynFieldObject("fixedSize").setClassOfValue(Dimension.class).setMandatory(false);
    }

    public String getName() {
        return this._name;
    }

    public List<WMSLayerNode> getChildren() {
        return this.children;
    }

    public void setName(String name) {
        this._name = name;
    }

    public List<RemoteWMSStyle> getStyles() {
        return this.styles;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public List<String> getAllSrs() {
        if (this.srs.size() == 0 && this._parent != null) {
            return this._parent.getAllSrs();
        }
        return this.srs;
    }

    public void setSrs(List<String> srs) {
        this.srs = srs;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title.trim();
    }

    public boolean isTransparent() {
        return this.transparency;
    }

    public void setTransparency(boolean transparency) {
        this.transparency = transparency;
    }

    public void setChildren(List<WMSLayerNode> children) {
        this.children = children;
    }

    public WMSLayerNode getParent() {
        return this._parent;
    }

    public void setParent(WMSLayerNode parentNode) {
        this._parent = parentNode;
    }

    public List<RemoteTimeDimension> getDimensions() {
        return this.dimensions;
    }

    public String getAbstract() {
        return this.lAbstract;
    }

    public void setAbstract(String _abstract) {
        this.lAbstract = _abstract;
    }

    public void addDimension(String name, String units, String unitSymbol, String dimExpression) {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<RemoteTimeDimension>();
        }
        if (name.equalsIgnoreCase("time")) {
            try {
                this.dimensions.add(new TimeDimension(units, unitSymbol, dimExpression));
            }
            catch (IllegalArgumentException e) {
                this.dimensions.add(new DefaultDimension(name.toUpperCase(), units, unitSymbol, dimExpression));
            }
        } else {
            if (name.equalsIgnoreCase("sequence")) {
                return;
            }
            this.dimensions.add(new DefaultDimension(name.toUpperCase(), units, unitSymbol, dimExpression));
        }
    }

    public void setLatLonBox(String _latLonBox) {
        this.latLonBox = _latLonBox;
    }

    public String getLatLonBox() {
        return this.latLonBox;
    }

    public void setFixedSize(int fixedWidth, int fixedHeight) {
        this.fixedSize = new Dimension(fixedWidth, fixedHeight);
    }

    public Dimension getFixedSize() {
        return this.fixedSize;
    }

    public boolean isSizeFixed() {
        return this.fixedSize != null && this.fixedSize.getWidth() > 0.0 && this.fixedSize.getHeight() > 0.0;
    }

    public void addStyle(WMSStyle style) {
        if (style.getName().equalsIgnoreCase("default")) {
            this.selectedStyleIndex = this.styles.size();
        }
        if (this.styles == null) {
            this.styles = new ArrayList<RemoteWMSStyle>();
        }
        this.styles.add(new RemoteWMSStyle(style, this));
    }

    public RemoteWMSStyle getSelectedStyle() {
        if (this.styles == null || this.selectedStyleIndex > this.styles.size() - 1 || this.selectedStyleIndex == -1) {
            return null;
        }
        return this.styles.get(this.selectedStyleIndex);
    }

    public void setSelectedStyleByIndex(int index) {
        this.selectedStyleIndex = index;
    }

    public void setSelectedStyleByName(String styName) {
        if (styName == null || styName.equals("")) {
            this.setSelectedStyleByIndex(-1);
        }
        for (int i = 0; i < this.styles.size(); ++i) {
            RemoteWMSStyle sty = this.styles.get(i);
            if (!sty.name.equalsIgnoreCase(styName)) continue;
            this.setSelectedStyleByIndex(i);
            return;
        }
        this.setSelectedStyleByIndex(-1);
    }

    public void addKeyword(String keyword) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keyword);
    }

    public String toString() {
        String str = this.getName() == null ? this.getTitle() : "[" + this.getName() + "] " + this.getTitle();
        return str;
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        WMSLayerNode clone = new WMSLayerNode();
        clone._name = this._name;
        clone.queryable = this.queryable;
        clone.srs = this.srs;
        clone._title = this._title;
        clone.transparency = this.transparency;
        clone.styles = new ArrayList<RemoteWMSStyle>();
        clone.lAbstract = this.lAbstract;
        clone.latLonBox = this.latLonBox;
        clone.selectedStyleIndex = this.selectedStyleIndex;
        if (this.keywords != null) {
            clone.keywords = new ArrayList<String>(this.keywords.size());
            for (i = 0; i < this.keywords.size(); ++i) {
                clone.keywords.add(this.keywords.get(i));
            }
        }
        if (this.styles != null) {
            for (i = 0; i < this.styles.size(); ++i) {
                RemoteWMSStyle sty = (RemoteWMSStyle)this.styles.get(i).clone();
                sty.parent = this;
                clone.styles.add(sty);
            }
        }
        if (this.dimensions != null) {
            for (i = 0; i < this.dimensions.size(); ++i) {
                clone.dimensions = new ArrayList<RemoteTimeDimension>();
                clone.dimensions.add(this.dimensions.get(i));
            }
        }
        return clone;
    }

    public void sort() {
        if (CollectionUtils.isEmpty(this.children)) {
            return;
        }
        Collections.sort(this.children, new Comparator<WMSLayerNode>(){

            @Override
            public int compare(WMSLayerNode o1, WMSLayerNode o2) {
                return StringUtils.compareIgnoreCase((String)Objects.toString(o1), (String)Objects.toString(o2));
            }
        });
        for (WMSLayerNode child : this.children) {
            child.sort();
        }
    }
}

