/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io.downloader;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.tile.BaseTileDownloader;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSConnector;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSProvider;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.tools.locator.LocatorException;

public class TileDownloaderForWMS
extends BaseTileDownloader {
    private WMSConnector connector = null;
    private Extent lyrExtent = null;

    public TileDownloaderForWMS(RasterDataStore store, int tilePxWidth, int tilePxHeight) throws RemoteServiceException {
        super(store, tilePxWidth, tilePxHeight);
        this.connector = ((WMSProvider)store.getProvider()).getConnector();
        this.lyrExtent = store.getExtent();
    }

    public synchronized Tile downloadTile(Tile tile) throws TileGettingException {
        try {
            Rectangle2D.Double r = new Rectangle2D.Double(tile.getExtent().getMinX(), tile.getExtent().getMinY() - tile.getExtent().getHeight(), tile.getExtent().getWidth(), tile.getExtent().getHeight());
            WMSDataParameters p = (WMSDataParameters)this.store.getParameters();
            WMSStatus wmsStatus = new WMSStatus();
            wmsStatus.setLayerNames(Utilities.createVector((String)p.getLayerQuery(), (String)","));
            wmsStatus.setSrs(p.getSRSCode());
            wmsStatus.setFormat(p.getFormat());
            List<RemoteWMSStyle> listStyles = p.getStyles();
            Vector<RemoteWMSStyle> v = listStyles != null ? new Vector<RemoteWMSStyle>(listStyles) : null;
            wmsStatus.setStyles(v);
            wmsStatus.setDimensions(p.getDimensions());
            wmsStatus.setTransparency(p.isWmsTransparent());
            wmsStatus.setOnlineResource(p.getOnlineResource().get("GetMap"));
            wmsStatus.setExtent((Rectangle2D)r);
            wmsStatus.setHeight(tile.getHeightPx());
            wmsStatus.setWidth(tile.getWidthPx());
            wmsStatus.setXyAxisOrder(p.isXyAxisOrder());
            IProjection proj = (IProjection)p.getSRS();
            if (proj != null) {
                wmsStatus.setProjected(proj.isProjected());
            }
            this.connector.getMap(wmsStatus, tile.getCancelled(), tile.getFile());
        }
        catch (RemoteServiceException e) {
            throw new TileGettingException((Throwable)e);
        }
        this.readTileFromDisk(tile);
        return tile;
    }

    private void fuseFiles(Extent dstExtent, int dstWidth, int dstHeight, File src, File dst, double pixelSize) throws RasterDriverException, ProcessInterruptedException, ProviderNotRegisteredException, InitializeException, LocatorException, NotSupportedExtensionException, IOException, QueryException {
        AbstractRasterProvider provider = DefaultProviderServices.loadProvider((File)src);
        RasterQuery q = RasterLocator.getManager().createQuery();
        Buffer bufInput = this.store.query(q);
        Buffer bufDst = DefaultRasterManager.getInstance().createMemoryBuffer(provider.getDataType()[0], dstWidth, dstHeight, provider.getBandCount(), true);
        String extension = RasterLocator.getManager().getFileUtils().getExtensionFromFileName(src.getAbsolutePath());
        RasterLocator.getManager().getRasterUtils().copyToBuffer(bufDst, dstExtent, bufInput, this.lyrExtent, pixelSize, provider.getColorInterpretation().hasAlphaBand());
        RasterLocator.getManager().getProviderServices().exportBufferToFile(bufDst, provider.getCellSize(), extension, provider.getColorInterpretation().hasAlphaBand(), dst, dstExtent, provider.getColorInterpretation());
    }
}

