/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.mainplugin.beans.createlayer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.cresques.Messages;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.raster.mainplugin.RasterMainPluginUtils;
import org.gvsig.raster.mainplugin.beans.createlayer.SelectDirectoryPanel;
import org.gvsig.raster.swing.basepanel.AbstractButtonsPanel;

public class WritableFolderPanel
extends AbstractButtonsPanel
implements ActionListener,
IWindow {
    private static final long serialVersionUID = 1L;
    private SelectDirectoryPanel selectDirectoryPanel = null;
    private JCheckBox allFiles = null;
    private Point posWindow = null;
    private int widthWindow = 320;
    private int heightWindow = 140;
    private String defaultFolder = null;
    private String layerName = null;
    private ActionListener listener = null;

    public WritableFolderPanel(String defaultFolder, ActionListener listener, String layerName) {
        this.defaultFolder = defaultFolder;
        this.layerName = layerName;
        this.setListener(listener);
        this.posWindow = RasterMainPluginUtils.iwindowPosition(this.widthWindow, this.heightWindow);
        this.initGUI();
        PluginServices.getMDIManager().addWindow((IWindow)this);
    }

    private void initGUI() {
        JButton accept = this.getButtonsPanel().getButton(1);
        JButton cancel = this.getButtonsPanel().getButton(2);
        this.getButtonsPanel().getButton(3).setVisible(false);
        accept.setEnabled(false);
        accept.addActionListener(this);
        cancel.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        JLabel label = new JLabel();
        label.setText("<html><p>" + Messages.getText((String)"folder_not_writable") + "</p></html>");
        gbc.gridy = 0;
        this.add(new JLabel("<html><p>" + this.layerName + "</p><BR></html>"), gbc);
        gbc.gridy = 1;
        this.add(label, gbc);
        gbc.gridy = 2;
        this.add(this.getSelectDirectoryPanel(), gbc);
        gbc.gridy = 3;
        this.add(this.getCheckOption(), gbc);
        this.getSelectDirectoryPanel().setListener(this);
    }

    public boolean aplyAllFiles() {
        return this.getCheckOption().isSelected();
    }

    public JCheckBox getCheckOption() {
        if (this.allFiles == null) {
            this.allFiles = new JCheckBox(Messages.getText((String)"apply_all"));
        }
        return this.allFiles;
    }

    public SelectDirectoryPanel getSelectDirectoryPanel() {
        if (this.selectDirectoryPanel == null) {
            this.selectDirectoryPanel = new SelectDirectoryPanel();
            this.selectDirectoryPanel.getJLabelDirectory().setVisible(false);
            this.selectDirectoryPanel.getJBChooseDirectory().setEnabled(true);
            this.selectDirectoryPanel.getDirectoryTextField().setText(this.defaultFolder);
        }
        return this.selectDirectoryPanel;
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getButtonsPanel().getButton(1)) {
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this.getButtonsPanel().getButton(1), 1, ""));
            }
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
        if (e.getSource() == this.getButtonsPanel().getButton(2)) {
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this.getButtonsPanel().getButton(2), 2, ""));
            }
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
        if (e.getSource() == this.getSelectDirectoryPanel()) {
            File f = new File(this.getSelectDirectoryPanel().getPath());
            if (f.exists() && f.isDirectory() && f.canWrite()) {
                this.getButtonsPanel().getButton(1).setEnabled(true);
                if (this.listener != null) {
                    this.listener.actionPerformed(new ActionEvent(this.getChangeFolderButton(), 0, this.getSelectDirectoryPanel().getPath()));
                }
            } else {
                this.getButtonsPanel().getButton(1).setEnabled(false);
            }
        }
    }

    public JButton getChangeFolderButton() {
        return this.getSelectDirectoryPanel().getJBChooseDirectory();
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(Messages.getText((String)"warning"));
        m_viewinfo.setHeight(this.heightWindow);
        m_viewinfo.setWidth(this.widthWindow);
        if (this.posWindow != null) {
            m_viewinfo.setX((int)this.posWindow.getX());
            m_viewinfo.setY((int)this.posWindow.getY());
        }
        return m_viewinfo;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

