/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.mainplugin.toolbar;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.gui.beans.comboboxconfigurablelookup.DefaultComboBoxConfigurableLookUpModel;
import org.gvsig.gui.beans.comboboxconfigurablelookup.ILookUp;
import org.gvsig.gui.beans.comboboxconfigurablelookup.JComboBoxConfigurableLookUp;
import org.gvsig.gui.beans.controls.IControl;
import org.gvsig.gui.beans.controls.combobutton.ComboButton;
import org.gvsig.gui.beans.controls.combobutton.ComboButtonEvent;
import org.gvsig.gui.beans.controls.combobutton.ComboButtonListener;
import org.gvsig.raster.mainplugin.toolbar.BinarySearch;
import org.gvsig.raster.mainplugin.toolbar.ButtonItems;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class GenericToolBarPanel
extends JToolBar
implements ComboButtonListener,
ActionListener,
MouseListener,
ItemListener,
IControl {
    private static final long serialVersionUID = -4382962282970490523L;
    private JComboBoxConfigurableLookUp jCBCLU = null;
    private ComboButton buttonGroup = new ComboButton();
    private ComboButton buttonMenu = new ComboButton();
    private FLayers lastLayers = null;

    public GenericToolBarPanel() {
        super("GenericToolBarPanel");
        this.initialize();
    }

    public void setLayers(FLayers layers) {
        this.lastLayers = layers;
        this.getComboBoxConfigurableLookUp().setBlockPopupHided(true);
        this.getComboBoxConfigurableLookUp().removeAllItems();
        if (layers != null) {
            List<FLayer> lyrs = GenericToolBarPanel.getLayerList(layers, null);
            for (int i = 0; i < lyrs.size(); ++i) {
                this.getComboBoxConfigurableLookUp().addItem((Object)lyrs.get(i).getName());
            }
            if (layers.getActives().length > 0) {
                this.getComboBoxConfigurableLookUp().setSelectedItem((Object)layers.getActives()[0].getName());
            } else if (layers.getLayersCount() > 0) {
                this.getComboBoxConfigurableLookUp().setSelectedItem((Object)layers.getLayer(0).getName());
            }
        }
        this.reloadSubMenu();
        this.getComboBoxConfigurableLookUp().setBlockPopupHided(false);
    }

    private JComboBoxConfigurableLookUp getComboBoxConfigurableLookUp() {
        if (this.jCBCLU == null) {
            this.jCBCLU = new JComboBoxConfigurableLookUp();
            this.jCBCLU.setOnlyOneColorOnText(true);
            this.jCBCLU.setPrototypeDisplayValue((Object)" ");
            if (this.jCBCLU.getModel() instanceof DefaultComboBoxConfigurableLookUpModel) {
                ((DefaultComboBoxConfigurableLookUpModel)this.jCBCLU.getModel()).setShowAllItemsInListBox(false);
                ((DefaultComboBoxConfigurableLookUpModel)this.jCBCLU.getModel()).setLookUpAgent((ILookUp)new BinarySearch());
                ((DefaultComboBoxConfigurableLookUpModel)this.jCBCLU.getModel()).setCaseSensitive(false);
                this.jCBCLU.setToForceSelectAnItem(true);
                this.jCBCLU.setDisplayAllItemsWithArrowButton(true);
            }
            this.jCBCLU.addActionListener((ActionListener)this);
        }
        return this.jCBCLU;
    }

    private void initialize() {
        this.buttonGroup.addComboButtonClickedListener((ComboButtonListener)this);
        this.buttonGroup.setName("Menu principal");
        this.buttonGroup.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup.setAlwaysMenuOnClick(true);
        this.reloadMenuGroup();
        this.add((Component)this.buttonGroup);
        this.buttonMenu.addComboButtonClickedListener((ComboButtonListener)this);
        this.buttonMenu.setName("Submenus");
        this.buttonMenu.addMouseListener((MouseListener)this);
        this.buttonMenu.setMargin(new Insets(0, 0, 0, 0));
        this.reloadMenuGroup();
        this.add((Component)this.buttonMenu);
        this.add((Component)this.getComboBoxConfigurableLookUp());
        this.setRollover(true);
    }

    public void reloadMenuGroup() {
        FLayer[] layers = new FLayer[]{this.getLayerSelected()};
        ButtonItems buttonItems = new ButtonItems(this.buttonGroup, layers);
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("GenericToolBarGroup");
        for (ExtensionPoint.Extension extension : point) {
            Object object;
            try {
                object = extension.create();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!(object instanceof IGenericToolBarMenuItem)) continue;
            buttonItems.addButton((IGenericToolBarMenuItem)object, extension.getName());
        }
        buttonItems.refresh();
        this.reloadSubMenu();
    }

    public void reloadSubMenu() {
        FLayer[] layers = new FLayer[]{this.getLayerSelected()};
        ButtonItems buttonItems = new ButtonItems(this.buttonMenu, layers);
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("GenericToolBarMenu");
        for (ExtensionPoint.Extension entry : point) {
            Object object;
            try {
                object = entry.create();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!(object instanceof IGenericToolBarMenuItem)) continue;
            IGenericToolBarMenuItem item = (IGenericToolBarMenuItem)object;
            if (!this.buttonGroup.getActionCommand().equals(item.getGroup())) continue;
            buttonItems.addButton(item, entry.getName());
        }
        buttonItems.refresh();
    }

    public FLayer getLayerSelected() {
        if (this.lastLayers == null) {
            return null;
        }
        List<FLayer> lyrs = GenericToolBarPanel.getLayerList(this.lastLayers, null);
        for (int i = 0; i < lyrs.size(); ++i) {
            if (!lyrs.get(i).getName().equals(this.getComboBoxConfigurableLookUp().getEditor().getItem())) continue;
            return lyrs.get(i);
        }
        return null;
    }

    public static List<FLayer> getLayerList(FLayers srcLyrs, List<FLayer> destLyrs) {
        if (srcLyrs == null) {
            return null;
        }
        if (destLyrs == null) {
            destLyrs = new ArrayList<FLayer>();
        }
        for (int i = 0; i < srcLyrs.getLayersCount(); ++i) {
            if (srcLyrs.getLayer(i) instanceof FLayers) {
                destLyrs = GenericToolBarPanel.getLayerList((FLayers)srcLyrs.getLayer(i), destLyrs);
                continue;
            }
            destLyrs.add(srcLyrs.getLayer(i));
        }
        return destLyrs;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getComboBoxConfigurableLookUp()) {
            // empty if block
        }
    }

    public void actionComboButtonClicked(ComboButtonEvent e) {
        if (e.getSource() == this.buttonGroup) {
            this.reloadSubMenu();
            return;
        }
        if (e.getSource() == this.buttonMenu) {
            ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
            ExtensionPoint point = extensionPoints.add("GenericToolBarMenu");
            for (ExtensionPoint.Extension entry : point) {
                FLayer[] layers;
                IGenericToolBarMenuItem item;
                Object object;
                if (!entry.getName().equals(((JButton)e.getSource()).getActionCommand())) continue;
                try {
                    object = entry.create();
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
                if (!(object instanceof IGenericToolBarMenuItem) || !(item = (IGenericToolBarMenuItem)object).isVisible(null, layers = new FLayer[]{this.getLayerSelected()}) || !item.isEnabled(null, layers)) continue;
                if (this.getLayerSelected() != null) {
                    item.execute(null, new FLayer[]{this.getLayerSelected()});
                } else {
                    item.execute(null, null);
                }
                this.reloadSubMenu();
                return;
            }
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.reloadSubMenu();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void addActionListener(ActionListener listener) {
    }

    public Object getValue() {
        return null;
    }

    public void removeActionListener(ActionListener listener) {
    }

    public Object setValue(Object value) {
        return null;
    }
}

