/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.Component;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureAttributeCellRenderer;

public class FormattedCellRenderer
extends FeatureAttributeCellRenderer {
    private DecimalFormat decimalFormat;
    private SimpleDateFormat dateFormat;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            String pattern;
            ConfigurableFeatureTableModel tableModel = this.getTableModel(table);
            if (this.decimalFormat == null) {
                this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(tableModel.getLocaleOfData());
                this.dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2, tableModel.getLocaleOfData());
            }
            if (value instanceof Number && !StringUtils.isBlank((CharSequence)(pattern = this.getTableModel(table).getFormattingPattern(column)))) {
                this.decimalFormat.applyPattern(pattern);
                String formated = this.decimalFormat.format(value);
                c.setHorizontalAlignment(4);
                c.setText(formated);
                return this;
            }
            if (value instanceof Date && !StringUtils.isBlank((CharSequence)(pattern = this.getTableModel(table).getFormattingPattern(column)))) {
                this.dateFormat.applyPattern(pattern);
                String formated = this.dateFormat.format(value);
                c.setHorizontalAlignment(4);
                c.setText(formated);
                return this;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }
}

