/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.swing.dynobject.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.swing.dynobject.LayersDynObjectSetComponent;
import org.gvsig.fmap.mapcontrol.swing.dynobject.impl.LayersDynObjectSetComponentModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynform.AbortActionException;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.JDynFormSet;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLayersDynObjectSetComponent
extends JPanel
implements LayersDynObjectSetComponent,
TreeSelectionListener,
JDynFormSet.JDynFormSetListener {
    private static final long serialVersionUID = 5864674721657215264L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLayersDynObjectSetComponent.class);
    private final LayersDynObjectSetComponentModel model;
    private JDynFormSet component;
    private JTree layersTree;
    private JPanel contentPanel;
    private final boolean writable;
    private DefaultMutableTreeNode topNode;
    private MutableTreeNode previousSelection = null;
    private MapContext mapContext = null;

    public DefaultLayersDynObjectSetComponent(Map<String, DynObjectSet> layerName2InfoByPoint) {
        this(layerName2InfoByPoint, true);
    }

    public DefaultLayersDynObjectSetComponent(Map<String, DynObjectSet> layerName2InfoByPoint, boolean writable) {
        super(new BorderLayout());
        this.writable = writable;
        this.model = new LayersDynObjectSetComponentModel(layerName2InfoByPoint);
        this.initializeUI();
    }

    private void initializeUI() {
        this.addLayerTree();
    }

    private void addLayerTree() {
        this.topNode = new DefaultMutableTreeNode("");
        this.layersTree = new JTree(this.topNode);
        this.layersTree.getSelectionModel().setSelectionMode(1);
        this.layersTree.addTreeSelectionListener(this);
        this.createTreeModel();
        JScrollPane scroll = new JScrollPane(this.layersTree);
        scroll.setPreferredSize(new Dimension(200, 200));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, scroll, this.contentPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(170);
        Dimension minimumSize = new Dimension(100, 150);
        scroll.setMinimumSize(minimumSize);
        this.add((Component)splitPane, "Center");
        for (int i = 0; i < this.layersTree.getRowCount(); ++i) {
            this.layersTree.expandRow(i);
        }
        this.layersTree.setRootVisible(false);
        if (this.topNode.getChildCount() > 0 && this.topNode.getFirstChild().getChildCount() > 0) {
            this.layersTree.setSelectionPath(new TreePath(((DefaultTreeModel)this.layersTree.getModel()).getPathToRoot(this.topNode.getFirstChild().getChildAt(0))));
        }
    }

    private void createTreeModel() {
        for (int i = 0; i < this.model.getSize(); ++i) {
            DefaultMutableTreeNode newLayer = new DefaultMutableTreeNode(this.model.getElementAt(i), true);
            DynObjectSet dynObjects = this.model.getLayerInfoByPoint((String)this.model.getElementAt(i));
            try {
                DisposableIterator it = dynObjects.iterator();
                int j = 0;
                while (it.hasNext()) {
                    DynObject dynObject = (DynObject)it.next();
                    DefaultMutableTreeNode newDynObject = new DefaultMutableTreeNode(this.concatString(dynObject.toString(), 20), false);
                    newLayer.insert(newDynObject, j);
                    ++j;
                }
            }
            catch (BaseException e) {
                LOG.error("Error getting the DynObjects of the DynObjectSet: " + dynObjects, (Throwable)e);
            }
            this.topNode.add(newLayer);
        }
    }

    private String concatString(String cadena, int i) {
        if (cadena.length() > i && i > 3) {
            String newCadena = cadena.substring(0, i - 3);
            cadena = newCadena + "...";
        }
        return cadena;
    }

    private void setCurrentLayerInfoByPoint(String layerName) {
        JDynFormSet newComponent = null;
        try {
            DynFormManager dynFormManager = DynFormLocator.getDynFormManager();
            DynObjectSet dynObjectSet = this.model.getLayerInfoByPoint(layerName);
            if (dynObjectSet != null && dynObjectSet.getSize() > 0L) {
                newComponent = dynFormManager.createJDynFormSet(null, dynObjectSet);
                newComponent.setReadOnly(!this.writable);
                newComponent.setAllowDelete(false);
                newComponent.setAllowNew(false);
                newComponent.setAllowSearch(false);
                newComponent.setAllowUpdate(false);
                if (this.mapContext != null) {
                    DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
                    newComponent.addActionToPopupMenu(dataManager.get(66), "Center in current view", (Action)new CenterGeometryInMapContext(this.mapContext));
                }
                this.removeCurrentDynObjectSetComponent();
                this.component = newComponent;
                this.component.addListener((JDynFormSet.JDynFormSetListener)this);
                JComponent comp = this.component.asJComponent();
                this.contentPanel.add((Component)comp, "Center");
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception ex) {
            LOG.warn("Can't show information.", (Throwable)ex);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void dispose() {
        this.removeCurrentDynObjectSetComponent();
        this.model.dispose();
    }

    private void removeCurrentDynObjectSetComponent() {
        if (this.component != null) {
            this.remove(this.component.asJComponent());
            this.contentPanel.removeAll();
            this.contentPanel.repaint();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath oldPath;
        TreePath newPath = e.getNewLeadSelectionPath();
        if (!newPath.equals(oldPath = e.getOldLeadSelectionPath())) {
            DefaultMutableTreeNode aux = (DefaultMutableTreeNode)this.layersTree.getLastSelectedPathComponent();
            if (this.layersTree.getSelectionPath() != null && aux.isLeaf()) {
                int childIndex;
                String layerName = "";
                if (this.previousSelection == null || !aux.getParent().equals(this.previousSelection.getParent())) {
                    layerName = aux.getParent().toString();
                    this.setCurrentLayerInfoByPoint(layerName);
                }
                if ((childIndex = aux.getParent().getIndex(aux)) != -1 && this.component != null) {
                    this.component.setCurrentIndex(childIndex);
                }
                this.previousSelection = aux;
            }
        }
    }

    public void message(String arg0) {
    }

    public void formClose() {
        this.setVisible(false);
    }

    public void formMessage(String arg0) {
    }

    public void formMovedTo(int arg0) {
        DefaultMutableTreeNode aux = (DefaultMutableTreeNode)this.layersTree.getLastSelectedPathComponent();
        TreeNode parent = aux.getParent();
        TreeNode selectNode = parent.getChildAt(arg0);
        TreePath path = new TreePath(((DefaultTreeModel)this.layersTree.getModel()).getPathToRoot(selectNode));
        this.layersTree.setSelectionPath(path);
    }

    @Override
    public void setMapContext(MapContext mapContext) {
        this.mapContext = mapContext;
    }

    public void formBeforeSave(JDynFormSet jdfs) throws AbortActionException {
    }

    public void formBeforeNew(JDynFormSet jdfs) throws AbortActionException {
    }

    public void formBeforeDelete(JDynFormSet jdfs) throws AbortActionException {
    }

    public void formBeforeSearch(JDynFormSet jdfs) throws AbortActionException {
    }

    public void formAfterSave(JDynFormSet jdfs) {
    }

    public void formAfterNew(JDynFormSet jdfs) {
    }

    public void formAfterDelete(JDynFormSet jdfs) {
    }

    public void formAfterSearch(JDynFormSet jdfs) {
    }

    public void formBeforeCancelNew(JDynFormSet dynformSet) throws AbortActionException {
    }

    public void formAfterCancelNew(JDynFormSet dynformSet) throws AbortActionException {
    }

    public class CenterGeometryInMapContext
    extends AbstractAction
    implements Action {
        private MapContext mapContext;

        public CenterGeometryInMapContext(MapContext mapContext) {
            super("Center in the current view");
            this.mapContext = mapContext;
            this.putValue("ShortDescription", "Center geometry in the current view");
            this.putValue("LongDescription", "Center geometry in the current view");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.mapContext == null) {
                return;
            }
            Object source = null;
            try {
                source = arg0.getSource();
                JDynFormField field = (JDynFormField)source;
                Geometry geom = (Geometry)field.getValue();
                if (geom == null) {
                    JOptionPane.showMessageDialog(DefaultLayersDynObjectSetComponent.this.component.asJComponent(), "The geometri is not valid. Can't center the view in it.", "Warning", 1);
                    return;
                }
                this.mapContext.getViewPort().setEnvelope(geom.getEnvelope());
                this.mapContext.invalidate();
            }
            catch (Exception ex) {
                LOG.warn("Can't center view in the geometry (source=" + source.toString() + ").", (Throwable)ex);
            }
        }
    }
}

