/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;

public class FreehandBehavior
extends Behavior {
    protected List<Double> arrayX = new ArrayList<Double>();
    protected List<Double> arrayY = new ArrayList<Double>();
    protected boolean isClicked = false;
    protected PolylineListener listener;

    public FreehandBehavior(PolylineListener mli) {
        super(1);
        this.listener = mli;
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
        mapControlDrawer.setColor(Color.black);
        if (!this.arrayX.isEmpty()) {
            this.drawPolyLine(mapControlDrawer);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        if (!this.isMyButton(e)) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.listener.polylineFinished(new MeasureEvent(this.arrayX.toArray(new Double[this.arrayX.size()]), this.arrayY.toArray(new Double[this.arrayY.size()]), e));
            this.arrayX.clear();
            this.arrayY.clear();
            this.isClicked = false;
        } else {
            this.isClicked = true;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        this.mouseMoved(e);
    }

    protected void changeLastPoint(Point2D p) {
        if (this.arrayX.size() > 0) {
            this.arrayX.set(this.arrayX.size() - 1, p.getX());
            this.arrayY.set(this.arrayY.size() - 1, p.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        if (this.isClicked) {
            Point2D point = this.getMapControl().getViewPort().toMapPoint((Point2D)e.getPoint());
            this.addPoint(point);
            MeasureEvent event = new MeasureEvent(this.arrayX.toArray(new Double[this.arrayX.size()]), this.arrayY.toArray(new Double[this.arrayY.size()]), e);
            this.listener.points(event);
            this.getMapControl().repaint();
        }
    }

    protected void drawPolyLine(MapControlDrawer mapControlDrawer) {
        try {
            Line line = this.geomManager.createLine(0);
            for (int index = 0; index < this.arrayX.size(); ++index) {
                line.addVertex(this.arrayX.get(index).doubleValue(), this.arrayY.get(index).doubleValue());
            }
            mapControlDrawer.draw((Geometry)line);
        }
        catch (Exception ex) {
            LOG.warn("Can't draw polyline", (Throwable)ex);
        }
    }

    protected void addPoint(Point2D p) {
        this.arrayX.add(p.getX());
        this.arrayY.add(p.getY());
    }

    public void setListener(ToolListener listener) {
        this.listener = (PolylineListener)listener;
    }

    @Override
    public ToolListener getListener() {
        return this.listener;
    }
}

