/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.geom.Point2D;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomOutRightButtonListener
implements PointListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(ZoomOutRightButtonListener.class);
    private MapControl mapControl;

    public ZoomOutRightButtonListener(MapControl mapControl) {
        this.mapControl = mapControl;
        logger.warn("Using deprecated class ZoomOutRightButtonListener");
    }

    @Override
    public void point(PointEvent event) {
        if (event.getEvent().getButton() == 3) {
            logger.debug("Zoom out bot\u00f3n derecho");
            ViewPort vp = this.mapControl.getMapContext().getViewPort();
            Point2D p2 = vp.toMapPoint(event.getPoint());
            double factor = 1.0 / MapContext.ZOOMOUTFACTOR;
            if (vp.getExtent() != null) {
                double nuevoX = p2.getX() - vp.getExtent().getWidth() * factor / 2.0;
                double nuevoY = p2.getY() - vp.getExtent().getHeight() * factor / 2.0;
                double x = nuevoX;
                double y = nuevoY;
                double width = vp.getExtent().getWidth() * factor;
                double height = vp.getExtent().getHeight() * factor;
                try {
                    vp.setEnvelope(geomManager.createEnvelope(x, y, x + width, y + height, 0));
                }
                catch (CreateEnvelopeException e) {
                    logger.error("Error creating the envelope", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-zoom-out");
    }

    @Override
    public boolean cancelDrawing() {
        logger.debug("cancelDrawing true");
        return true;
    }

    @Override
    public void pointDoubleClick(PointEvent event) {
    }
}

