/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.coverage.CoverageCache;
import org.geotools.parameter.Parameters;
import org.geotools.resources.Utilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

final class CachedOperation {
    private final Operation operation;
    private final String[] names;
    private final Object[] values;
    private final int hashCode;

    public CachedOperation(Operation operation, ParameterValueGroup parameters) {
        this.operation = operation;
        int hashCode = operation.hashCode();
        Map param = Parameters.toNameValueMap((GeneralParameterValue)parameters, new TreeMap());
        this.names = new String[param.size()];
        this.values = new Object[this.names.length];
        int index = 0;
        Iterator it = param.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.names[index] = ((String)entry.getKey()).toLowerCase();
            Object value = entry.getValue();
            if (value instanceof Coverage) {
                value = CoverageCache.DEFAULT.reference((Coverage)value);
            }
            if (value != null) {
                hashCode = 37 * hashCode + value.hashCode();
            }
            this.values[index] = value;
            ++index;
        }
        this.hashCode = hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof CachedOperation) {
            CachedOperation that = (CachedOperation)object;
            return Utilities.equals(this.operation, that.operation) && Arrays.equals(this.names, that.names) && Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

