/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.operation.Interpolator2D;
import org.geotools.coverage.processing.AbstractGridCoverageProcessor;
import org.geotools.coverage.processing.CachedOperation;
import org.geotools.coverage.processing.CoverageParameterWriter;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.resources.Arguments;
import org.geotools.resources.gcs.Resources;
import org.geotools.util.WeakValueHashMap;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class GridCoverageProcessor2D
extends AbstractGridCoverageProcessor {
    private static GridCoverageProcessor2D DEFAULT;
    private final RenderingHints hints;
    private final transient Map cache = new WeakValueHashMap();
    private final FactoryRegistry registry = new FactoryRegistry(Collections.singleton(Operation2D.class));

    protected GridCoverageProcessor2D() {
        super(null, null);
        this.hints = new RenderingHints(Hints.GRID_COVERAGE_PROCESSOR, (Object)this);
        this.hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        this.hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        this.scanForPlugins();
    }

    public GridCoverageProcessor2D(GridCoverageProcessor2D processor, RenderingHints hints) {
        this();
        if (processor != null) {
            this.operations.putAll(processor.operations);
            this.hints.add(processor.hints);
        }
        if (hints != null) {
            this.hints.add(hints);
        }
        this.hints.put(Hints.GRID_COVERAGE_PROCESSOR, (Object)this);
    }

    public static synchronized GridCoverageProcessor2D getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new GridCoverageProcessor2D();
            GridCoverageProcessor2D.DEFAULT.hints.remove(Hints.GRID_COVERAGE_PROCESSOR);
        }
        return DEFAULT;
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.hints != null ? this.hints.get(key) : null;
    }

    public synchronized GridCoverage doOperation(Operation operation, ParameterValueGroup parameters) {
        GridCoverage2D source;
        try {
            source = (GridCoverage2D)parameters.parameter("Source").getValue();
        }
        catch (ParameterNotFoundException exception) {
            source = null;
        }
        String operationName = operation.getName();
        CachedOperation cacheKey = new CachedOperation(operation, parameters);
        GridCoverage2D coverage = (GridCoverage2D)this.cache.get(cacheKey);
        if (coverage != null) {
            GridCoverageProcessor2D.log(source, coverage, operationName, true);
            return coverage;
        }
        Object[] interpolations = null;
        if (!operationName.equalsIgnoreCase("Interpolate")) {
            Iterator it = parameters.values().iterator();
            while (it.hasNext()) {
                Object value;
                GeneralParameterValue param = (GeneralParameterValue)it.next();
                if (!(param instanceof ParameterValue) || !((value = ((ParameterValue)param).getValue()) instanceof Interpolator2D)) continue;
                Object[] interp = ((Interpolator2D)value).getInterpolations();
                if (interpolations == null) {
                    interpolations = interp;
                    continue;
                }
                if (Arrays.equals(interpolations, interp)) continue;
                interpolations = null;
                break;
            }
        }
        if (operation instanceof Operation2D) {
            coverage = ((Operation2D)operation).doOperation(parameters, this.hints);
            if (interpolations != null && coverage != null && !(coverage instanceof Interpolator2D)) {
                coverage = Interpolator2D.create(coverage, interpolations);
            }
            if (coverage != source) {
                GridCoverageProcessor2D.log(source, coverage, operationName, false);
                this.cache.put(cacheKey, coverage);
            }
            return coverage;
        }
        throw new OperationNotFoundException(Resources.format(67, operationName));
    }

    private static void log(GridCoverage2D source, GridCoverage2D result, String operationName, boolean fromCache) {
        if (source != result) {
            String interp = "Nearest";
            if (result instanceof Interpolator2D) {
                interp = ((Interpolator2D)result).getInterpolationName();
            }
            Locale locale = null;
            LogRecord record = Resources.getResources(locale).getLogRecord(OPERATION, 22, (source != null ? source : result).getName().toString(locale), operationName, interp, new Integer(fromCache ? 1 : 0));
            record.setSourceClassName("GridCoverageProcessor2D");
            record.setSourceMethodName("doOperation");
            LOGGER.log(record);
        }
    }

    private void scanForPlugins() {
        Iterator it = this.registry.getServiceProviders(Operation2D.class);
        while (it.hasNext()) {
            this.addOperation((Operation2D)it.next());
        }
    }

    public synchronized void print(Writer out) throws IOException {
        CoverageParameterWriter writer = new CoverageParameterWriter(out);
        String lineSeparator = System.getProperty("line.separator", "\n");
        Iterator it = this.operations.values().iterator();
        while (it.hasNext()) {
            out.write(lineSeparator);
            writer.format(((Operation2D)it.next()).descriptor);
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        arguments.getRemainingArguments(0);
        try {
            GridCoverageProcessor2D.getDefault().print(arguments.out);
        }
        catch (IOException exception) {
            exception.printStackTrace(arguments.out);
        }
        arguments.out.close();
    }

    static {
        long targetCapacity = 0x4000000L;
        long maxMemory = Runtime.getRuntime().maxMemory();
        TileCache cache = JAI.getDefaultInstance().getTileCache();
        if (maxMemory > 0x8000000L && cache.getMemoryCapacity() < 0x4000000L) {
            cache.setMemoryCapacity(0x4000000L);
        }
        LOGGER.config("Java Advanced Imaging: " + JAI.getBuildVersion() + ", TileCache capacity=" + (float)(cache.getMemoryCapacity() / 0x100000L) + " Mb");
        if (cache.getMemoryCapacity() + 0x400000L >= maxMemory) {
            LOGGER.severe(Resources.format(35, new Double((double)maxMemory / 1048576.0)));
        }
    }
}

