/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.factory.Factory;

public interface DataStoreFactorySpi
extends Factory {
    public DataStore createDataStore(Map var1) throws IOException;

    public DataStore createNewDataStore(Map var1) throws IOException;

    public String getDisplayName();

    public String getDescription();

    public Param[] getParametersInfo();

    public boolean canProcess(Map var1);

    public boolean isAvailable();

    static class 1 {
        static /* synthetic */ Class class$java$lang$String;
    }

    public static class Param {
        public final boolean required;
        public final String key;
        public final Class type;
        public final String description;
        public final Object sample;

        public Param(String key) {
            this(key, 1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String, null);
        }

        public Param(String key, Class type) {
            this(key, type, null);
        }

        public Param(String key, Class type, String description) {
            this(key, type, description, true);
        }

        public Param(String key, Class type, String description, boolean required) {
            this(key, type, description, required, null);
        }

        public Param(String key, Class type, String description, boolean required, Object sample) {
            this.key = key;
            this.type = type;
            this.description = description;
            this.required = required;
            this.sample = sample;
        }

        public Object lookUp(Map map) throws IOException {
            if (!map.containsKey(this.key)) {
                if (this.required) {
                    throw new IOException("Parameter " + this.key + " is required:" + this.description);
                }
                return null;
            }
            Object value = map.get(this.key);
            if (value == null) {
                return null;
            }
            if (value instanceof String && this.type != (1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String)) {
                value = this.handle((String)value);
            }
            if (value == null) {
                return null;
            }
            if (!this.type.isInstance(value)) {
                throw new IOException(this.type.getName() + " required for parameter " + this.key + ": not " + value.getClass().getName());
            }
            return value;
        }

        public String text(Object value) {
            return value.toString();
        }

        public Object handle(String text) throws IOException {
            if (text == null) {
                return null;
            }
            if (this.type == (1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String)) {
                return text;
            }
            if (text.length() == 0) {
                return null;
            }
            try {
                return this.parse(text);
            }
            catch (IOException ioException) {
                throw ioException;
            }
            catch (Throwable throwable) {
                throw new DataSourceException("Problem creating " + this.type.getName() + " from '" + text + "'", throwable);
            }
        }

        public Object parse(String text) throws Throwable {
            Constructor constructor;
            try {
                constructor = this.type.getConstructor(1.class$java$lang$String == null ? (1.class$java$lang$String = 1.class$("java.lang.String")) : 1.class$java$lang$String);
            }
            catch (SecurityException e) {
                throw new IOException("Could not create " + this.type.getName() + " from text");
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Could not create " + this.type.getName() + " from text");
            }
            try {
                return constructor.newInstance(text);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + text + "'", illegalArgumentException);
            }
            catch (InstantiationException instantiaionException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + text + "'", instantiaionException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DataSourceException("Could not create " + this.type.getName() + ": from '" + text + "'", illegalAccessException);
            }
            catch (InvocationTargetException targetException) {
                throw targetException.getCause();
            }
        }
    }
}

