/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.feature.Feature;

public class MaxIncFIDMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 1L;
    private String FIDColumn;
    private int FIDColumnType;
    private String tableName;

    public MaxIncFIDMapper(String tableName, String FIDColumn, int FIDColumnType) {
        this(tableName, FIDColumn, FIDColumnType, false);
    }

    public MaxIncFIDMapper(String tableName, String FIDColumn, int FIDColumnType, boolean returnFIDColumnsAsAttributes) {
        this.tableName = tableName;
        this.FIDColumn = FIDColumn;
        this.FIDColumnType = FIDColumnType;
        this.returnFIDColumnsAsAttributes = returnFIDColumnsAsAttributes;
    }

    public String getID(Object[] attributes) {
        return String.valueOf(attributes[0]);
    }

    public Object[] getPKAttributes(String FID) {
        return new Object[]{new Long(Long.parseLong(FID))};
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int colIndex) {
        return this.FIDColumn;
    }

    public int getColumnType(int colIndex) {
        return 12;
    }

    public int getColumnSize(int colIndex) {
        return 255;
    }

    public int getColumnDecimalDigits(int colIndex) {
        return 0;
    }

    public boolean isAutoIncrement(int colIndex) {
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypedFIDMapper)) {
            return false;
        }
        MaxIncFIDMapper other = (MaxIncFIDMapper)object;
        return other.FIDColumn == this.FIDColumn && other.FIDColumnType == this.FIDColumnType && other.returnFIDColumnsAsAttributes == this.returnFIDColumnsAsAttributes;
    }

    public String createID(Connection conn, Feature feature, Statement statement) throws IOException {
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("Select MAX(" + this.FIDColumn + ") from " + this.tableName);
            if (rs.next()) {
                int maxFid = rs.getInt(1);
                return String.valueOf(maxFid + 1);
            }
            throw new DataSourceException("Could not get MAX for " + this.tableName + "." + this.FIDColumn + ": No result returned from query");
        }
        catch (SQLException e) {
            throw new DataSourceException("An sql problem occurred. Are the table and the fid column there?", e);
        }
    }

    public void initSupportStructures() {
    }
}

