/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;

final class FeatureReaderIterator
implements Iterator {
    FeatureReader reader;

    public FeatureReaderIterator(FeatureReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() {
        try {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    public Object next() {
        if (this.reader == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        try {
            return this.reader.next();
        }
        catch (IOException io) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not obtain the next feature:" + io);
            problem.initCause(io);
            throw problem;
        }
        catch (IllegalAttributeException create) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not create the next feature:" + create);
            problem.initCause(create);
            throw problem;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Modification of contents is not supported");
    }

    void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }
}

