/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Comparator;
import org.geotools.feature.Feature;

public final class FeatureComparators {
    public static final Comparator BY_ID = new Comparator(){

        public int compare(Object o1, Object o2) {
            Feature f1 = (Feature)o1;
            Feature f2 = (Feature)o2;
            return f1.getID().compareTo(f2.getID());
        }
    };

    private FeatureComparators() {
    }

    public static Comparator byAttributeIndex(int idx) {
        return new Index(idx);
    }

    public static Comparator byAttributeName(String name) {
        return new Name(name);
    }

    public static class Name
    implements Comparator {
        private final String name;

        public Name(String name) {
            this.name = name;
        }

        public int compare(Object o1, Object o2) {
            Feature f1 = (Feature)o1;
            Feature f2 = (Feature)o2;
            return this.compareAtts(f1.getAttribute(this.name), f2.getAttribute(this.name));
        }

        protected int compareAtts(Object att1, Object att2) {
            if (att1 == null && att2 == null) {
                return 0;
            }
            return ((Comparable)att1).compareTo((Comparable)att2);
        }
    }

    public static class Index
    implements Comparator {
        private final int idx;

        public Index(int i) {
            this.idx = i;
        }

        public int compare(Object o1, Object o2) {
            Feature f1 = (Feature)o1;
            Feature f2 = (Feature)o2;
            return this.compareAtts(f1.getAttribute(this.idx), f2.getAttribute(this.idx));
        }

        protected int compareAtts(Object att1, Object att2) {
            return ((Comparable)att1).compareTo((Comparable)att2);
        }
    }
}

