/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;

public class Schema {
    public static int attribtueCount(FeatureType featureType) {
        return Schema.names(featureType).size();
    }

    public static List names(FeatureType featureType) {
        ArrayList names = new ArrayList();
        Schema.names(featureType, names);
        return names;
    }

    public static List attributes(FeatureType featureType) {
        ArrayList list = new ArrayList();
        Schema.attributes(featureType, list);
        return list;
    }

    public static void names(FeatureType featureType, List names) {
        AttributeType[] attributes;
        if (featureType == null || featureType.getAttributeTypes() == null) {
            return;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null && ancestors.length != 0) {
            int length = ancestors.length;
            for (int i = 0; i < length; ++i) {
                FeatureType type = ancestors[i];
                Schema.names(ancestors[i], names);
            }
        }
        if ((attributes = featureType.getAttributeTypes()) != null && attributes.length != 0) {
            int length = attributes.length;
            for (int i = 0; i < length; ++i) {
                AttributeType type = attributes[i];
                String name = type.getName();
                if (names.contains(name)) continue;
                names.add(name);
            }
        }
    }

    public static void attributes(FeatureType featureType, List list) {
        AttributeType[] attributes;
        if (featureType == null || featureType.getAttributeTypes() == null) {
            return;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null && ancestors.length != 0) {
            int length = ancestors.length;
            for (int i = 0; i < length; ++i) {
                FeatureType type = ancestors[i];
                Schema.attributes(ancestors[i], list);
            }
        }
        if ((attributes = featureType.getAttributeTypes()) != null && attributes.length != 0) {
            int length = attributes.length;
            for (int i = 0; i < length; ++i) {
                AttributeType type = attributes[i];
                String name = type.getName();
                int index = Schema.indexOf(list, name);
                if (index != -1) {
                    AttributeType origional = (AttributeType)list.get(index);
                    list.remove(index);
                    list.add(index, Schema.override(origional, type));
                    continue;
                }
                list.add(type);
            }
        }
    }

    private static int indexOf(List attributes, String name) {
        int index = 0;
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            AttributeType type = (AttributeType)i.next();
            if (name.equals(type.getName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static AttributeType override(AttributeType type, AttributeType override) {
        String name;
        int min;
        int max = override.getMaxOccurs();
        if (max < 0) {
            max = type.getMinOccurs();
        }
        if ((min = override.getMinOccurs()) < 0) {
            min = type.getMinOccurs();
        }
        if ((name = override.getName()) == null) {
            name = type.getName();
        }
        Filter restriction = Schema.override(type.getRestriction(), override.getRestriction());
        Class javaType = override.getType();
        if (javaType == null) {
            javaType = type.getType();
        }
        boolean isNilable = override.isNillable();
        Object defaultValue = override.createDefaultValue();
        if (defaultValue == null) {
            defaultValue = type.createDefaultValue();
        }
        return AttributeTypeFactory.newAttributeType(name, javaType, isNilable, restriction, defaultValue, null);
    }

    public static Filter restriction(FeatureType featureType, String name) {
        if (featureType == null || featureType.getAttributeTypes() == null) {
            return Filter.ALL;
        }
        return Schema.restriction(featureType, name, Filter.NONE);
    }

    private static Filter restriction(FeatureType featureType, String name, Filter filter) {
        AttributeType[] attributes;
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null && ancestors.length != 0) {
            int length = ancestors.length;
            for (int i = 0; i < length; ++i) {
                FeatureType type = ancestors[i];
                filter = Schema.restriction(featureType, name, filter);
            }
        }
        if ((attributes = featureType.getAttributeTypes()) != null && attributes.length != 0) {
            int length = attributes.length;
            for (int i = 0; i < length; ++i) {
                AttributeType type = attributes[i];
                if (!name.equals(type.getName())) continue;
                filter = Schema.override(filter, type.getRestriction());
            }
        }
        return filter;
    }

    private static Filter override(Filter filter, Filter override) {
        if (Schema.isNOP(override)) {
            return filter;
        }
        if (Schema.isNOP(filter)) {
            return override;
        }
        return filter.and(override);
    }

    private static boolean isNOP(Filter filter) {
        return filter == null || filter.getFilterType() == 21 || Filter.NONE.equals(filter);
    }

    public static int find(FeatureType type, String name) {
        List names = Schema.names(type);
        return names.indexOf(name);
    }

    public static AttributeType attribute(FeatureType type, int index) {
        String name = (String)Schema.names(type).get(index);
        return Schema.xpath(type, name);
    }

    public static AttributeType attribute(FeatureType type, String name) {
        List list = Schema.attributes(type);
        int index = Schema.indexOf(list, name);
        if (index == -1) {
            return null;
        }
        return (AttributeType)list.get(index);
    }

    public static AttributeType xpath(FeatureType type, String xpath) {
        return Schema.attribute(type, xpath);
    }
}

