/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class CoordinateWriter {
    private final String coordinateDelimiter;
    private final String tupleDelimiter;
    private final NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
    private final AttributesImpl atts = new AttributesImpl();
    private final StringBuffer coordBuff = new StringBuffer();
    private final FieldPosition zero = new FieldPosition(0);
    private char[] buff = new char[200];
    private final boolean useDummyZ;
    private final double dummyZ;

    public CoordinateWriter() {
        this(4);
    }

    public CoordinateWriter(int numDecimals, boolean isDummyZEnabled) {
        this(numDecimals, " ", ",", isDummyZEnabled);
    }

    public CoordinateWriter(int numDecimals) {
        this(numDecimals, false);
    }

    public CoordinateWriter(int numDecimals, String tupleDelim, String coordDelim) {
        this(numDecimals, tupleDelim, coordDelim, false);
    }

    public CoordinateWriter(int numDecimals, String tupleDelim, String coordDelim, boolean isDummyZEnabled) {
        this(numDecimals, tupleDelim, coordDelim, isDummyZEnabled, 0.0);
    }

    public int getNumDecimals() {
        return this.coordFormatter.getMaximumFractionDigits();
    }

    public boolean isDummyZEnabled() {
        return this.useDummyZ;
    }

    public CoordinateWriter(int numDecimals, String tupleDelim, String coordDelim, boolean useDummyZ, double zValue) {
        if (tupleDelim == null || tupleDelim.length() == 0) {
            throw new IllegalArgumentException("Tuple delimeter cannot be null or zero length");
        }
        if (coordDelim != null && coordDelim.length() == 0) {
            throw new IllegalArgumentException("Coordinate delimeter cannot be null or zero length");
        }
        this.tupleDelimiter = tupleDelim;
        this.coordinateDelimiter = coordDelim;
        this.coordFormatter.setMaximumFractionDigits(numDecimals);
        this.coordFormatter.setGroupingUsed(false);
        this.atts.addAttribute("http://www.opengis.net/gml", "decimal", "decimal", "decimal", ".");
        this.atts.addAttribute("http://www.opengis.net/gml", "cs", "cs", "cs", this.coordinateDelimiter);
        this.atts.addAttribute("http://www.opengis.net/gml", "ts", "ts", "ts", this.tupleDelimiter);
        this.useDummyZ = useDummyZ;
        this.dummyZ = zValue;
    }

    public void writeCoordinates(Coordinate[] c, ContentHandler output) throws SAXException {
        output.startElement("http://www.opengis.net/gml", "coordinates", "gml:coordinates", this.atts);
        int n = c.length;
        for (int i = 0; i < n; ++i) {
            this.coordBuff.delete(0, this.coordBuff.length());
            this.coordFormatter.format(c[i].x, this.coordBuff, this.zero).append(this.coordinateDelimiter);
            if (this.useDummyZ) {
                this.coordFormatter.format(c[i].y, this.coordBuff, this.zero).append(this.coordinateDelimiter);
            } else {
                this.coordFormatter.format(c[i].y, this.coordBuff, this.zero);
            }
            if (this.useDummyZ) {
                this.coordFormatter.format(this.dummyZ, this.coordBuff, this.zero);
            }
            if (i + 1 < c.length) {
                this.coordBuff.append(this.tupleDelimiter);
            }
            if (this.coordBuff.length() > this.buff.length) {
                this.buff = new char[this.coordBuff.length()];
            }
            this.coordBuff.getChars(0, this.coordBuff.length(), this.buff, 0);
            output.characters(this.buff, 0, this.coordBuff.length());
        }
        output.endElement("http://www.opengis.net/gml", "coordinates", "gml:coordinates");
    }
}

