/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.color.ColorSpace;
import org.geotools.resources.Utilities;

final class ScaledColorSpace
extends ColorSpace {
    private static final float MIN_VALUE = 0.0f;
    private static final float MAX_VALUE = 1.0f;
    private final float scale;
    private final float offset;

    public ScaledColorSpace(int numComponents, float minimum, float maximum) {
        super(6, numComponents);
        this.scale = (maximum - minimum) / 1.0f;
        this.offset = minimum - 0.0f * this.scale;
    }

    public float[] toRGB(float[] values) {
        float value = (values[0] - this.offset) / this.scale;
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        return new float[]{value, value, value};
    }

    public float[] fromRGB(float[] RGB) {
        float[] values = new float[this.getNumComponents()];
        values[0] = (RGB[0] + RGB[1] + RGB[2]) / 3.0f * this.scale + this.offset;
        return values;
    }

    public float[] toCIEXYZ(float[] values) {
        float value = (values[0] - this.offset) / this.scale;
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        return new float[]{value * 0.9642f, value * 1.0f, value * 0.8249f};
    }

    public float[] fromCIEXYZ(float[] RGB) {
        float[] values = new float[this.getNumComponents()];
        values[0] = (RGB[0] / 0.9642f + RGB[1] + RGB[2] / 0.8249f) / 3.0f * this.scale + this.offset;
        return values;
    }

    public float getMinValue(int component) {
        return 0.0f * this.scale + this.offset;
    }

    public float getMaxValue(int component) {
        return 1.0f * this.scale + this.offset;
    }

    public String toString() {
        return Utilities.getShortClassName(this) + '[' + this.getMinValue(0) + ", " + this.getMaxValue(0) + ']';
    }
}

