/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.io.Serializable;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.Cloneable;

public class BursaWolfParameters
extends Formattable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 754825592343010900L;
    public double dx;
    public double dy;
    public double dz;
    public double ex;
    public double ey;
    public double ez;
    public double ppm;
    public final GeodeticDatum targetDatum;

    public BursaWolfParameters(GeodeticDatum target) {
        this.targetDatum = target;
    }

    public boolean isIdentity() {
        return this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0 && this.ex == 0.0 && this.ey == 0.0 && this.ez == 0.0 && this.ppm == 0.0;
    }

    public boolean isTranslation() {
        return this.ex == 0.0 && this.ey == 0.0 && this.ez == 0.0 && this.ppm == 0.0;
    }

    public Matrix getAffineTransform() {
        double S = 1.0 + this.ppm / 1000000.0;
        double RS = 4.84813681109536E-6 * S;
        return new GeneralMatrix(4, 4, new double[]{S, -this.ez * RS, this.ey * RS, this.dx, this.ez * RS, S, -this.ex * RS, this.dy, -this.ey * RS, this.ex * RS, S, this.dz, 0.0, 0.0, 0.0, 1.0});
    }

    public int hashCode() {
        long code = 754825592343010900L;
        code = code * 37L + Double.doubleToLongBits(this.dx);
        code = code * 37L + Double.doubleToLongBits(this.dy);
        code = code * 37L + Double.doubleToLongBits(this.dz);
        code = code * 37L + Double.doubleToLongBits(this.ex);
        code = code * 37L + Double.doubleToLongBits(this.ey);
        code = code * 37L + Double.doubleToLongBits(this.ez);
        code = code * 37L + Double.doubleToLongBits(this.ppm);
        return (int)(code >>> 32) ^ (int)code;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BursaWolfParameters) {
            BursaWolfParameters that = (BursaWolfParameters)object;
            return Double.doubleToLongBits(this.dx) == Double.doubleToLongBits(that.dx) && Double.doubleToLongBits(this.dy) == Double.doubleToLongBits(that.dy) && Double.doubleToLongBits(this.dz) == Double.doubleToLongBits(that.dz) && Double.doubleToLongBits(this.ex) == Double.doubleToLongBits(that.ex) && Double.doubleToLongBits(this.ey) == Double.doubleToLongBits(that.ey) && Double.doubleToLongBits(this.ez) == Double.doubleToLongBits(that.ez) && Double.doubleToLongBits(this.ppm) == Double.doubleToLongBits(that.ppm) && Utilities.equals(this.targetDatum, that.targetDatum);
        }
        return false;
    }

    protected String formatWKT(Formatter formatter) {
        formatter.append(this.dx);
        formatter.append(this.dy);
        formatter.append(this.dz);
        formatter.append(this.ex);
        formatter.append(this.ey);
        formatter.append(this.ez);
        formatter.append(this.ppm);
        if (!DefaultGeodeticDatum.isWGS84((Datum)this.targetDatum)) {
            if (this.targetDatum != null) {
                formatter.append(this.targetDatum.getName().getCode());
            }
            return super.formatWKT(formatter);
        }
        return "TOWGS84";
    }
}

