/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.factory.OptionalFactory;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AbstractFactory;
import org.geotools.referencing.factory.BufferedAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.opengis.referencing.FactoryException;

public abstract class DeferredAuthorityFactory
extends BufferedAuthorityFactory
implements OptionalFactory {
    private static final Timer TIMER;
    private TimerTask disposer;
    private boolean used;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$geotools$referencing$factory$DeferredAuthorityFactory$Disposer;

    protected DeferredAuthorityFactory(FactoryGroup factories, int priority) {
        super(factories, priority, 20);
    }

    protected DeferredAuthorityFactory(FactoryGroup factories, int priority, int maxStrongReferences) {
        super(factories, priority, maxStrongReferences);
    }

    public boolean isReady() {
        return super.isReady();
    }

    final AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.backingStore == null) {
            this.backingStore = this.createBackingStore();
        }
        this.used = true;
        return this.backingStore;
    }

    protected abstract AbstractAuthorityFactory createBackingStore() throws FactoryException;

    public synchronized boolean isConnected() {
        return this.backingStore != null;
    }

    public synchronized void setTimeout(long delay) {
        if (this.disposer != null) {
            this.disposer.cancel();
        }
        this.disposer = new Disposer();
        TIMER.schedule(this.disposer, delay, delay);
    }

    public synchronized void dispose() throws FactoryException {
        if (this.disposer != null) {
            this.disposer.cancel();
            this.disposer = null;
        }
        super.dispose();
    }

    static {
        $assertionsDisabled = !DeferredAuthorityFactory.class.desiredAssertionStatus();
        TIMER = new Timer(true);
    }

    private final class Disposer
    extends TimerTask {
        private Disposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DeferredAuthorityFactory deferredAuthorityFactory = DeferredAuthorityFactory.this;
            synchronized (deferredAuthorityFactory) {
                if (DeferredAuthorityFactory.this.used) {
                    DeferredAuthorityFactory.this.used = false;
                    return;
                }
                if (this.cancel()) {
                    DeferredAuthorityFactory.this.disposer = null;
                    if (DeferredAuthorityFactory.this.backingStore != null) {
                        try {
                            DeferredAuthorityFactory.this.backingStore.dispose();
                            DeferredAuthorityFactory.this.backingStore = null;
                        }
                        catch (FactoryException exception) {
                            DeferredAuthorityFactory.this.backingStore = null;
                            LogRecord record = new LogRecord(Level.WARNING, "Failed to dispose the backing store after timeout.");
                            record.setSourceMethodName("run");
                            record.setSourceClassName((class$org$geotools$referencing$factory$DeferredAuthorityFactory$Disposer == null ? (class$org$geotools$referencing$factory$DeferredAuthorityFactory$Disposer = DeferredAuthorityFactory.class$("org.geotools.referencing.factory.DeferredAuthorityFactory$Disposer")) : class$org$geotools$referencing$factory$DeferredAuthorityFactory$Disposer).getName());
                            record.setThrown(exception);
                            AbstractFactory.LOGGER.log(record);
                        }
                    }
                }
            }
        }
    }
}

