/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.DefaultConicProjection;
import org.geotools.referencing.operation.DefaultConversion;
import org.geotools.referencing.operation.DefaultCylindricalProjection;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefaultPlanarProjection;
import org.geotools.referencing.operation.DefaultProjection;
import org.geotools.referencing.operation.DefaultSingleOperation;
import org.geotools.referencing.operation.DefaultTransformation;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;

public class DefaultOperation
extends DefaultSingleOperation
implements Operation {
    private static final long serialVersionUID = -8923365753849532179L;
    protected final OperationMethod method;

    DefaultOperation(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(definition, sourceCRS, targetCRS, transform);
        this.method = definition.getMethod();
    }

    public DefaultOperation(Map properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method) {
        super(properties, sourceCRS, targetCRS, transform);
        DefaultOperation.ensureNonNull("method", method);
        DefaultOperationMethod.checkDimensions(method, transform);
        this.method = method;
    }

    public static CoordinateOperation create(Map properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method, Class type) {
        if (method != null) {
            Class candidate;
            if (method instanceof MathTransformProvider && (candidate = ((MathTransformProvider)method).getOperationType()) != null && (type == null || type.isAssignableFrom(candidate))) {
                type = candidate;
            }
            if (type != null) {
                if (Transformation.class.isAssignableFrom(type)) {
                    return new DefaultTransformation(properties, sourceCRS, targetCRS, transform, method);
                }
                if (ConicProjection.class.isAssignableFrom(type)) {
                    return new DefaultConicProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (CylindricalProjection.class.isAssignableFrom(type)) {
                    return new DefaultCylindricalProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (PlanarProjection.class.isAssignableFrom(type)) {
                    return new DefaultPlanarProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (Projection.class.isAssignableFrom(type)) {
                    return new DefaultProjection(properties, sourceCRS, targetCRS, transform, method);
                }
                if (Conversion.class.isAssignableFrom(type)) {
                    return new DefaultConversion(properties, sourceCRS, targetCRS, transform, method);
                }
            }
            return new DefaultOperation(properties, sourceCRS, targetCRS, transform, method);
        }
        return new DefaultSingleOperation(properties, sourceCRS, targetCRS, transform);
    }

    public OperationMethod getMethod() {
        return this.method;
    }

    public ParameterValueGroup getParameterValues() throws UnsupportedOperationException {
        return DefaultOperation.getParameterValues(this.transform, this.method.getParameters(), true);
    }

    private static ParameterValueGroup getParameterValues(MathTransform mt, ParameterDescriptorGroup descriptor, boolean required) {
        ParameterValueGroup param;
        if (mt instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)mt;
            ParameterValueGroup param1 = DefaultOperation.getParameterValues(ct.transform1, descriptor, false);
            ParameterValueGroup param2 = DefaultOperation.getParameterValues(ct.transform2, descriptor, false);
            if (param1 == null && param2 != null) {
                return param2;
            }
            if (param2 == null && param1 != null) {
                return param1;
            }
            required = true;
        }
        if (mt instanceof AbstractMathTransform && (param = ((AbstractMathTransform)mt).getParameterValues()) != null) {
            return param;
        }
        if (required) {
            throw new UnsupportedImplementationException(mt.getClass());
        }
        return null;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            DefaultOperation that = (DefaultOperation)object;
            return DefaultOperation.equals((IdentifiedObject)this.method, (IdentifiedObject)that.method, compareMetadata);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.method.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        String name = super.formatWKT(formatter);
        formatter.append((IdentifiedObject)this.method);
        return name;
    }
}

