/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import org.geotools.measure.Latitude;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class LambertConformal
extends MapProjection {
    private static final double BELGE_A = 1.42043136359877E-4;
    private final double phi1;
    private double phi2;
    private final double n;
    private final double F;
    private final double rho0;
    private final boolean sp2;
    private final boolean belgium;
    private final boolean esri;
    static /* synthetic */ Class class$org$opengis$referencing$operation$ConicProjection;

    LambertConformal(ParameterValueGroup parameters, Collection expected, boolean sp2, boolean belgium, boolean esri) throws ParameterNotFoundException {
        super(parameters, expected);
        boolean secant;
        this.sp2 = sp2;
        this.belgium = belgium;
        this.esri = esri;
        if (sp2) {
            this.phi1 = LambertConformal.doubleValue(expected, Provider2SP.STANDARD_PARALLEL_1, parameters);
            LambertConformal.ensureLatitudeInRange(Provider2SP.STANDARD_PARALLEL_1, this.phi1, true);
            this.phi2 = LambertConformal.doubleValue(expected, Provider2SP.STANDARD_PARALLEL_2, parameters);
            if (Double.isNaN(this.phi2)) {
                this.phi2 = this.phi1;
            }
            LambertConformal.ensureLatitudeInRange(Provider2SP.STANDARD_PARALLEL_2, this.phi2, true);
        } else {
            if (belgium) {
                throw new IllegalArgumentException();
            }
            this.phi1 = this.phi2 = this.latitudeOfOrigin;
        }
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-6) {
            throw new IllegalArgumentException(Resources.format(68, new Latitude(Math.toDegrees(this.phi1)), new Latitude(Math.toDegrees(this.phi2))));
        }
        double cosphi1 = Math.cos(this.phi1);
        double sinphi1 = Math.sin(this.phi1);
        boolean bl = secant = Math.abs(this.phi1 - this.phi2) > 1.0E-6;
        if (this.isSpherical) {
            this.n = secant ? Math.log(cosphi1 / Math.cos(this.phi2)) / Math.log(Math.tan(0.7853981633974483 + 0.5 * this.phi2) / Math.tan(0.7853981633974483 + 0.5 * this.phi1)) : sinphi1;
            this.F = cosphi1 * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.phi1), this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) >= 1.0E-6 ? this.F * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.latitudeOfOrigin), -this.n) : 0.0;
        } else {
            double m1 = this.msfn(sinphi1, cosphi1);
            double t1 = this.tsfn(this.phi1, sinphi1);
            if (secant) {
                double sinphi2 = Math.sin(this.phi2);
                double m2 = this.msfn(sinphi2, Math.cos(this.phi2));
                double t2 = this.tsfn(this.phi2, sinphi2);
                this.n = Math.log(m1 / m2) / Math.log(t1 / t2);
            } else {
                this.n = sinphi1;
            }
            this.F = m1 * Math.pow(t1, -this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) >= 1.0E-6 ? this.F * Math.pow(this.tsfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin)), this.n) : 0.0;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.esri ? Provider2SP_ESRI.PARAMETERS : (this.belgium ? Provider2SP_Belgium.PARAMETERS : (this.sp2 ? Provider2SP.PARAMETERS : Provider1SP.PARAMETERS));
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (this.sp2) {
            List expected = this.getParameterDescriptors().descriptors();
            LambertConformal.set(expected, Provider2SP.STANDARD_PARALLEL_1, values, this.phi1);
            LambertConformal.set(expected, Provider2SP.STANDARD_PARALLEL_2, values, this.phi2);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho;
        if (Math.abs(Math.abs(y) - 1.5707963267948966) < 1.0E-6) {
            if (y * this.n <= 0.0) {
                throw new ProjectionException(Resources.format(119, new Latitude(Math.toDegrees(y))));
            }
            rho = 0.0;
        } else {
            rho = this.isSpherical ? this.F * Math.pow(Math.tan(0.7853981633974483 + 0.5 * y), -this.n) : this.F * Math.pow(this.tsfn(y, Math.sin(y)), this.n);
        }
        x *= this.n;
        if (this.belgium) {
            x -= 1.42043136359877E-4;
        }
        y = this.rho0 - rho * Math.cos(x);
        x = rho * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.sqrt(x * x + (y = this.rho0 - y) * y);
        if (rho > 1.0E-6) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            double theta = Math.atan2(x, y);
            if (this.belgium) {
                theta += 1.42043136359877E-4;
            }
            x = theta / this.n;
            y = this.isSpherical ? 2.0 * Math.atan(Math.pow(this.F / rho, 1.0 / this.n)) - 1.5707963267948966 : this.cphi2(Math.pow(rho / this.F, 1.0 / this.n));
        } else {
            x = 0.0;
            double d = y = this.n < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.F);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LambertConformal that = (LambertConformal)object;
            return this.sp2 == that.sp2 && this.belgium == that.belgium && LambertConformal.equals(this.n, that.n) && LambertConformal.equals(this.F, that.F) && LambertConformal.equals(this.rho0, that.rho0) && LambertConformal.equals(this.phi1, that.phi1) && LambertConformal.equals(this.phi2, that.phi2);
        }
        return false;
    }

    public static final class Provider2SP_ESRI
    extends Provider2SP {
        static final ParameterDescriptorGroup PARAMETERS = Provider2SP_ESRI.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.ESRI, "Lambert_Conformal_Conic"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(34))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider2SP_ESRI() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$ConicProjection == null ? (class$org$opengis$referencing$operation$ConicProjection = LambertConformal.class$("org.opengis.referencing.operation.ConicProjection")) : class$org$opengis$referencing$operation$ConicProjection;
        }

        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new LambertConformal(parameters, descriptors, true, false, true);
        }
    }

    public static final class Provider2SP_Belgium
    extends Provider2SP {
        static final ParameterDescriptorGroup PARAMETERS = Provider2SP_Belgium.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Lambert_Conformal_Conic_2SP_Belgium"), new NamedIdentifier(CitationImpl.EPSG, "Lambert Conic Conformal (2SP Belgium)"), new NamedIdentifier(CitationImpl.EPSG, "9803"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(34))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING});

        public Provider2SP_Belgium() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$ConicProjection == null ? (class$org$opengis$referencing$operation$ConicProjection = LambertConformal.class$("org.opengis.referencing.operation.ConicProjection")) : class$org$opengis$referencing$operation$ConicProjection;
        }

        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new LambertConformal(parameters, descriptors, true, true, false);
        }
    }

    public static class Provider2SP
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor STANDARD_PARALLEL_1 = Provider2SP.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel1")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL_2 = Provider2SP.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_2"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel2")}, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider2SP.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Lambert_Conformal_Conic_2SP"), new NamedIdentifier(CitationImpl.EPSG, "Lambert Conic Conformal (2SP)"), new NamedIdentifier(CitationImpl.EPSG, "9802"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_LambertConfConic_2SP"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_LambertConfConic"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(34))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING});

        public Provider2SP() {
            super(PARAMETERS);
        }

        protected Provider2SP(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$ConicProjection == null ? (class$org$opengis$referencing$operation$ConicProjection = LambertConformal.class$("org.opengis.referencing.operation.ConicProjection")) : class$org$opengis$referencing$operation$ConicProjection;
        }

        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new LambertConformal(parameters, descriptors, true, false, false);
        }
    }

    public static final class Provider1SP
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider1SP.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Lambert_Conformal_Conic_1SP"), new NamedIdentifier(CitationImpl.EPSG, "Lambert Conic Conformal (1SP)"), new NamedIdentifier(CitationImpl.EPSG, "9801"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_LambertConfConic_1SP"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(34))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider1SP() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$ConicProjection == null ? (class$org$opengis$referencing$operation$ConicProjection = LambertConformal.class$("org.opengis.referencing.operation.ConicProjection")) : class$org$opengis$referencing$operation$ConicProjection;
        }

        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new LambertConformal(parameters, descriptors, false, false, false);
        }
    }
}

