/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleVisitor;
import org.opengis.util.Cloneable;

public class FeatureTypeStyleImpl
implements FeatureTypeStyle,
Cloneable {
    private List ruleList = new ArrayList();
    private String featureTypeName = "Feature";
    private String name = "name";
    private String title = "title";
    private String abstractStr = "abstract";
    private static final Logger LOGGER = Logger.getLogger("org.geotools.styling");

    protected FeatureTypeStyleImpl() {
    }

    protected FeatureTypeStyleImpl(Rule[] rules) {
        this.setRules(rules);
    }

    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public Rule[] getRules() {
        return this.ruleList.toArray(new Rule[0]);
    }

    public String[] getSemantecTypeIdentifiers() {
        return new String[]{"generic:geometry"};
    }

    public void setSemantecTypeIdentifiers(String[] types) {
    }

    public void setRules(Rule[] rules) {
        this.ruleList.clear();
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i]);
        }
    }

    public void addRule(Rule rule) {
        this.ruleList.add(rule);
    }

    public void setFeatureTypeName(String name) {
        if (name.equals("feature")) {
            LOGGER.warning("FeatureTypeStyle with typename 'feature' - you probably meant to say 'Feature' (capital F) for the 'generic' FeatureType");
        }
        this.featureTypeName = name;
    }

    public String getAbstract() {
        return this.abstractStr;
    }

    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        FeatureTypeStyle clone;
        try {
            clone = (FeatureTypeStyle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        Rule[] ruleArray = new Rule[this.ruleList.size()];
        for (int i = 0; i < ruleArray.length; ++i) {
            Rule rule = (Rule)this.ruleList.get(i);
            ruleArray[i] = (Rule)((Cloneable)rule).clone();
        }
        clone.setRules(ruleArray);
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.ruleList != null) {
            result = 1000003 * result + ((Object)this.ruleList).hashCode();
        }
        if (this.featureTypeName != null) {
            result = 1000003 * result + this.featureTypeName.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.title != null) {
            result = 1000003 * result + this.title.hashCode();
        }
        if (this.abstractStr != null) {
            result = 1000003 * result + this.abstractStr.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FeatureTypeStyleImpl) {
            FeatureTypeStyleImpl other = (FeatureTypeStyleImpl)oth;
            return Utilities.equals(this.name, other.name) && Utilities.equals(this.title, other.title) && Utilities.equals(this.abstractStr, other.abstractStr) && Utilities.equals(this.featureTypeName, other.featureTypeName) && Utilities.equals(this.ruleList, other.ruleList);
        }
        return false;
    }
}

