/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public abstract class XPath {
    private Pattern[] terms;
    protected static final int OP_FIND = 0;
    protected static final int OP_VALUE = 1;
    protected static final int OP_NODEPATH = 2;

    protected XPath(String xpath) {
        String[] tmp = new String[]{};
        if (xpath.indexOf(91) == -1) {
            tmp = xpath.split("/");
        }
        this.terms = new Pattern[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            this.terms[i] = Pattern.compile(tmp[i]);
        }
    }

    protected abstract boolean isLegalNode(Object var1, int var2, boolean var3);

    protected abstract Iterator getChildren(Object var1);

    protected abstract String getNodeName(Object var1);

    protected abstract Object solve(List var1);

    protected boolean nodeMatch(Pattern term, Object o) {
        return term.matcher(this.getNodeName(o)).matches();
    }

    public List find(Object root) {
        if (!this.accept(root, 0)) {
            return null;
        }
        return this.find(root, false);
    }

    public List value(Object root) {
        if (!this.accept(root, 1)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        List paths = this.find(root, true);
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            List path = (List)iter.next();
            result.add(this.solve(path));
        }
        return result;
    }

    public List nodePaths(Object root) {
        if (!this.accept(root, 2)) {
            return null;
        }
        return this.find(root, true);
    }

    public Pattern[] getTerms() {
        return this.terms;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.terms.length; ++i) {
            buf.append(this.terms[i].pattern());
            if (i + 1 >= this.terms.length) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    private boolean accept(Object root, int operation) {
        if (root instanceof List) {
            Iterator iter = ((List)root).iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (this.isLegalNode(element, operation, true)) continue;
                return false;
            }
        } else if (!this.isLegalNode(root, operation, false)) {
            return false;
        }
        return true;
    }

    private List find(Object o, int index, List path) {
        Pattern term = this.terms[index];
        ArrayList<Object> result = new ArrayList<Object>();
        if (!this.nodeMatch(term, o)) {
            return null;
        }
        if (path != null) {
            path.add(o);
        }
        if (index == this.terms.length - 1) {
            if (path == null) {
                result.add(o);
            } else {
                result.add(new ArrayList(path));
            }
            return result;
        }
        Iterator children = this.getChildren(o);
        while (children.hasNext()) {
            Object child = children.next();
            List matches = this.find(child, index + 1, path);
            if (matches == null) continue;
            result.addAll(matches);
            if (path == null) continue;
            path.remove(path.size() - 1);
        }
        return result;
    }

    private List find(Object o, boolean keepPath) {
        Iterator children;
        ArrayList result = new ArrayList();
        boolean add = true;
        if (o instanceof List) {
            children = ((List)o).iterator();
            add = false;
        } else {
            children = this.getChildren(o);
        }
        while (children.hasNext()) {
            Object child;
            List matches;
            ArrayList<Object> path = null;
            if (keepPath) {
                path = new ArrayList<Object>();
                if (add) {
                    path.add(o);
                }
            }
            if ((matches = this.find(child = children.next(), 0, path)) == null) continue;
            result.addAll(matches);
        }
        return result;
    }

    public class NullIterator
    implements Iterator {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

