/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wcs;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.remoteclient.RasterClient;
import org.gvsig.remoteclient.exceptions.ServerErrorException;
import org.gvsig.remoteclient.exceptions.WCSException;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wcs.CoverageOfferingBrief;
import org.gvsig.remoteclient.wcs.WCSCoverage;
import org.gvsig.remoteclient.wcs.WCSProtocolHandler;
import org.gvsig.remoteclient.wcs.WCSProtocolHandlerFactory;
import org.gvsig.remoteclient.wcs.WCSStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCSClient
extends RasterClient {
    private WCSProtocolHandler handler = null;
    private Hashtable layerPool = null;
    private Logger log = LoggerFactory.getLogger(WCSClient.class);

    public WCSClient(String host) throws ConnectException, IOException {
        this.setHost(host);
        try {
            this.handler = WCSProtocolHandlerFactory.negotiate(this.hostName);
            this.handler.setHost(this.hostName);
        }
        catch (ConnectException conE) {
            throw conE;
        }
        catch (IOException ioE) {
            throw ioE;
        }
        catch (Exception e) {
            this.log.info("Error getting handler for " + this.hostName, (Throwable)e);
        }
    }

    public boolean connect(boolean override, ICancellable cancel) {
        try {
            if (this.handler == null) {
                if (this.getHost().trim().length() > 0) {
                    this.handler = WCSProtocolHandlerFactory.negotiate(this.getHost());
                    this.handler.setHost(this.getHost());
                } else {
                    return false;
                }
            }
            this.getCapabilities(null, override, cancel);
            this.describeCoverage(null, override, cancel);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void getCapabilities(WCSStatus status, boolean override, ICancellable cancel) {
        this.handler.getCapabilities(status, override, cancel);
    }

    private void describeCoverage(WCSStatus status, boolean override, ICancellable cancel) {
        this.handler.describeCoverage(status, override, cancel);
        Hashtable layers = this.handler.getLayers();
        Iterator it = layers.keySet().iterator();
        while (it.hasNext()) {
            Object obj = layers.get(it.next());
            if (!(obj instanceof CoverageOfferingBrief)) continue;
            if (status == null) {
                status = new WCSStatus();
            }
            status.setCoveraName(((CoverageOfferingBrief)obj).getName());
            this.handler.describeCoverage(status, override, cancel);
        }
        this.layerPool = this.handler.getLayers();
    }

    private Hashtable getLayerPool() {
        if (this.layerPool == null || this.layerPool.isEmpty()) {
            this.layerPool = this.getHandLer().getLayers();
            if (this.layerPool.isEmpty()) {
                this.describeCoverage(null, true, null);
                this.layerPool = this.getHandLer().getLayers();
            }
        }
        return this.layerPool;
    }

    private WCSProtocolHandler getHandLer() {
        if (this.handler == null) {
            try {
                this.handler = WCSProtocolHandlerFactory.negotiate(this.hostName);
                this.handler.setHost(this.hostName);
            }
            catch (ConnectException conE) {
                this.log.debug("Error getting handler for " + this.hostName, (Throwable)conE);
            }
            catch (IOException ioE) {
                this.log.debug("Error getting handler for " + this.hostName, (Throwable)ioE);
            }
            catch (Exception e) {
                this.log.debug("Error getting handler for " + this.hostName, (Throwable)e);
            }
        }
        return this.handler;
    }

    public void close() {
    }

    public String getServiceTitle() {
        return this.getHandLer().serviceInfo.title;
    }

    public String getVersion() {
        return this.getHandLer().getVersion();
    }

    public String getDescription() {
        return this.getHandLer().serviceInfo.abstr;
    }

    public ArrayList getFormats() {
        return this.getHandLer().getFormats();
    }

    public Hashtable getCoverageList() {
        return this.getLayerPool();
    }

    public String getLabel(String coverageName) {
        return ((WCSCoverage)this.getLayerPool().get(coverageName)).getTitle();
    }

    public Rectangle2D getExtent(String coverageName, String crs) {
        BoundaryBox bbox = ((WCSCoverage)this.getLayerPool().get(coverageName)).getBbox(crs);
        if (bbox == null) {
            return null;
        }
        double xmin = bbox.getXmin();
        double xmax = bbox.getXmax();
        double ymin = bbox.getYmin();
        double ymax = bbox.getYmax();
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public File getCoverage(WCSStatus status, ICancellable cancel) throws ServerErrorException, WCSException {
        return this.getHandLer().getCoverage(status, cancel);
    }

    public URL getCoverageURL(WCSStatus status, ICancellable cancel) throws ServerErrorException {
        return this.getHandLer().getCoverageURL(status, cancel);
    }

    public String getExceptionMessage(File file) throws IOException {
        return this.getHandLer().getExceptionMessage(file);
    }
}

