/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch;

import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.algorithm.FixedTableDialog;
import es.unex.sextante.gui.algorithm.GenericFileFilter;
import es.unex.sextante.gui.batch.AutoCompletePanel;
import es.unex.sextante.gui.batch.MultipleBandSelectionDialog;
import es.unex.sextante.gui.batch.ParameterCellPanelEditor;
import es.unex.sextante.gui.batch.PointSelectionDialog;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ParameterCellPanel
extends JPanel {
    private JTextField textField;
    private JButton button;
    private final Object m_Object;
    private final JTable m_Table;

    public ParameterCellPanel(Object obj, JTable table) {
        this.m_Object = obj;
        this.m_Table = table;
        this.initGUI();
    }

    private void initGUI() {
        this.button = new JButton("...");
        this.textField = new JTextField("");
        this.textField.setMaximumSize(new Dimension(340, 18));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterCellPanel.this.btnActionPerformed(evt);
            }
        });
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0, 25.0}, {-1.0}});
        this.setLayout((LayoutManager)thisLayout);
        if (this.m_Object instanceof ParameterString || this.m_Object instanceof ParameterNumericalValue || this.m_Object instanceof ParameterTableField) {
            this.add((Component)this.textField, "0, 0, 1, 0");
        } else {
            this.add((Component)this.textField, "0,  0");
            this.add((Component)this.button, "1,  0");
        }
    }

    private void btnActionPerformed(ActionEvent e) {
        if (this.m_Object instanceof ParameterBand) {
            this.assignBand();
        } else if (this.m_Object instanceof ParameterPoint) {
            this.assignPoint();
        } else if (this.m_Object instanceof ParameterBoolean) {
            this.assignBoolean();
        } else if (this.m_Object instanceof ParameterDataObject) {
            this.assignDataObject();
        } else if (this.m_Object instanceof ParameterFixedTable) {
            this.assignFixedTable();
        } else if (this.m_Object instanceof ParameterSelection) {
            this.assignSelection();
        } else if (this.m_Object instanceof ParameterMultipleInput) {
            this.assignMultipleInput();
        } else if (this.m_Object instanceof Output) {
            this.assignOutput();
        }
        this.m_Table.setValueAt(this.textField.getText(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
    }

    private void assignOutput() {
        String sDesc;
        String[] sExt;
        JFileChooser fc = new JFileChooser();
        if (this.m_Object instanceof OutputRasterLayer) {
            sExt = SextanteGUI.getOutputFactory().getRasterLayerOutputExtensions();
            sDesc = Sextante.getText((String)"Raster_layers");
        } else if (this.m_Object instanceof Output3DRasterLayer) {
            sExt = SextanteGUI.getOutputFactory().get3DRasterLayerOutputExtensions();
            sDesc = Sextante.getText((String)Sextante.getText((String)"3D_Raster_layers"));
        } else if (this.m_Object instanceof OutputVectorLayer) {
            sExt = SextanteGUI.getOutputFactory().getVectorLayerOutputExtensions();
            sDesc = Sextante.getText((String)"Vector_layer");
        } else if (this.m_Object instanceof OutputTable) {
            sExt = SextanteGUI.getOutputFactory().getTableOutputExtensions();
            sDesc = Sextante.getText((String)"Tables");
        } else {
            return;
        }
        fc.setFileFilter(new GenericFileFilter(sExt, sDesc));
        String[] sColumnNames = new String[this.m_Table.getColumnCount() - 1];
        int j = 0;
        for (int i = 0; i < sColumnNames.length; ++i) {
            if (i == this.m_Table.getSelectedColumn()) continue;
            sColumnNames[j] = this.m_Table.getColumnName(i);
            ++j;
        }
        fc.setAccessory(new AutoCompletePanel(sColumnNames));
        int returnVal = fc.showSaveDialog(this.getParent().getParent());
        if (returnVal == 0) {
            int i;
            String sFile = fc.getSelectedFile().getAbsolutePath();
            for (i = 0; i < sExt.length && !sFile.endsWith(sExt[i]); ++i) {
            }
            if (i == sExt.length) {
                sFile = sFile + "." + sExt[0];
            }
            int iRow = this.m_Table.getSelectedRow();
            int iCol = this.m_Table.getSelectedColumn();
            int iAutoFill = ((AutoCompletePanel)fc.getAccessory()).getAutoFill();
            if (iAutoFill == 1) {
                int iCount = 1;
                for (i = iRow; i < this.m_Table.getRowCount(); ++i) {
                    String sFile2 = sFile.substring(0, sFile.lastIndexOf(".")) + Integer.toString(iCount) + sFile.substring(sFile.lastIndexOf("."), sFile.length());
                    this.m_Table.setValueAt(sFile2, i, iCol);
                    ++iCount;
                    if (i != iRow) continue;
                    this.textField.setText(sFile2);
                }
            } else if (iAutoFill == 2) {
                int iField = ((AutoCompletePanel)fc.getAccessory()).getField();
                ParameterCellPanelEditor ce = (ParameterCellPanelEditor)this.m_Table.getCellEditor(0, iField);
                for (i = iRow; i < this.m_Table.getRowCount(); ++i) {
                    String sCellValue = this.m_Table.getValueAt(i, iField).toString();
                    if (ce.isFilenameCell() && !sCellValue.trim().equals("")) {
                        File f = new File(sCellValue);
                        sCellValue = f.getName().substring(0, f.getName().lastIndexOf("."));
                    }
                    String sFile2 = sFile.substring(0, sFile.lastIndexOf(".")) + sCellValue + sFile.substring(sFile.lastIndexOf("."), sFile.length());
                    this.m_Table.setValueAt(sFile2, i, iCol);
                    if (i != iRow) continue;
                    this.textField.setText(sFile2);
                }
            } else {
                this.textField.setText(sFile);
            }
        }
    }

    private void assignMultipleInput() {
        ParameterMultipleInput parameter = (ParameterMultipleInput)this.m_Object;
        try {
            AdditionalInfoMultipleInput ai = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
            if (ai.getDataType() == 7) {
                MultipleBandSelectionDialog dialog = new MultipleBandSelectionDialog(this.textField.getText());
                dialog.pack();
                dialog.setVisible(true);
                String sSel = dialog.getSelectionAsString();
                if (sSel != null) {
                    this.textField.setText(sSel);
                }
            } else {
                String sDesc;
                String[] sExt;
                JFileChooser fc = new JFileChooser();
                if (ai.getDataType() == 1) {
                    sExt = SextanteGUI.getInputFactory().getRasterLayerInputExtensions();
                    sDesc = Sextante.getText((String)"Raster_layers");
                } else if (ai.getDataType() == 5 || ai.getDataType() == 2 || ai.getDataType() == 3 || ai.getDataType() == 4) {
                    sExt = SextanteGUI.getInputFactory().getVectorLayerInputExtensions();
                    sDesc = Sextante.getText((String)"Vector_layer");
                } else if (ai.getDataType() == 6) {
                    sExt = SextanteGUI.getInputFactory().getTableInputExtensions();
                    sDesc = Sextante.getText((String)"Tables");
                } else {
                    return;
                }
                fc.setFileFilter(new GenericFileFilter(sExt, sDesc));
                fc.setMultiSelectionEnabled(true);
                int returnVal = fc.showOpenDialog(this.getParent().getParent());
                if (returnVal == 0) {
                    StringBuffer sValue = new StringBuffer();
                    File[] files = fc.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        sValue.append(files[i].getAbsolutePath());
                        if (i >= files.length - 1) continue;
                        sValue.append(",");
                    }
                    this.m_Table.getModel().setValueAt(sValue.toString(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
                    this.textField.setText(sValue.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void assignFixedTable() {
        FixedTableModel model = this.getTableModelFromString();
        FixedTableDialog dialog = new FixedTableDialog(SextanteGUI.getMainFrame(), model);
        dialog.pack();
        dialog.setVisible(true);
        this.textField.setText(model.getAsCSV());
    }

    public FixedTableModel getTableModelFromString() {
        int iToken = 0;
        FixedTableModel tableModel = null;
        StringTokenizer st = new StringTokenizer(this.textField.getText(), ",");
        Parameter parameter = (Parameter)this.m_Object;
        try {
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)parameter.getParameterAdditionalInfo();
            int iCols = ai.getColsCount();
            int iRows = ai.getRowsCount();
            boolean bIsNumberOfRowsFixed = ai.isNumberOfRowsFixed();
            tableModel = new FixedTableModel(ai.getCols(), iCols, bIsNumberOfRowsFixed);
            if (bIsNumberOfRowsFixed ? st.countTokens() != iCols * iRows : iToken % iCols != 0) {
                return tableModel;
            }
            while (st.hasMoreTokens()) {
                int iCol = (int)Math.floor((double)iToken / (double)iCols);
                int iRow = iToken % iCols;
                String sToken = st.nextToken().trim();
                tableModel.setValueAt((Object)sToken, iCol, iRow);
                ++iToken;
            }
            return tableModel;
        }
        catch (Exception e) {
            return tableModel;
        }
    }

    private void assignBand() {
        int MAX_BANDS = 250;
        Object[] possibilities = new String[250];
        for (int i = 0; i < possibilities.length; ++i) {
            possibilities[i] = Integer.toString(i + 1);
        }
        String s = (String)JOptionPane.showInputDialog(null, Sextante.getText((String)"Band"), Sextante.getText((String)"Band"), -1, null, possibilities, possibilities[0]);
        if (s != null) {
            this.textField.setText(s);
        }
    }

    private void assignPoint() {
        Frame window = new Frame();
        Point2D.Double pt = new Point2D.Double();
        PointSelectionDialog dialog = new PointSelectionDialog(window, pt);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getOK()) {
            this.textField.setText(Double.toString(((Point2D)pt).getX()) + "," + Double.toString(((Point2D)pt).getY()));
        }
    }

    private void assignSelection() {
        Parameter parameter = (Parameter)this.m_Object;
        try {
            AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
            Object[] possibilities = ai.getValues();
            String s = (String)JOptionPane.showInputDialog(null, parameter.getParameterDescription(), parameter.getParameterDescription(), -1, null, possibilities, possibilities[0]);
            if (s != null) {
                this.textField.setText(s);
            }
        }
        catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
            // empty catch block
        }
    }

    private void assignBoolean() {
        Parameter parameter = (Parameter)this.m_Object;
        Object[] possibilities = new String[]{Sextante.getText((String)"Yes"), Sextante.getText((String)"No")};
        String s = (String)JOptionPane.showInputDialog(null, parameter.getParameterDescription(), parameter.getParameterDescription(), -1, null, possibilities, Sextante.getText((String)"Yes"));
        if (s != null) {
            if (s.equals(Sextante.getText((String)"Yes"))) {
                this.textField.setText("true");
            } else {
                this.textField.setText("false");
            }
        }
    }

    private void assignDataObject() {
        String sDesc;
        String[] sExt;
        JFileChooser fc = new JFileChooser();
        if (this.m_Object instanceof ParameterRasterLayer) {
            sExt = SextanteGUI.getInputFactory().getRasterLayerInputExtensions();
            sDesc = Sextante.getText((String)"Raster_layers");
        } else if (this.m_Object instanceof ParameterVectorLayer) {
            sExt = SextanteGUI.getInputFactory().getVectorLayerInputExtensions();
            sDesc = Sextante.getText((String)"Vector_layers");
        } else if (this.m_Object instanceof ParameterTable) {
            sExt = SextanteGUI.getInputFactory().getTableInputExtensions();
            sDesc = Sextante.getText((String)"Tables");
        } else if (this.m_Object instanceof Parameter3DRasterLayer) {
            sExt = SextanteGUI.getInputFactory().get3DRasterLayerInputExtensions();
            sDesc = Sextante.getText((String)"3D_Raster_layers");
        } else {
            return;
        }
        fc.setFileFilter(new GenericFileFilter(sExt, sDesc));
        fc.setMultiSelectionEnabled(true);
        int returnVal = fc.showOpenDialog(this.getParent().getParent());
        if (returnVal == 0) {
            StringBuffer sValue = new StringBuffer();
            File[] files = fc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                sValue.append(files[i].getAbsolutePath());
                if (i >= files.length - 1) continue;
                sValue.append(",");
            }
            this.m_Table.getModel().setValueAt(sValue.toString(), this.m_Table.getSelectedRow(), this.m_Table.getSelectedColumn());
            this.textField.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setValue(String sText) {
        this.textField.setText(sText);
    }

    public boolean isFilenameCell() {
        return this.m_Object instanceof ParameterDataObject || !(this.m_Object instanceof Parameter);
    }
}

