/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.core;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.core.ProcessTask;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.gui.algorithm.iterative.IterativeAlgorithmMonitorableTask;
import es.unex.sextante.gui.core.SextanteGUI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GeoAlgorithmExecutors {
    public static void execute(final GeoAlgorithm alg, final JDialog parent) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Runnable postProcess;
                ITaskMonitor tm = SextanteGUI.getOutputFactory().getTaskMonitor(alg.getName(), alg.isDeterminatedProcess(), parent);
                ProcessTask task = new ProcessTask(alg, SextanteGUI.getOutputFactory(), tm);
                ExecutorService pool = Executors.newFixedThreadPool(1);
                Future future = pool.submit(task);
                Boolean success = null;
                try {
                    success = (Boolean)future.get();
                }
                catch (InterruptedException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                catch (ExecutionException e) {
                    tm.close();
                    Sextante.addErrorToLog((Throwable)e);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Error"), 0);
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                tm.close();
                if (success != null && success.booleanValue() && (postProcess = SextanteGUI.getPostProcessTask(alg, true)) != null) {
                    Thread th = new Thread(postProcess);
                    th.start();
                }
            }
        };
        Thread th = new Thread(run);
        th.start();
    }

    public static boolean executeForCommandLine(GeoAlgorithm alg, JDialog parent) throws GeoAlgorithmExecutionException {
        ITaskMonitor tm = SextanteGUI.getOutputFactory().getTaskMonitor(alg.getName(), alg.isDeterminatedProcess(), parent);
        ExecutorService pool = Executors.newFixedThreadPool(1);
        Future p = pool.submit(new ProcessTask(alg, SextanteGUI.getOutputFactory(), tm));
        try {
            Boolean success = (Boolean)p.get();
            tm.close();
            if (success != null && success.booleanValue()) {
                Runnable postProcess = SextanteGUI.getPostProcessTask(alg, false);
                if (postProcess != null) {
                    postProcess.run();
                    SextanteGUI.getInputFactory().clearDataObjects();
                    SextanteGUI.getInputFactory().createDataObjects();
                }
                return success;
            }
            return false;
        }
        catch (Exception e) {
            tm.close();
            Sextante.addErrorToLog((Throwable)e);
            throw new GeoAlgorithmExecutionException(e.getMessage());
        }
    }

    public static void executeIterative(GeoAlgorithm alg, JDialog parent, String sParameterName) throws GeoAlgorithmExecutionException {
        IterativeAlgorithmMonitorableTask task = new IterativeAlgorithmMonitorableTask(alg, parent, sParameterName);
        Thread th = new Thread(task);
        th.start();
    }
}

