/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.dataExplorer;

import es.unex.sextante.core.Sextante;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DataExplorerTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private final ImageIcon m_RasterIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/raster_layer.gif"));
    private final ImageIcon m_VectorIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/vector_layer.gif"));
    private final ImageIcon m_TableIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/table_icon.png"));
    private final ImageIcon m_LayerIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/layers.gif"));

    public DataExplorerTreeCellRenderer() {
        this.setOpaque(false);
        this.setBackground(null);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setFont(tree.getFont());
        this.setIcon(this.getCustomIcon(value));
        String sName = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.setText(sName);
        if (leaf) {
            if (selected) {
                this.setForeground(Color.blue);
            } else {
                this.setForeground(Color.black);
            }
        }
        return this;
    }

    private Icon getCustomIcon(Object value) {
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if (obj instanceof String) {
            if (obj.equals(Sextante.getText((String)"Raster_layers"))) {
                return this.m_RasterIcon;
            }
            if (obj.equals(Sextante.getText((String)"Vector_layers"))) {
                return this.m_VectorIcon;
            }
            if (obj.equals(Sextante.getText((String)"Tables"))) {
                return this.m_TableIcon;
            }
            if (obj.equals(Sextante.getText((String)"Data"))) {
                return this.m_LayerIcon;
            }
            return null;
        }
        return null;
    }
}

