/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.grass;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoBoolean;
import es.unex.sextante.additionalInfo.AdditionalInfoFilepath;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.dataObjects.vectorFilters.SelectionFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gui.algorithm.iterative.SingleFeatureVectorLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.grass.GrassAlgorithmProvider;
import es.unex.sextante.gui.grass.GrassExecutionException;
import es.unex.sextante.gui.grass.GrassModelerBlackList;
import es.unex.sextante.gui.grass.GrassUtils;
import es.unex.sextante.gui.grass.GrassVInfoUtils;
import es.unex.sextante.gui.grass.UnwrappableGrassProcessException;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.NullOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.kxml2.io.KXmlParser;

public class GrassAlgorithm
extends GeoAlgorithm {
    private static String encoding = "ISO-8859-1";
    private static final String PARAMETER = "parameter";
    private static final String DESCRIPTION = "description";
    private static final String LABEL = "label";
    private static final String TASK = "task";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String REQUIRED = "required";
    private static final String MULTIPLE = "multiple";
    private static final String VALUES = "values";
    private static final String GISPROMPT = "gisprompt";
    private static final String AGE = "age";
    private static final String ELEMENT = "element";
    private static final String DEFAULT = "default";
    private static final String KEYDESC = "keydesc";
    private static final String FLAG = "flag";
    private static final String BOOLEAN = "boolean";
    private static final String PROMPT = "prompt";
    private String m_sDescriptionFile;
    private String m_sParameterName;
    private String m_sParameterType;
    private String m_sParameterRequired;
    private String m_sParameterMultiple;
    private ArrayList<String> m_Values;
    private String m_sGisPromptAge;
    private String m_sGisPromptElement;
    private String m_sGisPromptPrompt;
    private String m_sDescription;
    private String m_sTooltip = null;
    private String m_sDefaultValue;
    private Boolean m_bKeydesc;
    private String m_sLastTag;
    private ArrayList<String> m_FilesIn;
    private ArrayList<String> m_MapsIn;
    private boolean m_bIsExecutedFromModeller;
    private static final String[] ext_ogr_in = new String[]{"shp", "mif", "tab", "e00", "ntf", "000", "ddf", "dgn", "bna", "gml", "kml", "gpx", "geojson", "gmt", "dat", "gxt"};
    private static final String[] ext_ogr_out = new String[]{"shp", "mif", "tab", "dgn", "bna", "gml", "kml", "gpx", "geojson", "gmt", "gxt"};
    public static final String PARAMETER_RESTRICT_VECTOR_OUTPUT_TYPE = "PARAMETER_RESTRICT_VECTOR_OUTPUT_TYPE";

    public void initialize(String sDescriptionFile) throws UnwrappableGrassProcessException {
        this.m_sDescriptionFile = sDescriptionFile;
        this.m_Parameters = new ParametersSet();
        this.m_OutputObjects = new OutputObjectsSet();
        this.defineCharacteristicsFromGrassXML();
    }

    public void updateProgress(int i, int n) {
        this.setProgress(i, n);
    }

    private void registerInMapping(String sFileName, String sMapName) {
        if (sFileName != null && sMapName != null) {
            this.m_FilesIn.add(sFileName);
            this.m_MapsIn.add(sMapName);
        }
    }

    private String getInFile(String sFileName) {
        for (int i = 0; i < this.m_FilesIn.size(); ++i) {
            if (!this.m_FilesIn.get(i).equals(sFileName)) continue;
            return this.m_MapsIn.get(i);
        }
        return null;
    }

    private String getInMap(String sMapName) {
        for (int i = 0; i < this.m_MapsIn.size(); ++i) {
            if (!this.m_MapsIn.get(i).equals(sMapName)) continue;
            return this.m_FilesIn.get(i);
        }
        return null;
    }

    private void defineCharacteristicsFromGrassXML() throws UnwrappableGrassProcessException {
        this.setUserCanDefineAnalysisExtent(true);
        File file = new File(this.m_sDescriptionFile);
        KXmlParser parser = new KXmlParser();
        String modName = null;
        try {
            parser.setInput((InputStream)new FileInputStream(file), encoding);
            int tag = parser.nextTag();
            boolean bOut = false;
            this.m_bKeydesc = false;
            if (parser.getEventType() != 1) {
                while (tag != 1 && !bOut) {
                    switch (tag) {
                        case 2: {
                            this.m_sLastTag = parser.getName();
                            if (parser.getName().compareTo(TASK) == 0) {
                                String sName = parser.getAttributeValue("", NAME);
                                this.setName(sName);
                                if (sName.startsWith("r")) {
                                    this.setGroup("Raster (r.*)");
                                } else if (sName.startsWith("v")) {
                                    this.setGroup("Vector (v.*)");
                                }
                                modName = new String(sName);
                                break;
                            }
                            if (parser.getName().compareTo(PARAMETER) == 0) {
                                this.m_sParameterName = parser.getAttributeValue("", NAME);
                                this.m_sParameterType = parser.getAttributeValue("", TYPE);
                                this.m_sParameterRequired = parser.getAttributeValue("", REQUIRED);
                                this.m_sParameterMultiple = parser.getAttributeValue("", MULTIPLE);
                                this.m_sGisPromptAge = "";
                                this.m_sGisPromptElement = "";
                                this.m_sGisPromptPrompt = "";
                                this.m_sDefaultValue = "";
                                this.m_Values = null;
                                break;
                            }
                            if (parser.getName().compareTo(FLAG) == 0) {
                                this.m_sParameterName = parser.getAttributeValue("", NAME);
                                this.m_sParameterType = BOOLEAN;
                                break;
                            }
                            if (parser.getName().compareTo(GISPROMPT) == 0) {
                                this.m_sGisPromptAge = parser.getAttributeValue("", AGE);
                                this.m_sGisPromptElement = parser.getAttributeValue("", ELEMENT);
                                this.m_sGisPromptPrompt = parser.getAttributeValue("", PROMPT);
                                break;
                            }
                            if (parser.getName().compareTo(VALUES) != 0) break;
                            this.m_Values = new ArrayList();
                            break;
                        }
                        case 3: {
                            if (parser.getName().compareTo(TASK) == 0) {
                                bOut = true;
                            }
                            if (parser.getName().compareTo(PARAMETER) == 0) {
                                this.createParameter();
                            }
                            if (parser.getName().compareTo(FLAG) == 0) {
                                this.createParameter();
                                break;
                            }
                            if (parser.getName().compareTo(DESCRIPTION) != 0 && parser.getName().compareTo(NAME) != 0 && parser.getName().compareTo(DEFAULT) != 0 && parser.getName().compareTo(KEYDESC) != 0 && parser.getName().compareTo(LABEL) != 0) break;
                            this.m_sLastTag = "";
                            break;
                        }
                        case 4: {
                            if (this.m_sLastTag.equals(LABEL)) {
                                this.m_sTooltip = parser.getText().trim();
                            }
                            if (this.m_sLastTag.equals(DESCRIPTION)) {
                                if (this.m_sTooltip == null) {
                                    this.m_sTooltip = parser.getText().trim();
                                }
                                this.m_sDescription = parser.getText().trim();
                                break;
                            }
                            if (this.m_sLastTag.equals(NAME)) {
                                this.m_Values.add(parser.getText().trim());
                                break;
                            }
                            if (this.m_sLastTag.equals(DEFAULT)) {
                                this.m_sDefaultValue = parser.getText().trim();
                                break;
                            }
                            if (!this.m_sLastTag.equals(KEYDESC)) break;
                            this.m_bKeydesc = true;
                        }
                    }
                    if (bOut) continue;
                    tag = parser.next();
                }
            }
            if (this.m_OutputObjects.getVectorLayersCount() != 0) {
                String[] sOptions = new String[]{Sextante.getText((String)"Points"), Sextante.getText((String)"Lines"), Sextante.getText((String)"Polygons")};
                this.m_Parameters.addSelection(PARAMETER_RESTRICT_VECTOR_OUTPUT_TYPE, Sextante.getText((String)"Restrict_geometry_output"), sOptions);
            }
        }
        catch (Exception e) {
            if (modName != null) {
                Sextante.addWarningToLog((String)("SEXTANTE GRASS interface: Failed to wrap GRASS module '" + modName + "'."));
                Sextante.addWarningToLog((String)"SEXTANTE GRASS interface: Above module will not be available.");
            }
            throw new UnwrappableGrassProcessException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createParameter() throws UnwrappableGrassProcessException {
        if (this.m_sParameterName.equals("overwrite") || this.m_sParameterName.equals("quiet") || this.m_sParameterName.equals("verbose")) {
            return;
        }
        ParameterBoolean param = null;
        OutputRasterLayer out = null;
        if (this.m_sParameterType.compareTo(BOOLEAN) == 0) {
            param = new ParameterBoolean();
            AdditionalInfoBoolean aib = new AdditionalInfoBoolean(false);
            param.setParameterAdditionalInfo((AdditionalInfo)aib);
        } else if (this.m_sParameterType.compareTo("string") == 0) {
            if (this.m_sGisPromptElement == null || this.m_sGisPromptElement.equals("")) {
                if (this.m_Values != null && this.m_Values.size() != 0) {
                    if (this.m_sParameterMultiple.equals("no")) {
                        param = new ParameterSelection();
                        AdditionalInfoSelection ais = new AdditionalInfoSelection(this.m_Values.toArray(new String[0]));
                        param.setParameterAdditionalInfo((AdditionalInfo)ais);
                    } else {
                        param = new ParameterString();
                        AdditionalInfoString ais = new AdditionalInfoString();
                        ais.setDefaultString(this.m_sDefaultValue);
                        param.setParameterAdditionalInfo((AdditionalInfo)ais);
                    }
                } else if (this.getName().equals("v.in.ogr")) {
                    AdditionalInfoFilepath aif = new AdditionalInfoFilepath(false, true, false, ext_ogr_in);
                    param = new ParameterFilepath();
                    param.setParameterAdditionalInfo((AdditionalInfo)aif);
                } else if (this.getName().equals("v.out.ogr")) {
                    AdditionalInfoFilepath aif = new AdditionalInfoFilepath(false, true, false, ext_ogr_out);
                    param = new ParameterFilepath();
                    param.setParameterAdditionalInfo((AdditionalInfo)aif);
                } else {
                    param = new ParameterString();
                    AdditionalInfoString ais = new AdditionalInfoString();
                    ais.setDefaultString(this.m_sDefaultValue);
                    param.setParameterAdditionalInfo((AdditionalInfo)ais);
                }
            } else if (this.m_sParameterMultiple.equals("yes")) {
                if (this.m_sGisPromptElement.equals("cell")) {
                    param = new ParameterMultipleInput();
                    AdditionalInfoMultipleInput aimi = null;
                    aimi = new AdditionalInfoMultipleInput(1, this.m_sParameterRequired.equals("yes"));
                    param.setParameterAdditionalInfo((AdditionalInfo)aimi);
                } else if (this.m_sGisPromptElement.equals("vector")) {
                    param = new ParameterMultipleInput();
                    AdditionalInfoMultipleInput aimi = null;
                    aimi = new AdditionalInfoMultipleInput(5, this.m_sParameterRequired.equals("yes"));
                    param.setParameterAdditionalInfo((AdditionalInfo)aimi);
                } else {
                    if (!this.m_sGisPromptElement.equals("dbcolumn")) throw new UnwrappableGrassProcessException();
                    param = new ParameterString();
                    AdditionalInfoString ais = new AdditionalInfoString();
                    ais.setDefaultString(this.m_sDefaultValue);
                    ais.setIsField(true);
                    param.setParameterAdditionalInfo((AdditionalInfo)ais);
                }
            } else if (this.m_sGisPromptAge.startsWith("old")) {
                if (this.m_sGisPromptElement.equals("cell")) {
                    param = new ParameterRasterLayer();
                    AdditionalInfoRasterLayer airl = new AdditionalInfoRasterLayer(this.m_sParameterRequired.equals("yes"));
                    param.setParameterAdditionalInfo((AdditionalInfo)airl);
                } else if (this.m_sGisPromptElement.equals("vector")) {
                    param = new ParameterVectorLayer();
                    AdditionalInfoVectorLayer aivl = new AdditionalInfoVectorLayer(-1, this.m_sParameterRequired.equals("yes"));
                    param.setParameterAdditionalInfo((AdditionalInfo)aivl);
                } else if (this.m_sGisPromptElement.equals("dbcolumn")) {
                    param = new ParameterString();
                    AdditionalInfoString ais = new AdditionalInfoString();
                    ais.setDefaultString(this.m_sDefaultValue);
                    ais.setIsField(true);
                    param.setParameterAdditionalInfo((AdditionalInfo)ais);
                } else if (this.m_sGisPromptElement.equals("file")) {
                    param = new ParameterFilepath();
                    if (this.m_sGisPromptPrompt.startsWith("dsn")) {
                        AdditionalInfoFilepath aif = new AdditionalInfoFilepath(true, true, false, null);
                        param.setParameterAdditionalInfo((AdditionalInfo)aif);
                    } else if (this.getName().equals("v.in.dxf")) {
                        String[] ext = new String[]{"dxf"};
                        AdditionalInfoFilepath aif = new AdditionalInfoFilepath(false, true, false, ext);
                        param = new ParameterFilepath();
                        param.setParameterAdditionalInfo((AdditionalInfo)aif);
                    } else {
                        AdditionalInfoFilepath aif = new AdditionalInfoFilepath(false, true, false, null);
                        param.setParameterAdditionalInfo((AdditionalInfo)aif);
                    }
                } else {
                    param = new ParameterString();
                    AdditionalInfoString ais = new AdditionalInfoString();
                    ais.setDefaultString(this.m_sDefaultValue);
                    param.setParameterAdditionalInfo((AdditionalInfo)ais);
                }
            } else if (this.m_sGisPromptElement.equals("cell") || this.m_sGisPromptElement.equals("tiff")) {
                out = new OutputRasterLayer();
            } else if (this.m_sGisPromptElement.equals("vector")) {
                out = new OutputVectorLayer();
            } else if (this.m_sGisPromptElement.equals("file")) {
                param = new ParameterFilepath();
                AdditionalInfoFilepath aif = new AdditionalInfoFilepath(false, false, false, null);
                param.setParameterAdditionalInfo((AdditionalInfo)aif);
            }
        } else if (this.m_sParameterType.compareTo("float") == 0) {
            if (this.m_sParameterMultiple.equals("yes") || this.m_bKeydesc.booleanValue()) {
                param = new ParameterString();
                AdditionalInfoString ais = new AdditionalInfoString();
                ais.setDefaultString(this.m_sDefaultValue);
                param.setParameterAdditionalInfo((AdditionalInfo)ais);
            } else {
                double dDefaultValue;
                param = new ParameterNumericalValue();
                param.setParameterName(this.m_sParameterName);
                param.setParameterDescription(this.m_sDescription);
                try {
                    dDefaultValue = Double.parseDouble(this.m_sDefaultValue.trim());
                }
                catch (NumberFormatException e) {
                    dDefaultValue = 0.0;
                }
                AdditionalInfoNumericalValue ainv = new AdditionalInfoNumericalValue(2, dDefaultValue, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
                param.setParameterAdditionalInfo((AdditionalInfo)ainv);
            }
        } else if (this.m_sParameterType.compareTo("integer") == 0) {
            if (this.m_sParameterMultiple.equals("yes") || this.m_bKeydesc.booleanValue()) {
                param = new ParameterString();
                AdditionalInfoString ais = new AdditionalInfoString();
                ais.setDefaultString(this.m_sDefaultValue);
                param.setParameterAdditionalInfo((AdditionalInfo)ais);
            } else {
                int iDefaultValue;
                try {
                    iDefaultValue = Integer.parseInt(this.m_sDefaultValue.trim());
                }
                catch (NumberFormatException e) {
                    iDefaultValue = 0;
                }
                if (!this.m_sGisPromptElement.equals("layer") || iDefaultValue != 1) {
                    param = new ParameterNumericalValue();
                    param.setParameterName(this.m_sParameterName);
                    param.setParameterDescription(this.m_sDescription);
                    AdditionalInfoNumericalValue ainv = new AdditionalInfoNumericalValue(1, (double)iDefaultValue, -2.147483648E9, 2.147483647E9);
                    param.setParameterAdditionalInfo((AdditionalInfo)ainv);
                }
            }
        }
        if (param != null) {
            if (param instanceof ParameterBoolean) {
                param.setParameterName("-" + this.m_sParameterName);
                param.setParameterDescription("(-" + this.m_sParameterName + ") " + this.m_sDescription);
            } else {
                param.setParameterName(this.m_sParameterName);
                param.setParameterDescription(this.m_sParameterName);
            }
            param.setParameterTooltip(this.m_sTooltip);
            try {
                this.m_Parameters.addParameter((Parameter)param);
            }
            catch (RepeatedParameterNameException e) {
                throw new UnwrappableGrassProcessException();
            }
            this.m_sTooltip = null;
            if (this.getName().equals("r.colors") && param.getParameterName().equals("map")) {
                AdditionalInfoRasterLayer airl = new AdditionalInfoRasterLayer(true);
                param.setParameterAdditionalInfo((AdditionalInfo)airl);
            }
            try {
                if (this.getName().equals("r.colors")) {
                    if (param.getParameterName().equals("raster")) {
                        this.m_Parameters.removeParameter((Parameter)param);
                    }
                    if (param.getParameterName().equals("-r")) {
                        this.m_Parameters.removeParameter((Parameter)param);
                    }
                    if (param.getParameterName().equals("-w")) {
                        this.m_Parameters.removeParameter((Parameter)param);
                    }
                    if (param.getParameterName().equals("-i")) {
                        this.m_Parameters.removeParameter((Parameter)param);
                    }
                }
                if (this.getName().equals("r.mapcalculator")) {
                    if (param.getParameterName().equals("help")) {
                        this.m_Parameters.removeParameter((Parameter)param);
                    }
                    if (param.getParameterName().equals("-e")) {
                        this.m_Parameters.removeParameter((Parameter)param);
                    }
                    if (param.getParameterName().equals("-o")) {
                        this.m_Parameters.removeParameter((Parameter)param);
                    }
                }
                if (this.getName().equals("r.null") && (param.getParameterName().equals("-c") || param.getParameterName().equals("-n") || param.getParameterName().equals("-r"))) {
                    this.m_Parameters.removeParameter((Parameter)param);
                }
                if (this.getName().equals("v.what.vect") && param.getParameterName().equals("qlayer")) {
                    this.m_Parameters.removeParameter((Parameter)param);
                }
            }
            catch (Exception e) {
                throw new UnwrappableGrassProcessException();
            }
        }
        if (out == null) return;
        out.setName(this.m_sParameterName);
        out.setDescription(this.m_sDescription);
        this.m_OutputObjects.add(out);
    }

    private void preprocessParams() {
        String value2;
        Parameter param2;
        int i;
        try {
            Parameter column;
            Parameter layer;
            Parameter dsn;
            Parameter band;
            if (this.getName().equals("r.in.gdal") && (band = this.m_Parameters.getParameter("band")).getParameterValueAsInt() == 0) {
                this.m_Parameters.removeParameter("band");
            }
            if (this.getName().equals("r.in.srtm")) {
                Parameter input = this.m_Parameters.getParameter("input");
                String filename = new String(input.getParameterValueAsString().trim());
                if (filename.endsWith(".hgt")) {
                    filename = filename.substring(0, filename.lastIndexOf(".hgt"));
                }
                if (filename.endsWith(".hgt.zip")) {
                    filename = filename.substring(0, filename.lastIndexOf(".hgt.zip"));
                }
            }
            if (this.getName().equals("r.out.gdal")) {
                Parameter createopt;
                Parameter metaopt = this.m_Parameters.getParameter("metaopt");
                if (metaopt.getParameterValueAsString() != null && metaopt.getParameterValueAsString().trim().length() > 1) {
                    if (!metaopt.getParameterValueAsString().trim().startsWith("\"")) {
                        metaopt.setParameterValue((Object)("\"" + metaopt.getParameterValueAsString().trim()));
                    }
                    if (!metaopt.getParameterValueAsString().trim().endsWith("\"")) {
                        metaopt.setParameterValue((Object)(metaopt.getParameterValueAsString().trim() + "\""));
                    }
                }
                if ((createopt = this.m_Parameters.getParameter("createopt")).getParameterValueAsString() != null && createopt.getParameterValueAsString().trim().length() > 1) {
                    if (!createopt.getParameterValueAsString().trim().startsWith("\"")) {
                        createopt.setParameterValue((Object)("\"" + createopt.getParameterValueAsString().trim()));
                    }
                    if (!createopt.getParameterValueAsString().trim().endsWith("\"")) {
                        createopt.setParameterValue((Object)(createopt.getParameterValueAsString().trim() + "\""));
                    }
                }
            }
            if (this.getName().equals("v.in.ogr") && ((dsn = this.m_Parameters.getParameter("dsn")).getParameterValueAsString() == null || dsn.getParameterValueAsString().trim().length() < 1)) {
                layer = this.m_Parameters.getParameter("layer");
                dsn.setParameterValue((Object)layer.getParameterValueAsString());
                this.m_Parameters.removeParameter("layer");
            }
            if (this.getName().equals("v.out.ogr") && ((dsn = this.m_Parameters.getParameter("dsn")).getParameterValueAsString() == null || dsn.getParameterValueAsString().trim().length() < 1)) {
                Parameter lco;
                layer = this.m_Parameters.getParameter("olayer");
                Parameter format = this.m_Parameters.getParameter("format");
                String filename = new String(layer.getParameterValueAsString());
                String ext_new = "";
                Parameter dsco = this.m_Parameters.getParameter("dsco");
                if (dsco.getParameterValueAsString() != null && dsco.getParameterValueAsString().trim().length() > 1) {
                    if (!dsco.getParameterValueAsString().trim().startsWith("\"")) {
                        dsco.setParameterValue((Object)("\"" + dsco.getParameterValueAsString().trim()));
                    }
                    if (!dsco.getParameterValueAsString().trim().endsWith("\"")) {
                        dsco.setParameterValue((Object)(dsco.getParameterValueAsString().trim() + "\""));
                    }
                }
                if ((lco = this.m_Parameters.getParameter("lco")).getParameterValueAsString() != null && lco.getParameterValueAsString().trim().length() > 1) {
                    if (!lco.getParameterValueAsString().trim().startsWith("\"")) {
                        lco.setParameterValue((Object)("\"" + lco.getParameterValueAsString().trim()));
                    }
                    if (!lco.getParameterValueAsString().trim().endsWith("\"")) {
                        lco.setParameterValue((Object)(lco.getParameterValueAsString().trim() + "\""));
                    }
                }
                if (format.getParameterValueAsString().equals("ESRI_Shapefile")) {
                    ext_new = new String(".shp");
                }
                if (format.getParameterValueAsString().equals("MapInfo_File")) {
                    ext_new = new String(".tab");
                    if (dsco.getParameterValueAsString() != null && dsco.getParameterValueAsString().trim().length() > 1 && dsco.getParameterValueAsString().trim().contains("")) {
                        ext_new = new String(".mif");
                    }
                }
                if (format.getParameterValueAsString().equals("DGN")) {
                    ext_new = new String(".dgn");
                }
                if (format.getParameterValueAsString().equals("BNA")) {
                    ext_new = new String(".bna");
                }
                if (format.getParameterValueAsString().equals("CSV")) {
                    ext_new = new String(".csv");
                }
                if (format.getParameterValueAsString().equals("GML")) {
                    ext_new = new String(".gml");
                }
                if (format.getParameterValueAsString().equals("GPX")) {
                    ext_new = new String(".gpx");
                }
                if (format.getParameterValueAsString().equals("KML")) {
                    ext_new = new String(".kml");
                }
                if (format.getParameterValueAsString().equals("GeoJSON")) {
                    ext_new = new String(".geojson");
                }
                if (format.getParameterValueAsString().equals("GMT")) {
                    ext_new = new String(".gmt");
                }
                if (format.getParameterValueAsString().equals("Geoconcept")) {
                    ext_new = new String(".gxt");
                }
                if (!filename.toLowerCase().endsWith(ext_new)) {
                    layer.setParameterValue((Object)(filename + ext_new));
                }
                dsn.setParameterValue((Object)layer.getParameterValueAsString());
                this.m_Parameters.removeParameter("olayer");
            }
            if (this.getName().equals("v.to.3d") && (column = this.m_Parameters.getParameter("column")).getParameterValueAsString() != null && column.getParameterValueAsString().trim().length() > 0) {
                this.m_Parameters.removeParameter("height");
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((String)("Error parsing parameters for GRASS module " + this.getName() + "\n"));
        }
        ArrayList<String> remove = new ArrayList<String>();
        for (i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            param2 = this.m_Parameters.getParameter(i);
            if (param2 instanceof ParameterBoolean) continue;
            try {
                if (param2 instanceof ParameterMultipleInput) {
                    ArrayList sValues = param2.getParameterValueAsArrayList();
                    if (sValues.size() >= 1) continue;
                    remove.add(param2.getParameterName());
                    continue;
                }
                value2 = new String(param2.getParameterValueAsString());
                if (value2 != null && value2.trim().length() >= 1) continue;
                remove.add(param2.getParameterName());
                continue;
            }
            catch (Exception value2) {
                // empty catch block
            }
        }
        for (i = 0; i < remove.size(); ++i) {
            try {
                this.m_Parameters.removeParameter((String)remove.get(i));
                continue;
            }
            catch (Exception param2) {
                // empty catch block
            }
        }
        for (i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            param2 = this.m_Parameters.getParameter(i);
            try {
                value2 = new String(param2.getParameterValueAsString());
                if (!value2.contains(" ")) continue;
                param2.setParameterValue((Object)("\"" + value2.trim() + "\""));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void preprocessBeforeExec() {
        try {
            Parameter formula;
            if (this.getName().equals("r.mapcalculator") && (formula = this.m_Parameters.getParameter("formula")).getParameterValueAsString() != null && formula.getParameterValueAsString().trim().length() > 0) {
                String expression = formula.getParameterValueAsString().trim();
                String[] long_names = new String[]{"amap", "bmap", "cmap", "dmap", "emap", "fmap"};
                String[] short_names = new String[]{"A", "B", "C", "D", "E", "F"};
                for (int i = 0; i < long_names.length; ++i) {
                    try {
                        Parameter map = this.m_Parameters.getParameter(long_names[i]);
                        String filename = ((FileOutputChannel)map.getParameterValueAsRasterLayer().getOutputChannel()).getFilename();
                        String subst = this.getInFile(filename);
                        if (subst == null || subst.trim().length() <= 0) continue;
                        expression = expression.replace(short_names[i], subst);
                        expression = expression.replace(long_names[i], subst);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                formula.setParameterValue((Object)("\"" + expression + "\""));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_warning_postprocess"), Sextante.getText((String)"grass_warning_title"), 2);
        }
    }

    private void postProcessBeforeExport() {
        try {
            OutputVectorLayer tmpOut;
            String filename;
            Parameter map;
            String mapname;
            Parameter column;
            if (this.getName().equals("v.distance") && (column = this.m_Parameters.getParameter("column")).getParameterValueAsString() != null && column.getParameterValueAsString().trim().length() > 0) {
                Parameter from = this.m_Parameters.getParameter("from");
                mapname = new String(this.getInFile(((FileOutputChannel)from.getParameterValueAsVectorLayer().getOutputChannel()).getFilename()));
                Parameter upload = this.m_Parameters.getParameter("upload");
                OutputVectorLayer tmpOut2 = new OutputVectorLayer();
                tmpOut2.setDescription("v.distance (+" + upload.getParameterValueAsString().trim() + ")");
                tmpOut2.setName(mapname);
                this.m_OutputObjects.add((Output)tmpOut2);
                tmpOut2.setOutputChannel(this.getOutputChannel(tmpOut2.getName()));
            }
            if (this.getName().equals("v.edit")) {
                map = this.m_Parameters.getParameter("map");
                filename = ((FileOutputChannel)map.getParameterValueAsVectorLayer().getOutputChannel()).getFilename();
                mapname = new String(this.getInFile(filename));
                tmpOut = new OutputVectorLayer();
                tmpOut.setDescription("v.edit (edited)");
                tmpOut.setName(mapname);
                this.m_OutputObjects.add((Output)tmpOut);
                tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
            }
            if (this.getName().equals("v.what.vect")) {
                Parameter vector = this.m_Parameters.getParameter("vector");
                filename = ((FileOutputChannel)vector.getParameterValueAsVectorLayer().getOutputChannel()).getFilename();
                mapname = new String(this.getInFile(filename));
                tmpOut = new OutputVectorLayer();
                tmpOut.setDescription("v.what.vect (query)");
                tmpOut.setName(mapname);
                this.m_OutputObjects.add((Output)tmpOut);
                tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
            }
            if (this.getName().equals("r.null")) {
                map = this.m_Parameters.getParameter("map");
                filename = ((FileOutputChannel)map.getParameterValueAsRasterLayer().getOutputChannel()).getFilename();
                mapname = new String(this.getInFile(filename));
                tmpOut = new OutputRasterLayer();
                tmpOut.setDescription("r.null (null)");
                tmpOut.setName(mapname);
                this.m_OutputObjects.add((Output)tmpOut);
                tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
            }
            if (this.getName().equals("r.colors")) {
                map = this.m_Parameters.getParameter("map");
                filename = ((FileOutputChannel)map.getParameterValueAsRasterLayer().getOutputChannel()).getFilename();
                mapname = new String(this.getInFile(filename));
                tmpOut = new OutputRasterLayer();
                tmpOut.setDescription("r.colors (colors)");
                tmpOut.setName(mapname);
                this.m_OutputObjects.add((Output)tmpOut);
                tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
            }
            if (this.getName().equals("r.colors.stddev")) {
                Parameter input = this.m_Parameters.getParameter("input");
                filename = ((FileOutputChannel)input.getParameterValueAsRasterLayer().getOutputChannel()).getFilename();
                mapname = new String(this.getInFile(filename));
                tmpOut = new OutputRasterLayer();
                tmpOut.setDescription("r.colors.stddev (colors)");
                tmpOut.setName(mapname);
                this.m_OutputObjects.add((Output)tmpOut);
                tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_warning_postprocess"), Sextante.getText((String)"grass_warning_title"), 2);
        }
    }

    private String applyBBoxFilter(IVectorLayer layer) {
        String result = new String("");
        boolean noVectBBox = new Boolean(SextanteGUI.getSettingParameterValue("GrassNoVectBBox"));
        if (noVectBBox) {
            return result;
        }
        result = result + " spatial=";
        result = result + this.m_AnalysisExtent.getXMin() + ",";
        result = result + this.m_AnalysisExtent.getYMin() + ",";
        result = result + this.m_AnalysisExtent.getXMax() + ",";
        result = result + this.m_AnalysisExtent.getYMax();
        return result;
    }

    private String applySelectionFilter(IVectorLayer layer, String mapname, List<Integer> keys) {
        String result = new String("");
        List filterList = layer.getFilters();
        String line = new String();
        int numFilters = filterList.size();
        for (int iFilter = 0; iFilter < numFilters; ++iFilter) {
            IVectorLayerFilter Filter2 = (IVectorLayerFilter)filterList.get(iFilter);
            if (!(Filter2 instanceof SelectionFilter)) continue;
            ArrayList<String> rangesList = new ArrayList<String>();
            int start = -2;
            int end = -2;
            boolean range_open = false;
            for (int iFeature = 0; iFeature < ((SelectionFilter)Filter2).getLast(); ++iFeature) {
                boolean selected = ((IVectorLayerFilter)filterList.get(iFilter)).accept(null, iFeature);
                if (!selected) continue;
                if (iFeature > end + 1) {
                    if (end != -2) {
                        line = start == end ? start + 1 + "" : start + 1 + "-" + (end + 1);
                        for (int i = start + 1; i <= end + 1; ++i) {
                            keys.add(i);
                        }
                        rangesList.add(line);
                        range_open = false;
                        start = iFeature;
                    } else {
                        start = iFeature;
                    }
                    end = iFeature;
                    range_open = true;
                    continue;
                }
                end = iFeature;
            }
            if (range_open) {
                line = start == end ? start + 1 + "" : start + 1 + "-" + (end + 1);
                for (int i = start + 1; i <= end + 1; ++i) {
                    keys.add(i);
                }
                rangesList.add(line);
            }
            if (rangesList.size() <= 0) continue;
            result = "v.extract --quiet --overwrite input=" + mapname + " output=" + mapname + "2" + " list=";
            for (int iRange = 0; iRange < rangesList.size(); ++iRange) {
                result = iRange < rangesList.size() - 1 ? result + (String)rangesList.get(iRange) + "," : result + (String)rangesList.get(iRange);
            }
            result = result + "\n";
        }
        if (result.length() > 1) {
            result = result + "g.remove vect=" + mapname + " --quiet\n";
            result = result + "g.rename vect=" + mapname + "2," + mapname + " --quiet\n";
        }
        return result;
    }

    public void defineCharacteristics() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Output out;
        int i;
        File file;
        IOutputChannel channel;
        int i2;
        String sFilename;
        boolean bIsInPolylines = new Boolean(SextanteGUI.getSettingParameterValue("GrassInPolylines"));
        StringBuffer sCommand = new StringBuffer();
        boolean gotKilled = false;
        GrassUtils.setInterruptible(true);
        this.preprocessParams();
        String modName = new String("| STARTING GRASS module: " + this.getName() + " |");
        GrassAlgorithmProvider.addMessage("   ");
        StringBuffer decoration = new StringBuffer("+");
        for (int i3 = 0; i3 < modName.length() - 2; ++i3) {
            decoration.append("-");
        }
        decoration.append("+");
        GrassAlgorithmProvider.addMessage(decoration.toString());
        GrassAlgorithmProvider.addMessage(modName);
        GrassAlgorithmProvider.addMessage(decoration.toString());
        GrassAlgorithmProvider.addMessage("   ");
        try {
            GrassUtils.createTempMapset();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"GRASS_error_create_temp_mapset") + "\n" + e.getMessage(), "", 0);
        }
        this.m_FilesIn = new ArrayList();
        this.m_MapsIn = new ArrayList();
        String mapset = new String(GrassUtils.getGrassMapsetFolder().substring(GrassUtils.getGrassMapsetFolder().lastIndexOf(File.separator) + 1, GrassUtils.getGrassMapsetFolder().length()));
        String path = new String(GrassUtils.getGrassMapsetFolder().substring(0, GrassUtils.getGrassMapsetFolder().lastIndexOf(File.separator)));
        String location = new String(path.substring(path.lastIndexOf(File.separator) + 1, path.length()));
        String gisdbase = new String(path.substring(0, path.lastIndexOf(File.separator)));
        boolean bCompatMode = new Boolean(SextanteGUI.getSettingParameterValue("GrassCompatibilityMode"));
        if (!bCompatMode) {
            sCommand.append("db.connect driver=sqlite database='" + gisdbase + File.separator + location + File.separator + mapset + File.separator + "sqlite.db'\n");
        }
        if (this.getUserCanDefineAnalysisExtent()) {
            if (this.m_AnalysisExtent.getYMin() == this.m_AnalysisExtent.getYMax() || this.m_AnalysisExtent.getXMin() == this.m_AnalysisExtent.getXMax()) {
                sCommand.append("g.region");
                sCommand.append(" n=1");
                sCommand.append(" s=0");
                sCommand.append(" e=1");
                sCommand.append(" w=0");
                sCommand.append(" res=" + Double.toString(this.m_AnalysisExtent.getCellSize()) + "\n");
            } else {
                sCommand.append("g.region");
                sCommand.append(" n=" + Double.toString(this.m_AnalysisExtent.getYMax()));
                sCommand.append(" s=" + Double.toString(this.m_AnalysisExtent.getYMin()));
                sCommand.append(" e=" + Double.toString(this.m_AnalysisExtent.getXMax()));
                sCommand.append(" w=" + Double.toString(this.m_AnalysisExtent.getXMin()));
                sCommand.append(" res=" + Double.toString(this.m_AnalysisExtent.getCellSize()) + "\n");
            }
        }
        try {
            GrassUtils.runGRASS(sCommand, "Setting GRASS region:", this);
        }
        catch (Exception e) {
            gotKilled = true;
        }
        sCommand = new StringBuffer();
        ArrayList<String> rasterLayers = new ArrayList<String>();
        ArrayList<String> vectorLayers = new ArrayList<String>();
        ArrayList layers = this.m_Parameters.getParametersOfType(ParameterRasterLayer.class);
        for (int i4 = 0; i4 < layers.size(); ++i4) {
            IRasterLayer layer = ((ParameterRasterLayer)layers.get(i4)).getParameterValueAsRasterLayer();
            if (layer == null) continue;
            IOutputChannel channel2 = layer.getOutputChannel();
            if (!(channel2 instanceof FileOutputChannel)) throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Input_layers_are_not_compatible_with_GRASS_usage_\nMust_be_file-based_layers"));
            sFilename = ((FileOutputChannel)channel2).getFilename();
            String sGrassName = GrassUtils.getTempMapName();
            if (bCompatMode) {
                sCommand.append("r.in.gdal");
            } else {
                sCommand.append("r.external");
            }
            sCommand.append(" input=\"" + sFilename + "\"");
            sCommand.append(" band=1");
            sCommand.append(" output=" + sGrassName);
            sCommand.append(" --overwrite -o\n");
            rasterLayers.add(sGrassName);
            this.registerInMapping(sFilename, sGrassName);
        }
        ArrayList multiLayers = this.m_Parameters.getParametersOfType(ParameterMultipleInput.class);
        for (int i5 = 0; i5 < multiLayers.size(); ++i5) {
            AdditionalInfo ai = ((ParameterMultipleInput)multiLayers.get(i5)).getParameterAdditionalInfo();
            if (((AdditionalInfoMultipleInput)ai).getDataType() != 1) continue;
            ArrayList layerList = ((ParameterMultipleInput)multiLayers.get(i5)).getParameterValueAsArrayList();
            for (int j = 0; j < layerList.size(); ++j) {
                IRasterLayer layer = (IRasterLayer)layerList.get(j);
                if (layer == null) continue;
                IOutputChannel channel3 = layer.getOutputChannel();
                if (!(channel3 instanceof FileOutputChannel)) throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Input_layers_are_not_compatible_with_GRASS_usage_\nMust_be_file-based_layers"));
                sFilename = ((FileOutputChannel)channel3).getFilename();
                String sGrassName = GrassUtils.getTempMapName();
                if (bCompatMode) {
                    sCommand.append("r.in.gdal");
                } else {
                    sCommand.append("r.external");
                }
                sCommand.append(" input=\"" + sFilename + "\"");
                sCommand.append(" band=1");
                sCommand.append(" output=" + sGrassName);
                sCommand.append(" --overwrite -o\n");
                rasterLayers.add(sGrassName);
                boolean bSEXTANTENull = new Boolean(SextanteGUI.getSettingParameterValue("GrassUseSextanteNull"));
                if (bSEXTANTENull) {
                    sCommand.append("r.null map=" + sGrassName);
                    sCommand.append(" setnull=\"" + Double.toString(SextanteGUI.getOutputFactory().getDefaultNoDataValue()) + "\"");
                    sCommand.append("\n");
                }
                this.registerInMapping(sFilename, sGrassName);
            }
        }
        layers = this.m_Parameters.getParametersOfType(ParameterVectorLayer.class);
        boolean bRunIteratively = false;
        String sIterMap = null;
        int iIteration = -1;
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (i2 = 0; i2 < layers.size(); ++i2) {
            boolean bIs3DVMode;
            IVectorLayer layer = ((ParameterVectorLayer)layers.get(i2)).getParameterValueAsVectorLayer();
            if (layer == null) continue;
            channel = layer.getOutputChannel();
            sFilename = "";
            if (channel instanceof FileOutputChannel) {
                sFilename = ((FileOutputChannel)channel).getFilename();
            } else {
                if (channel != null) throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Input_layers_are_not_compatible_with_GRASS_usage_\nMust_be_file-based_layers"));
                if (!(layer instanceof SingleFeatureVectorLayer)) throw new GeoAlgorithmExecutionException(Sextante.getText((String)"output_channel_null"));
                iIteration = ((SingleFeatureVectorLayer)layer).getID();
                layer = ((SingleFeatureVectorLayer)layer).getOriginalLayer();
                channel = layer.getOutputChannel();
                sFilename = ((FileOutputChannel)channel).getFilename();
                bRunIteratively = true;
            }
            file = new File(sFilename);
            String sName = file.getName().substring(0, file.getName().indexOf(46));
            String sGrassName = GrassUtils.getTempMapName();
            if (bRunIteratively) {
                sIterMap = new String(sGrassName);
            }
            String sSelectionFilter = new String(this.applySelectionFilter(layer, sGrassName, keys));
            sCommand.append("v.in.ogr");
            String sParent = file.getParent();
            if (sParent.endsWith(File.separator)) {
                sParent = sParent.substring(0, sParent.length() - 1);
            }
            if (bIsInPolylines) {
                sCommand.append(" type=line");
            }
            sCommand.append(" min_area=-1");
            sCommand.append(" dsn=\"" + sParent + "\"");
            sCommand.append(" layer=" + sName);
            sCommand.append(" output=" + sGrassName);
            String sBoxFilter = this.applyBBoxFilter(layer);
            if (sBoxFilter.length() > 1 && !bRunIteratively && sSelectionFilter.length() < 1) {
                sCommand.append(sBoxFilter);
            }
            sCommand.append(" --overwrite -o");
            boolean bCleanPolygons = new Boolean(SextanteGUI.getSettingParameterValue("GrassCleanPolygons"));
            if (!bCleanPolygons) {
                sCommand.append(" -c");
            }
            if (bIs3DVMode = new Boolean(SextanteGUI.getSettingParameterValue("Grass3DVMode")).booleanValue()) {
                sCommand.append(" -z");
            }
            sCommand.append("\n");
            if (sSelectionFilter.length() > 1) {
                sCommand.append(sSelectionFilter);
            }
            if (bRunIteratively) {
                sCommand.append("v.extract --quiet --overwrite");
                sCommand.append(" input=" + sIterMap);
                sCommand.append(" output=" + sIterMap + "2");
                if (sSelectionFilter.length() > 1) {
                    sCommand.append(" list=" + keys.get(iIteration - 1));
                } else {
                    sCommand.append(" list=" + iIteration);
                }
                sCommand.append("\n");
                sCommand.append("g.remove vect=" + sIterMap);
                sCommand.append(" --quiet");
                sCommand.append("\n");
                sCommand.append("g.rename vect=" + sIterMap + "2");
                sCommand.append("," + sIterMap);
                sCommand.append(" --quiet");
                sCommand.append("\n");
            }
            vectorLayers.add(sGrassName);
            this.registerInMapping(sFilename, sGrassName);
        }
        multiLayers = this.m_Parameters.getParametersOfType(ParameterMultipleInput.class);
        for (i2 = 0; i2 < multiLayers.size(); ++i2) {
            AdditionalInfo ai = ((ParameterMultipleInput)multiLayers.get(i2)).getParameterAdditionalInfo();
            if (((AdditionalInfoMultipleInput)ai).getDataType() != 5) continue;
            ArrayList layerList = ((ParameterMultipleInput)multiLayers.get(i2)).getParameterValueAsArrayList();
            for (int j = 0; j < layerList.size(); ++j) {
                boolean bIs3DVMode;
                IVectorLayer layer = (IVectorLayer)layerList.get(j);
                if (layer == null) continue;
                IOutputChannel channel4 = layer.getOutputChannel();
                if (!(channel4 instanceof FileOutputChannel)) throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Input_layers_are_not_compatible_with_GRASS_usage_\nMust_be_file-based_layers"));
                sFilename = ((FileOutputChannel)channel4).getFilename();
                file = new File(sFilename);
                String sName = file.getName().substring(0, file.getName().indexOf(46));
                String sGrassName = GrassUtils.getTempMapName();
                String sSelectionFilter = new String(this.applySelectionFilter(layer, sGrassName, keys));
                sCommand.append("v.in.ogr");
                String sParent = file.getParent();
                if (sParent.endsWith(File.separator)) {
                    sParent = sParent.substring(0, sParent.length() - 1);
                }
                if (bIsInPolylines) {
                    sCommand.append(" type=line");
                }
                sCommand.append(" min_area=-1");
                sCommand.append(" dsn=\"" + sParent + "\"");
                sCommand.append(" layer=" + sName);
                sCommand.append(" output=" + sGrassName);
                String sBoxFilter = this.applyBBoxFilter(layer);
                if (sBoxFilter.length() > 1 && sSelectionFilter.length() < 1) {
                    sCommand.append(sBoxFilter);
                }
                sCommand.append(" --overwrite -o");
                boolean bCleanPolygons = new Boolean(SextanteGUI.getSettingParameterValue("GrassCleanPolygons"));
                if (!bCleanPolygons) {
                    sCommand.append(" -c");
                }
                if (bIs3DVMode = new Boolean(SextanteGUI.getSettingParameterValue("Grass3DVMode")).booleanValue()) {
                    sCommand.append(" -z");
                }
                sCommand.append("\n");
                if (sSelectionFilter.length() > 1) {
                    sCommand.append(sSelectionFilter);
                }
                vectorLayers.add(sGrassName);
                this.registerInMapping(sFilename, sGrassName);
            }
        }
        if (this.m_MapsIn.size() > 0) {
            GrassAlgorithmProvider.addMessage("   ");
            GrassAlgorithmProvider.addMessage("[IMPORTING data into GRASS]");
            GrassAlgorithmProvider.addMessage("   ");
            this.setProgressText("Importing data...");
            if (!gotKilled && !GrassUtils.isProcessCanceled()) {
                try {
                    GrassUtils.runGRASS(sCommand, "Importing data into GRASS:", this);
                }
                catch (Exception e) {
                    gotKilled = true;
                }
            }
        }
        sCommand = new StringBuffer();
        for (i = 0; i < this.m_MapsIn.size(); ++i) {
            File rasterfile = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "cellhd" + File.separator + this.m_MapsIn.get(i));
            File vectordir = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "vector" + File.separator + this.m_MapsIn.get(i));
            if (rasterfile.exists() || vectordir.exists()) continue;
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_import_failed"), Sextante.getText((String)"grass_error_title"), 0);
            throw new GrassExecutionException();
        }
        for (i = 0; i < this.m_OutputObjects.getOutputDataObjectsCount(); ++i) {
            out = this.m_OutputObjects.getOutput(i);
            out.setOutputChannel(this.getOutputChannel(out.getName()));
        }
        this.preprocessBeforeExec();
        sCommand.append(this.getName());
        for (i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            Parameter param = this.m_Parameters.getParameter(i);
            if (param.getParameterName().equals(PARAMETER_RESTRICT_VECTOR_OUTPUT_TYPE)) continue;
            if (param instanceof ParameterBoolean) {
                if (!param.getParameterValueAsBoolean()) continue;
                sCommand.append(" " + param.getParameterName());
                continue;
            }
            if (param instanceof ParameterDataObject) {
                IDataObject dataObject = (IDataObject)((ParameterDataObject)param).getParameterValueAsObject();
                if (dataObject == null) continue;
                sCommand.append(" ");
                sCommand.append(param.getParameterName());
                sCommand.append("=");
                if (bRunIteratively) {
                    file = new File(sIterMap);
                    sCommand.append(sIterMap);
                    continue;
                }
                file = new File(((FileOutputChannel)dataObject.getOutputChannel()).getFilename());
                sCommand.append(this.getInFile(((FileOutputChannel)dataObject.getOutputChannel()).getFilename()));
                continue;
            }
            if (param instanceof ParameterMultipleInput) {
                ArrayList sValues = param.getParameterValueAsArrayList();
                sCommand.append(" ");
                sCommand.append(param.getParameterName());
                sCommand.append("=");
                AdditionalInfo ai = ((ParameterMultipleInput)param).getParameterAdditionalInfo();
                if (((AdditionalInfoMultipleInput)ai).getDataType() == 1 || ((AdditionalInfoMultipleInput)ai).getDataType() == 5) {
                    for (int j = 0; j < sValues.size(); ++j) {
                        IRasterLayer layer;
                        if (((AdditionalInfoMultipleInput)ai).getDataType() == 1) {
                            layer = (IRasterLayer)sValues.get(j);
                            sFilename = new String(((FileOutputChannel)layer.getOutputChannel()).getFilename());
                        } else {
                            layer = (IVectorLayer)sValues.get(j);
                            sFilename = new String(((FileOutputChannel)layer.getOutputChannel()).getFilename());
                        }
                        sCommand.append(this.getInFile(sFilename));
                        if (j >= sValues.size() - 1) continue;
                        sCommand.append(",");
                    }
                    continue;
                }
                for (int k = 0; k < sValues.size(); ++k) {
                    sCommand.append(sValues.get(k));
                    if (k >= sValues.size() - 1) continue;
                    sCommand.append(",");
                }
                continue;
            }
            String sValue = param.getParameterValueAsString();
            if (sValue == null || sValue.trim().equals("")) continue;
            sCommand.append(" ");
            sCommand.append(param.getParameterName());
            sCommand.append("=");
            sCommand.append(sValue);
        }
        for (i = 0; i < this.m_OutputObjects.getOutputDataObjectsCount(); ++i) {
            out = this.m_OutputObjects.getOutput(i);
            channel = out.getOutputChannel();
            if (channel instanceof NullOutputChannel) continue;
            sCommand.append(" ");
            sCommand.append(out.getName() + "=" + out.getName());
        }
        sCommand.append(" --overwrite\n");
        GrassAlgorithmProvider.addMessage("   ");
        GrassAlgorithmProvider.addMessage("[EXECUTING GRASS command]");
        GrassAlgorithmProvider.addMessage("   ");
        String cmd = sCommand.toString();
        for (int i6 = 0; i6 < this.m_MapsIn.size(); ++i6) {
            cmd = cmd.replace(this.m_MapsIn.get(i6), "<" + this.m_FilesIn.get(i6) + ">");
        }
        cmd = cmd.replaceAll("([_][a-z0-9]{8}[_][a-z0-9]{4}[_][a-z0-9]{4}[_][a-z0-9]{4}[_][a-z0-9]{12})", "[TMP]");
        cmd = cmd.substring(0, cmd.length() - 1);
        GrassAlgorithmProvider.addMessage(cmd);
        GrassAlgorithmProvider.addMessage("   ");
        this.setProgress(0, 100);
        this.setProgressText("Processing...");
        if (!gotKilled && !GrassUtils.isProcessCanceled()) {
            try {
                GrassUtils.runGRASS(sCommand, "Running GRASS command:", this);
            }
            catch (Exception e) {
                gotKilled = true;
            }
        }
        sCommand = new StringBuffer();
        if (!gotKilled && !GrassUtils.isProcessCanceled()) {
            this.postProcessBeforeExport();
        }
        if (!gotKilled && !GrassUtils.isProcessCanceled()) {
            int numRuns = this.m_OutputObjects.getOutputDataObjectsCount();
            for (int i7 = 0; i7 < numRuns; ++i7) {
                OutputVectorLayer tmpOut;
                String sTempMap;
                Output out2 = this.m_OutputObjects.getOutput(i7);
                IOutputChannel channel5 = out2.getOutputChannel();
                if (channel5 instanceof NullOutputChannel || !(out2 instanceof OutputVectorLayer) || !GrassUtils.isMultiGeom(out2.getName())) continue;
                StringBuffer sSplitCommand = new StringBuffer();
                if (GrassVInfoUtils.getNumPolygons(out2.getName()) > 0) {
                    sTempMap = new String(GrassUtils.getTempMapName());
                    sSplitCommand.append("v.extract type=area input=");
                    sSplitCommand.append(out2.getName());
                    sSplitCommand.append(" output=");
                    sSplitCommand.append(sTempMap);
                    sSplitCommand.append("\n");
                    vectorLayers.add(sTempMap);
                    tmpOut = new OutputVectorLayer();
                    tmpOut.setDescription(out2.getDescription() + " (polygons)");
                    tmpOut.setName(sTempMap);
                    this.m_OutputObjects.add((Output)tmpOut);
                    tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
                }
                if (GrassVInfoUtils.getNumFaces(out2.getName()) > 0) {
                    sTempMap = new String(GrassUtils.getTempMapName());
                    sSplitCommand.append("v.extract type=face input=");
                    sSplitCommand.append(out2.getName());
                    sSplitCommand.append(" output=");
                    sSplitCommand.append(sTempMap);
                    sSplitCommand.append("\n");
                    vectorLayers.add(sTempMap);
                    tmpOut = new OutputVectorLayer();
                    tmpOut.setDescription(out2.getDescription() + " (faces)");
                    tmpOut.setName(sTempMap);
                    this.m_OutputObjects.add((Output)tmpOut);
                    tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
                }
                if (GrassVInfoUtils.getNumLines(out2.getName()) > 0) {
                    sTempMap = new String(GrassUtils.getTempMapName());
                    sSplitCommand.append("v.extract type=line input=");
                    sSplitCommand.append(out2.getName());
                    sSplitCommand.append(" output=");
                    sSplitCommand.append(sTempMap);
                    sSplitCommand.append("\n");
                    vectorLayers.add(sTempMap);
                    tmpOut = new OutputVectorLayer();
                    tmpOut.setDescription(out2.getDescription() + " (lines)");
                    tmpOut.setName(sTempMap);
                    this.m_OutputObjects.add((Output)tmpOut);
                    tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
                }
                if (GrassVInfoUtils.getNumPoints(out2.getName()) > 0) {
                    sTempMap = new String(GrassUtils.getTempMapName());
                    sSplitCommand.append("v.extract type=point input=");
                    sSplitCommand.append(out2.getName());
                    sSplitCommand.append(" output=");
                    sSplitCommand.append(sTempMap);
                    sSplitCommand.append("\n");
                    vectorLayers.add(sTempMap);
                    tmpOut = new OutputVectorLayer();
                    tmpOut.setDescription(out2.getDescription() + " (points)");
                    tmpOut.setName(sTempMap);
                    this.m_OutputObjects.add((Output)tmpOut);
                    tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
                }
                if (GrassVInfoUtils.getNumKernels(out2.getName()) > 0) {
                    sTempMap = new String(GrassUtils.getTempMapName());
                    sSplitCommand.append("v.type type=kernel,point input=");
                    sSplitCommand.append(out2.getName());
                    sSplitCommand.append(" output=");
                    sSplitCommand.append(sTempMap);
                    sSplitCommand.append("\n");
                    vectorLayers.add(sTempMap);
                    tmpOut = new OutputVectorLayer();
                    tmpOut.setDescription(out2.getDescription() + " (kernels)");
                    tmpOut.setName(sTempMap);
                    this.m_OutputObjects.add((Output)tmpOut);
                    tmpOut.setOutputChannel(this.getOutputChannel(tmpOut.getName()));
                }
                this.m_OutputObjects.remove(out2);
                if (gotKilled || GrassUtils.isProcessCanceled()) continue;
                try {
                    GrassUtils.runGRASS(sSplitCommand, "Splitting up multiple type geometries:", this);
                    continue;
                }
                catch (Exception e) {
                    gotKilled = true;
                }
            }
        }
        if (!gotKilled && !GrassUtils.isProcessCanceled()) {
            for (int i8 = 0; i8 < this.m_OutputObjects.getOutputDataObjectsCount(); ++i8) {
                Output out3 = this.m_OutputObjects.getOutput(i8);
                IOutputChannel channel6 = out3.getOutputChannel();
                if (!(channel6 instanceof FileOutputChannel)) continue;
                FileOutputChannel foc = (FileOutputChannel)channel6;
                if (out3 instanceof OutputVectorLayer) {
                    boolean is_3d = GrassVInfoUtils.isMap3D(out3.getName());
                    String optType = null;
                    String optLCO = null;
                    int num_points = 0;
                    int num_kernels = 0;
                    int num_lines = 0;
                    int num_polygons = 0;
                    int num_faces = 0;
                    if (this.m_bIsExecutedFromModeller) {
                        int iType = this.m_Parameters.getParameter(PARAMETER_RESTRICT_VECTOR_OUTPUT_TYPE).getParameterValueAsInt();
                        if (iType == 0) {
                            num_points = 1;
                        } else if (iType == 1) {
                            num_lines = 1;
                        } else if (iType == 2) {
                            num_polygons = 1;
                        }
                    } else {
                        num_points = GrassVInfoUtils.getNumPoints(out3.getName());
                        num_kernels = GrassVInfoUtils.getNumKernels(out3.getName());
                        num_lines = GrassVInfoUtils.getNumLines(out3.getName());
                        num_polygons = GrassVInfoUtils.getNumPolygons(out3.getName());
                        num_faces = GrassVInfoUtils.getNumFaces(out3.getName());
                    }
                    if (num_points > 0) {
                        optType = new String("point");
                        optLCO = is_3d ? new String("\"SHPT=POINTZ\"") : new String("\"SHPT=POINT\"");
                    }
                    if (num_kernels > 0) {
                        optType = new String("kernel");
                        optLCO = new String("\"SHPT=POINTZ\"");
                    }
                    if (num_lines > 0) {
                        optType = new String("line");
                        optLCO = is_3d ? new String("\"SHPT=ARCZ\"") : new String("\"SHPT=ARC\"");
                    }
                    if (num_polygons > 0) {
                        optType = new String("area");
                        optLCO = is_3d ? new String("\"SHPT=POLYGONZ\"") : new String("\"SHPT=POLYGON\"");
                    }
                    if (num_faces > 0) {
                        optType = new String("face");
                        optLCO = new String("\"SHPT=POLYGONZ\"");
                    }
                    if (!bCompatMode) {
                        sCommand.append("v.out.ogr -s -c input=");
                    } else {
                        sCommand.append("v.out.ogr -c input=");
                    }
                    sCommand.append(out3.getName());
                    file = new File(foc.getFilename());
                    sCommand.append(" dsn=\"" + file.getParent() + "\"");
                    String sName = file.getName().substring(0, file.getName().indexOf(46));
                    sCommand.append(" format=ESRI_Shapefile");
                    sCommand.append(" olayer=" + sName);
                    if (optType != null) {
                        sCommand.append(" type=" + optType);
                    }
                    if (optLCO != null) {
                        sCommand.append(" lco=" + optLCO);
                    }
                    sCommand.append("\n");
                    vectorLayers.add(out3.getName());
                    continue;
                }
                if (!(out3 instanceof OutputRasterLayer)) continue;
                boolean bSEXTANTENull = new Boolean(SextanteGUI.getSettingParameterValue("GrassUseSextanteNull"));
                sCommand.append("g.region rast=" + out3.getName() + "\n");
                sCommand.append("r.out.gdal -c");
                if (bSEXTANTENull) {
                    sCommand.append(" nodata=\"" + Double.toString(SextanteGUI.getOutputFactory().getDefaultNoDataValue()) + "\"");
                }
                sCommand.append(" createopt=\"TFW=YES,COMPRESS=LZW\"");
                sCommand.append(" input=");
                sCommand.append(out3.getName());
                sCommand.append(" output=\"" + foc.getFilename() + "\"");
                sCommand.append("\n");
                GrassUtils.writeColorTable(out3);
                rasterLayers.add(out3.getName());
            }
        }
        if (this.m_OutputObjects.getOutputDataObjectsCount() > 0) {
            GrassAlgorithmProvider.addMessage("   ");
            GrassAlgorithmProvider.addMessage("[EXPORTING data from GRASS]");
            GrassAlgorithmProvider.addMessage("   ");
            this.setProgressText("Exporting data...");
            if (!gotKilled && !GrassUtils.isProcessCanceled()) {
                try {
                    GrassUtils.runGRASS(sCommand, "Exporting data from GRASS:", this);
                }
                catch (Exception e) {
                    gotKilled = true;
                }
            }
        }
        GrassUtils.deleteTempMapset();
        GrassAlgorithmProvider.publishMessage("Executing GRASS Algorithm");
        if (this.m_Task.isCanceled()) return false;
        return true;
    }

    public GeoAlgorithm getNewInstance() throws InstantiationException, IllegalAccessException {
        GrassAlgorithm alg = (GrassAlgorithm)((Object)((Object)((Object)this)).getClass().newInstance());
        alg.setOutputObjects(this.m_OutputObjects.getNewInstance());
        alg.setName(this.getName());
        alg.setParameters(this.m_Parameters.getNewInstance());
        alg.setIsDeterminatedProcess(true);
        alg.setUserCanDefineAnalysisExtent(this.getUserCanDefineAnalysisExtent());
        alg.setDescriptionFile(this.m_sDescriptionFile);
        alg.m_bIsExecutedFromModeller = false;
        return alg;
    }

    private void setDescriptionFile(String descriptionFile) {
        this.m_sDescriptionFile = descriptionFile;
    }

    public ArrayList<String> getMapNames() {
        return this.m_MapsIn;
    }

    public ArrayList<String> getFileNames() {
        return this.m_FilesIn;
    }

    public String getCommandLineName() {
        return "grass:" + this.getName();
    }

    public boolean isSuitableForModelling() {
        return !GrassModelerBlackList.isInBlackList(this);
    }

    public boolean preprocessForModeller(Object obj) {
        this.m_bIsExecutedFromModeller = true;
        return true;
    }
}

