/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.GenericFileFilter;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.modeler.AlgorithmsPanel;
import es.unex.sextante.gui.modeler.InputsPanel;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.gui.modeler.ModelAlgorithmIO;
import es.unex.sextante.gui.modeler.ModelFileFilter;
import es.unex.sextante.gui.modeler.ModelGraphPanel;
import es.unex.sextante.gui.modeler.ModelerAlgorithmProvider;
import es.unex.sextante.gui.modeler.parameters.ParameterPanel;
import es.unex.sextante.outputs.Output;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public class ModelerPanel
extends JPanel {
    private JPanel jModelPanel;
    private JPanel jElementsPanel;
    private JButton jButtonMenu;
    private JButton jButtonEdit = null;
    private JButton jButtonDelete = null;
    private JPopupMenu popup;
    private JMenuItem jMenuSave;
    private JButton jButtonHelp;
    private JPanel jPanelButtonsModel;
    private JTextField jTextFieldName;
    private JComboBox jComboBoxGroup;
    private JLabel jLabelGroup;
    private JLabel jLabelName;
    private JScrollPane jModelGraphicalDescriptionPanel;
    private JTabbedPane jElementsTabbedPane;
    private JButton jButtonAdd;
    private JPanel jPanelButtonsElements;
    private InputsPanel inputsPanel;
    private AlgorithmsPanel extensionsPanel;
    private JSplitPane jSplitPane;
    private ModelGraphPanel modelGraphPanel;
    private JCheckBox jGridBox;
    private JSpinner jGridSize;
    private JButton jScaleButtonMinus;
    private JButton jScaleButtonOne;
    private JButton jScaleButtonPlus;
    private ObjectAndDescription currentNode = null;
    private ModelAlgorithm m_Algorithm;
    private final HashMap m_DataObjects = new HashMap();
    private final ArrayList m_InputKeys = new ArrayList();
    private boolean m_bHasChanged;
    private boolean m_bGridEnabled = false;
    private double m_dGridSize = 10.0;
    private double m_dScale = 1.0;
    private final JDialog m_Parent;

    public ModelerPanel(JDialog parent) {
        this.m_Algorithm = new ModelAlgorithm();
        this.m_Parent = parent;
        this.initGUI();
        this.newModel();
    }

    private void initGUI() {
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.setSize(new Dimension(950, 500));
        this.jMenuSave = new JMenuItem(new AbstractAction(Sextante.getText((String)"Save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelerPanel.this.saveModel(false);
            }
        });
        this.jSplitPane = new JSplitPane();
        this.add((Component)this.jSplitPane, "Center");
        this.jModelPanel = new JPanel();
        TableLayout jModelPanelLayout = new TableLayout((double[][])new double[][]{{5.0, -3.0, -1.0, -3.0, -1.0, 5.0}, {7.0, -3.0, -1.0, 5.0, 30.0, 5.0}});
        jModelPanelLayout.setHGap(5);
        jModelPanelLayout.setVGap(5);
        this.jModelPanel.setLayout((LayoutManager)jModelPanelLayout);
        this.jSplitPane.add((Component)this.jModelPanel, "right");
        this.modelGraphPanel = new ModelGraphPanel(this.m_Algorithm, this.m_DataObjects, this.m_InputKeys, this, this.m_Parent);
        this.jModelGraphicalDescriptionPanel = new JScrollPane();
        this.jModelGraphicalDescriptionPanel.setViewportView(this.modelGraphPanel);
        this.jModelGraphicalDescriptionPanel.setWheelScrollingEnabled(false);
        this.jLabelName = new JLabel();
        this.jLabelName.setText(Sextante.getText((String)"Name") + ":");
        this.jModelPanel.add((Component)this.jLabelName, "1, 1");
        this.jTextFieldName = new JTextField();
        this.jTextFieldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ModelerPanel.this.m_bHasChanged = true;
                ModelerPanel.this.m_Algorithm.setName(ModelerPanel.this.jTextFieldName.getText());
            }
        });
        this.jModelPanel.add((Component)this.jTextFieldName, "2, 1");
        this.jLabelGroup = new JLabel();
        this.jLabelGroup.setText(Sextante.getText((String)"Group") + ":");
        this.jModelPanel.add((Component)this.jLabelGroup, "3, 1");
        this.jComboBoxGroup = new JComboBox();
        this.jModelPanel.add((Component)this.jComboBoxGroup, "4, 1");
        JTextComponent editor = (JTextComponent)this.jComboBoxGroup.getEditor().getEditorComponent();
        editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ModelerPanel.this.m_bHasChanged = true;
                ModelerPanel.this.m_Algorithm.setGroup((String)ModelerPanel.this.jComboBoxGroup.getSelectedItem());
            }
        });
        DefaultComboBoxModel<String> jComboBoxGroupModel = new DefaultComboBoxModel<String>(this.getGroups());
        this.jComboBoxGroup.setModel(jComboBoxGroupModel);
        this.jComboBoxGroup.setEditable(true);
        this.jModelPanel.add((Component)this.modelGraphPanel, "1, 2, 4, 2");
        this.jPanelButtonsModel = new JPanel();
        TableLayout jPanelButtonsModelLayout = new TableLayout((double[][])new double[][]{{120.0, 3.0, 90.0, 3.0, 90.0, -1.0, -3.0, -3.0, 3.0, 24.0, 36.0, 24.0, 3.0}, {-1.0}});
        jPanelButtonsModelLayout.setHGap(5);
        jPanelButtonsModelLayout.setVGap(5);
        this.jPanelButtonsModel.setLayout((LayoutManager)jPanelButtonsModelLayout);
        this.jModelPanel.add((Component)this.jPanelButtonsModel, "1, 4, 5, 4");
        this.jButtonMenu = new JButton();
        this.popup = new JPopupMenu();
        this.popup.add(new JMenuItem(new AbstractAction(Sextante.getText((String)"New")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelerPanel.this.checkChangesAndCreateNewModel();
            }
        }));
        this.popup.add(new JMenuItem(new AbstractAction(Sextante.getText((String)"Open")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelerPanel.this.checkChangesAndOpenModel();
            }
        }));
        this.popup.add(new JSeparator(0));
        this.popup.add(this.jMenuSave);
        if (this.m_Algorithm.getFilename() != null) {
            this.jMenuSave.setEnabled(true);
        } else {
            this.jMenuSave.setEnabled(false);
        }
        this.popup.add(new JMenuItem(new AbstractAction(Sextante.getText((String)"Save_as")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelerPanel.this.saveModel(true);
            }
        }));
        this.jButtonMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ModelerPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.jButtonMenu.setText(Sextante.getText((String)"file_operations"));
        this.jButtonMenu.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("javax/swing/plaf/metal/icons/ocean/menu.gif")));
        this.jButtonMenu.setIconTextGap(8);
        this.jPanelButtonsModel.add((Component)this.jButtonMenu, "0, 0");
        this.jButtonEdit = new JButton();
        this.jButtonEdit.setText(Sextante.getText((String)"Edit"));
        this.jButtonEdit.setEnabled(false);
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ModelerPanel.this.currentNode != null) {
                    ModelerPanel.this.modelGraphPanel.editCell(ModelerPanel.this.currentNode);
                }
            }
        });
        this.jPanelButtonsModel.add((Component)this.jButtonEdit, "2, 0");
        this.jButtonDelete = new JButton();
        this.jButtonDelete.setText(Sextante.getText((String)"Remove"));
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ModelerPanel.this.currentNode != null) {
                    String sKey = (String)ModelerPanel.this.currentNode.getObject();
                    ModelerPanel.this.removeElement(sKey);
                }
            }
        });
        this.jPanelButtonsModel.add((Component)this.jButtonDelete, "4, 0");
        this.jGridBox = new JCheckBox(Sextante.getText((String)"modeler_grid_activate"));
        this.jGridBox.setSelected(false);
        this.jGridBox.setEnabled(true);
        this.jPanelButtonsModel.add((Component)this.jGridBox, "6, 0");
        this.jGridSize = new JSpinner(new SpinnerNumberModel((int)this.m_dGridSize, 1, 100, 1));
        this.jGridSize.setEnabled(false);
        this.jPanelButtonsModel.add((Component)this.jGridSize, "7, 0");
        this.jGridSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ModelerPanel.this.jGridBox.isSelected()) {
                    Integer value = (Integer)ModelerPanel.this.jGridSize.getValue();
                    int ival = value;
                    ModelerPanel.this.modelGraphPanel.getGraph().setGridSize((double)ival);
                    ModelerPanel.this.m_dGridSize = ival;
                }
            }
        });
        this.jGridBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ModelerPanel.this.jGridBox.isSelected()) {
                    ModelerPanel.this.modelGraphPanel.getGraph().setScale(ModelerPanel.this.m_dScale);
                    ModelerPanel.this.modelGraphPanel.getGraph().setGridEnabled(true);
                    ModelerPanel.this.modelGraphPanel.getGraph().setGridVisible(true);
                    ModelerPanel.this.m_bGridEnabled = true;
                    ModelerPanel.this.jGridSize.setEnabled(true);
                } else {
                    ModelerPanel.this.modelGraphPanel.getGraph().setScale(ModelerPanel.this.m_dScale);
                    ModelerPanel.this.modelGraphPanel.getGraph().setGridEnabled(false);
                    ModelerPanel.this.modelGraphPanel.getGraph().setGridVisible(false);
                    ModelerPanel.this.m_bGridEnabled = false;
                    ModelerPanel.this.jGridSize.setEnabled(false);
                }
            }
        });
        this.jScaleButtonMinus = new JButton(Sextante.getText((String)"-"));
        this.jPanelButtonsModel.add((Component)this.jScaleButtonMinus, "9, 0");
        this.jScaleButtonOne = new JButton(Sextante.getText((String)"1:1"));
        this.jPanelButtonsModel.add((Component)this.jScaleButtonOne, "10, 0");
        this.jScaleButtonPlus = new JButton(Sextante.getText((String)"+"));
        this.jPanelButtonsModel.add((Component)this.jScaleButtonPlus, "11, 0");
        this.jScaleButtonMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelerPanel.this.zoomMinus();
            }
        });
        this.jScaleButtonOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelerPanel.this.zoomReset();
            }
        });
        this.jScaleButtonPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelerPanel.this.zoomPlus();
            }
        });
        this.jElementsPanel = new JPanel();
        TableLayout jElementsPanelLayout = new TableLayout((double[][])new double[][]{{3.0, -1.0, 3.0}, {3.0, -1.0, 40.0, 3.0}});
        jElementsPanelLayout.setHGap(5);
        jElementsPanelLayout.setVGap(5);
        this.jElementsPanel.setLayout((LayoutManager)jElementsPanelLayout);
        this.jSplitPane.add((Component)this.jElementsPanel, "left");
        this.jSplitPane.setDividerLocation(0.3);
        this.jElementsPanel.setMinimumSize(new Dimension(250, 528));
        this.jPanelButtonsElements = new JPanel();
        TableLayout jButtonsElementsPanelLayout = new TableLayout((double[][])new double[][]{{3.0, 120.0, -1.0, -3.0, 3.0}, {3.0, 30.0, 3.0}});
        jButtonsElementsPanelLayout.setHGap(5);
        jButtonsElementsPanelLayout.setVGap(5);
        this.jPanelButtonsElements.setLayout((LayoutManager)jButtonsElementsPanelLayout);
        this.jButtonAdd = new JButton();
        this.jButtonAdd.setText(Sextante.getText((String)"Add") + "...");
        this.jPanelButtonsElements.add((Component)this.jButtonAdd, "1, 1");
        this.jButtonAdd.setEnabled(false);
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                switch (ModelerPanel.this.jElementsTabbedPane.getSelectedIndex()) {
                    case 0: {
                        ModelerPanel.this.inputsPanel.addSelectedInput();
                        break;
                    }
                    case 1: {
                        ModelerPanel.this.extensionsPanel.addSelectedProcess();
                    }
                }
            }
        });
        this.jButtonHelp = new JButton();
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/info.gif")));
        this.jPanelButtonsElements.add((Component)this.jButtonHelp, "3, 1");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelerPanel.this.showHelp(evt);
            }
        });
        this.jElementsPanel.add((Component)this.jPanelButtonsElements, "1, 2");
        this.jElementsTabbedPane = new JTabbedPane();
        this.jElementsTabbedPane.setTabPlacement(3);
        this.jElementsPanel.add((Component)this.jElementsTabbedPane, "1, 1");
        this.inputsPanel = new InputsPanel(this, this.m_Parent);
        this.jElementsTabbedPane.addTab(Sextante.getText((String)"Inputs"), null, this.inputsPanel, null);
        this.extensionsPanel = new AlgorithmsPanel(this, this.m_Parent);
        this.jElementsTabbedPane.addTab(Sextante.getText((String)"Procedures"), null, this.extensionsPanel, null);
        this.inputsPanel.getTree().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ParameterPanel paramPanel;
                DefaultMutableTreeNode node;
                ModelerPanel.this.jButtonAdd.setEnabled(false);
                if (ModelerPanel.this.inputsPanel.getTree().getSelectionPath() != null && (node = (DefaultMutableTreeNode)ModelerPanel.this.inputsPanel.getTree().getSelectionPath().getLastPathComponent()).getUserObject() instanceof ParameterPanel && (paramPanel = (ParameterPanel)node.getUserObject()).parameterCanBeAdded()) {
                    ModelerPanel.this.jButtonAdd.setEnabled(true);
                }
                ModelerPanel.this.jButtonAdd.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.inputsPanel.getTree().addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                ParameterPanel paramPanel;
                DefaultMutableTreeNode node;
                ModelerPanel.this.jButtonAdd.setEnabled(false);
                if (ModelerPanel.this.inputsPanel.getTree().getSelectionPath() != null && (node = (DefaultMutableTreeNode)ModelerPanel.this.inputsPanel.getTree().getSelectionPath().getLastPathComponent()).getUserObject() instanceof ParameterPanel && (paramPanel = (ParameterPanel)node.getUserObject()).parameterCanBeAdded()) {
                    ModelerPanel.this.jButtonAdd.setEnabled(true);
                }
                ModelerPanel.this.jButtonAdd.repaint();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.extensionsPanel.getTree().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode node;
                ModelerPanel.this.jButtonAdd.setEnabled(false);
                if (ModelerPanel.this.extensionsPanel.getTree().getSelectionPath() != null && !((node = (DefaultMutableTreeNode)ModelerPanel.this.extensionsPanel.getTree().getSelectionPath().getLastPathComponent()).getUserObject() instanceof String)) {
                    GeoAlgorithm alg = (GeoAlgorithm)node.getUserObject();
                    if (ModelerPanel.this.extensionsPanel.isAlgorithmEnabled(alg)) {
                        ModelerPanel.this.jButtonAdd.setEnabled(true);
                    }
                }
                ModelerPanel.this.jButtonAdd.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.extensionsPanel.getTree().addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                ParameterPanel paramPanel;
                DefaultMutableTreeNode node;
                ModelerPanel.this.jButtonAdd.setEnabled(false);
                if (ModelerPanel.this.extensionsPanel.getTree().getSelectionPath() != null && (node = (DefaultMutableTreeNode)ModelerPanel.this.extensionsPanel.getTree().getSelectionPath().getLastPathComponent()).getUserObject() instanceof ParameterPanel && (paramPanel = (ParameterPanel)node.getUserObject()).parameterCanBeAdded()) {
                    ModelerPanel.this.jButtonAdd.setEnabled(true);
                }
                ModelerPanel.this.jButtonAdd.repaint();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public boolean getGridEnabled() {
        return this.m_bGridEnabled;
    }

    public double getScale() {
        return this.m_dScale;
    }

    public double getGridSize() {
        return this.m_dGridSize;
    }

    public void toggleEditButtons(boolean active, ObjectAndDescription node) {
        if (this.jButtonEdit != null && this.jButtonDelete != null) {
            if (active) {
                this.jButtonEdit.setEnabled(true);
                this.jButtonDelete.setEnabled(true);
                this.currentNode = node;
            } else {
                this.jButtonEdit.setEnabled(false);
                this.jButtonDelete.setEnabled(false);
                this.currentNode = null;
            }
            this.jButtonEdit.repaint();
            this.jButtonDelete.repaint();
        }
    }

    public void zoomMinus() {
        if (this.m_dScale > 0.2) {
            this.m_dScale *= 0.9;
            this.modelGraphPanel.getGraph().setScale(this.m_dScale);
        }
    }

    public void zoomPlus() {
        if (this.m_dScale < 2.0) {
            this.m_dScale *= 1.1;
            this.modelGraphPanel.getGraph().setScale(this.m_dScale);
        }
    }

    public void zoomReset() {
        this.m_dScale = 1.0;
        this.modelGraphPanel.getGraph().setScale(this.m_dScale);
    }

    private String[] getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(Sextante.getText((String)"Models"));
        HashMap algs2 = (HashMap)Sextante.getAlgorithms().get("SEXTANTE");
        Set keys = algs2.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            GeoAlgorithm alg = (GeoAlgorithm)algs2.get(iter.next());
            if (groups.contains(alg.getGroup())) continue;
            groups.add(alg.getGroup());
        }
        Object[] sortedGroups = groups.toArray(new String[0]);
        Arrays.sort(sortedGroups);
        return sortedGroups;
    }

    protected void showHelp(ActionEvent evt) {
        SextanteGUI.getGUIFactory().showHelpDialog("modeler");
    }

    public ModelGraphPanel getGraph() {
        return this.modelGraphPanel;
    }

    public void checkChangesAndOpenModel(String sFilename) {
        if (this.m_bHasChanged) {
            int iRet = JOptionPane.showConfirmDialog(null, Sextante.getText((String)"Model_has_been_modified") + "\n" + Sextante.getText((String)"Do_you_want_to_open_a_new_model_without_saving_changes"), Sextante.getText((String)"Warning"), 1);
            if (iRet == 0) {
                this.openModel(sFilename);
            }
        } else {
            this.openModel(sFilename);
        }
    }

    public void checkChangesAndCloseModel() {
        int iRet;
        if (this.m_bHasChanged && (iRet = JOptionPane.showConfirmDialog(null, Sextante.getText((String)"Model_has_been_modified") + "\n" + Sextante.getText((String)"Do_you_want_to_save_your_changes"), Sextante.getText((String)"Warning"), 0)) == 0) {
            this.saveModel(false);
        }
    }

    private void openModel(String sFilename) {
        this.newModel();
        if (sFilename != null) {
            File file = new File(sFilename);
            try {
                this.m_Algorithm = ModelAlgorithmIO.open(file, this);
                this.extensionsPanel.setAlgorithm(this.m_Algorithm);
                this.extensionsPanel.setAlgorithmCount(this.m_Algorithm.getAlgorithms().size() + 1);
                this.updatePanel(false);
                this.jTextFieldName.setText(this.m_Algorithm.getName());
                JTextField textField = (JTextField)this.jComboBoxGroup.getEditor().getEditorComponent();
                textField.setText(this.m_Algorithm.getGroup());
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
                return;
            }
            this.jMenuSave.setEnabled(true);
        }
        this.m_bHasChanged = false;
    }

    protected void checkChangesAndOpenModel() {
        if (this.m_bHasChanged) {
            int iRet = JOptionPane.showConfirmDialog(null, Sextante.getText((String)"Model_has_been_modified") + "\n" + Sextante.getText((String)"Do_you_want_to_open_a_new_model_without_saving_changes"), Sextante.getText((String)"Warning"), 1);
            if (iRet == 0) {
                this.openModel();
            }
        } else {
            this.openModel();
        }
    }

    protected void saveModel(boolean SaveAs) {
        int returnVal;
        String sFilename = this.m_Algorithm.getFilename();
        JFileChooser fc = new JFileChooser();
        GenericFileFilter javaFilter = new GenericFileFilter("java", Sextante.getText((String)"Java_code") + " (*.java)");
        ModelFileFilter modelFilter = new ModelFileFilter();
        fc.addChoosableFileFilter(modelFilter);
        fc.addChoosableFileFilter(javaFilter);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(modelFilter);
        if (sFilename != null) {
            fc.setSelectedFile(new File(sFilename));
        } else {
            String sFolder = SextanteGUI.getSettingParameterValue("ModelsFolder");
            fc.setCurrentDirectory(new File(sFolder));
        }
        if (SaveAs || this.m_Algorithm.getFilename() == null) {
            File f;
            returnVal = fc.showSaveDialog(this);
            if (returnVal == 0 && fc.getSelectedFile() != null && (f = fc.getSelectedFile()).exists()) {
                int iRet = JOptionPane.showConfirmDialog(null, Sextante.getText((String)"Model_file_exists") + "\n" + Sextante.getText((String)"Do_you_want_to_overwrite"), Sextante.getText((String)"Warning"), 1);
                returnVal = iRet == 0 ? 0 : 1;
            }
        } else {
            returnVal = 0;
        }
        File file = null;
        if (returnVal == 0) {
            if (SaveAs || this.m_Algorithm.getFilename() == null) {
                file = fc.getSelectedFile();
                sFilename = file.getAbsolutePath();
                this.m_Algorithm.setFilename(sFilename);
            } else {
                sFilename = this.m_Algorithm.getFilename();
                file = new File(sFilename);
            }
            if (fc.getFileFilter() == javaFilter) {
                if (!sFilename.endsWith("java")) {
                    file = new File(sFilename + ".java");
                }
                ModelAlgorithmIO.saveAsJava(this.m_Algorithm, file);
            } else {
                if (!sFilename.endsWith("model")) {
                    file = new File(sFilename + ".model");
                    this.jMenuSave.setEnabled(true);
                }
                this.modelGraphPanel.storeCoords();
                ModelAlgorithmIO.save(this, file);
                this.setHasChanged(false);
                SextanteGUI.updateAlgorithmProvider(ModelerAlgorithmProvider.class);
                SextanteGUI.getGUIFactory().updateToolbox();
            }
        }
    }

    protected void openModel() {
        JFileChooser fc = new JFileChooser();
        ModelFileFilter filter = new ModelFileFilter();
        String sFolder = SextanteGUI.getSettingParameterValue("ModelsFolder");
        fc.setFileFilter(filter);
        fc.setCurrentDirectory(new File(sFolder));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.newModel();
                this.m_Algorithm = ModelAlgorithmIO.open(file, this);
                this.extensionsPanel.setAlgorithm(this.m_Algorithm);
                this.extensionsPanel.setAlgorithmCount(this.m_Algorithm.getAlgorithms().size() + 1);
                this.jTextFieldName.setText(this.m_Algorithm.getName());
                this.updatePanel(false);
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
                return;
            }
        }
        this.setHasChanged(false);
    }

    protected void checkChangesAndCreateNewModel() {
        if (this.m_bHasChanged) {
            int iRet = JOptionPane.showConfirmDialog(null, Sextante.getText((String)"Model_has_been_modified") + "\n" + Sextante.getText((String)"Do_you_want_to_start_a_new_model_without_saving_changes?"), Sextante.getText((String)"Warning"), 1);
            if (iRet == 0) {
                this.newModel();
            }
        } else {
            this.newModel();
        }
    }

    public void updatePanel(boolean bUpdateCoords) {
        this.updateGraphicalDescription(bUpdateCoords);
    }

    private void updateGraphicalDescription(boolean bUpdateCoords) {
        if (bUpdateCoords) {
            this.modelGraphPanel.storeCoords();
        }
        this.modelGraphPanel.updateGraph();
    }

    private void newModel() {
        this.m_bHasChanged = false;
        this.m_Algorithm = new ModelAlgorithm();
        this.m_Algorithm.setGroup(Sextante.getText((String)"Models"));
        this.m_DataObjects.clear();
        this.m_InputKeys.clear();
        this.extensionsPanel.setAlgorithm(this.m_Algorithm);
        this.extensionsPanel.setAlgorithmCount(0);
        this.modelGraphPanel.setAlgorithm(this.m_Algorithm);
        this.modelGraphPanel.resetCoords();
        this.jTextFieldName.setText(Sextante.getText((String)"[New_model]"));
        this.jComboBoxGroup.setSelectedItem(Sextante.getText((String)"Models"));
        this.jMenuSave.setEnabled(false);
        this.m_dScale = 1.0;
        this.m_dGridSize = 10.0;
        this.m_bGridEnabled = false;
        this.modelGraphPanel.getGraph().setScale(this.m_dScale);
        this.updatePanel(true);
    }

    private void removeAlgorithm(String sAlgKey) {
        String sKey;
        int i;
        GeoAlgorithm alg = this.m_Algorithm.getAlgorithm(sAlgKey);
        ArrayList<String> toRemove = new ArrayList<String>();
        OutputObjectsSet ooSet = alg.getOutputObjects();
        for (i = 0; i < ooSet.getOutputObjectsCount(); ++i) {
            Output out = ooSet.getOutput(i);
            sKey = out.getName();
            sKey = sKey + sAlgKey;
            this.m_Algorithm.unassign(sKey);
            this.m_Algorithm.getOutputObjects().remove(sKey);
            this.m_DataObjects.remove(sKey);
        }
        Set set = this.m_DataObjects.keySet();
        for (Object obj : set) {
            if (!(obj instanceof String) || !(sKey = (String)obj).startsWith("INNERPARAM") || !sKey.endsWith(sAlgKey)) continue;
            toRemove.add(sKey);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            this.m_DataObjects.remove(toRemove.get(i));
        }
        this.m_Algorithm.removeAlgorithm(sAlgKey);
        this.m_bHasChanged = true;
    }

    private void removeDataObject(String sKey) {
        this.m_Algorithm.removeInput(sKey);
        this.m_DataObjects.remove(sKey);
        this.m_InputKeys.remove(sKey);
        this.m_bHasChanged = true;
    }

    public boolean removeElement(String sKey) {
        Object obj = this.getObjectFromKey(sKey);
        if (obj instanceof GeoAlgorithm) {
            if (this.canRemoveAlgorithm(sKey)) {
                int iRet = JOptionPane.showConfirmDialog(null, Sextante.getText((String)"delete_modeler_node_question"), Sextante.getText((String)"Warning"), 1);
                if (iRet == 0) {
                    this.removeAlgorithm(sKey);
                    this.updatePanel(true);
                    return true;
                }
            } else {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"Other_elements_depend_on_the_selected_one") + ".\n" + Sextante.getText((String)"Remove_them_before_removing_this_one"), Sextante.getText((String)"Warning"), 2);
            }
        } else if (this.canRemoveDataObject(sKey)) {
            int iRet = JOptionPane.showConfirmDialog(null, Sextante.getText((String)"delete_modeler_node_question"), Sextante.getText((String)"Warning"), 1);
            if (iRet == 0) {
                this.removeDataObject(sKey);
                this.updatePanel(true);
                return true;
            }
        } else {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"Other_elements_depend_on_the_selected_one") + ".\n" + Sextante.getText((String)"Remove_them_before_removing_this_one"), Sextante.getText((String)"Warning"), 2);
        }
        return false;
    }

    private boolean canRemoveAlgorithm(String sKey) {
        GeoAlgorithm alg = this.m_Algorithm.getAlgorithm(sKey);
        OutputObjectsSet ooSet = alg.getOutputObjects();
        ooSet = alg.getOutputObjects();
        for (int i = 0; i < ooSet.getOutputObjectsCount(); ++i) {
            Output out = ooSet.getOutput(i);
            String sObjectKey = out.getName() + sKey;
            if (this.canRemoveDataObject(sObjectKey)) continue;
            return false;
        }
        return true;
    }

    private boolean canRemoveDataObject(String sKey) {
        ArrayList algorithmKeys = this.m_Algorithm.getAlgorithmKeys();
        for (int i = 0; i < algorithmKeys.size(); ++i) {
            String sAlgKey = (String)algorithmKeys.get(i);
            HashMap assignments = this.m_Algorithm.getInputAssignments(sAlgKey);
            Set set = assignments.keySet();
            for (String sAssignmentKey : set) {
                Object obj;
                String sAssignment = (String)assignments.get(sAssignmentKey);
                if (sAssignment == null) continue;
                if (sAssignment.equals(sKey)) {
                    return false;
                }
                if (!sAssignment.startsWith("INNERPARAM") || !((obj = ((ObjectAndDescription)this.getDataObjects().get(sAssignment)).getObject()) instanceof ArrayList)) continue;
                ArrayList list = (ArrayList)obj;
                for (int j = 0; j < list.size(); ++j) {
                    String s = (String)list.get(j);
                    if (!s.equals(sKey)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.m_bHasChanged = hasChanged;
        this.jMenuSave.setEnabled(hasChanged);
        this.repaint();
    }

    public Object getObjectFromKey(String sObjectKey) {
        String sKey;
        int i;
        for (i = 0; i < this.m_InputKeys.size(); ++i) {
            sKey = (String)this.m_InputKeys.get(i);
            if (!sKey.equals(sObjectKey)) continue;
            return this.m_DataObjects.get(sKey);
        }
        ArrayList algKeys = this.m_Algorithm.getAlgorithmKeys();
        for (i = 0; i < algKeys.size(); ++i) {
            sKey = (String)algKeys.get(i);
            if (!sKey.equals(sObjectKey)) continue;
            return this.m_Algorithm.getAlgorithm(sKey);
        }
        return null;
    }

    public void addInputToArray(String sKey, Object obj, ArrayList array) {
        if (obj instanceof ArrayList) {
            ArrayList multipleInput = (ArrayList)obj;
            for (int i = 0; i < multipleInput.size(); ++i) {
                sKey = (String)multipleInput.get(i);
                Object input = ((ObjectAndDescription)this.m_DataObjects.get(sKey)).getObject();
                if (input == null) continue;
                this.addInputToArray(sKey, multipleInput.get(i), array);
            }
        } else {
            array.add(sKey);
        }
        this.m_bHasChanged = true;
    }

    private ArrayList getArrayOfSingleInputs(HashMap assignments) {
        ArrayList array = new ArrayList();
        Set set = assignments.keySet();
        for (String sKey : set) {
            String sInput = (String)assignments.get(sKey);
            if (sInput == null) continue;
            if (this.m_DataObjects != null && this.m_DataObjects.get(sInput) != null) {
                Object obj = ((ObjectAndDescription)this.m_DataObjects.get(sInput)).getObject();
                this.addInputToArray(sInput, obj, array);
                continue;
            }
            System.out.println("SEXTANTE: ModelerPanel.java: getArrayOfSingleInputs(): Got NULL object(s).\n");
        }
        return array;
    }

    public ArrayList getDependences(String sKey) {
        ArrayList<String> dependences = new ArrayList<String>();
        GeoAlgorithm alg = this.m_Algorithm.getAlgorithm(sKey);
        HashMap assignments = this.m_Algorithm.getInputAssignments(sKey);
        ArrayList algorithms = this.m_Algorithm.getAlgorithms();
        ArrayList algorithmKeys = this.m_Algorithm.getAlgorithmKeys();
        if (alg == null) {
            return null;
        }
        ArrayList inputs = this.getArrayOfSingleInputs(assignments);
        block0: for (int j = 0; j < inputs.size(); ++j) {
            int i;
            String sInput = (String)inputs.get(j);
            boolean bFoundMatch = false;
            block1: for (i = 0; i < algorithms.size() && !bFoundMatch; ++i) {
                alg = (GeoAlgorithm)algorithms.get(i);
                String sAlgKey = (String)algorithmKeys.get(i);
                OutputObjectsSet ooSet = alg.getOutputObjects();
                for (int k = 0; k < ooSet.getOutputObjectsCount(); ++k) {
                    Output out = ooSet.getOutput(k);
                    String sOutput = out.getName();
                    if (!sInput.equals(sOutput = sOutput + sAlgKey)) continue;
                    bFoundMatch = true;
                    if (dependences.contains(sAlgKey)) continue block1;
                    dependences.add(sAlgKey);
                    continue block1;
                }
            }
            if (bFoundMatch) continue;
            for (i = 0; i < this.m_InputKeys.size() && !bFoundMatch; ++i) {
                String sInputKey = (String)this.m_InputKeys.get(i);
                if (!sInput.equals(sInputKey)) continue;
                bFoundMatch = true;
                if (dependences.contains(sInputKey)) continue block0;
                dependences.add(sInputKey);
                continue block0;
            }
        }
        return dependences;
    }

    public ModelAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public HashMap getDataObjects() {
        return this.m_DataObjects;
    }

    public ArrayList getInputKeys() {
        return this.m_InputKeys;
    }

    public ModelGraphPanel getModelGraphPanel() {
        return this.modelGraphPanel;
    }
}

