/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.r;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoBoolean;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.additionalInfo.AdditionalInfoTable;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.WrongScriptException;
import es.unex.sextante.gui.r.RExecutionException;
import es.unex.sextante.gui.r.RUtils;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.ImageContainer;
import es.unex.sextante.outputs.NullOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

public class RAlgorithm
extends GeoAlgorithm {
    private static final String R_CONSOLE_OUTPUT = "R_CONSOLE_OUTPUT";
    private static final String R_PLOT_OUTPUT = "R_PLOT_OUTPUT";
    private boolean m_bShowConsoleOutput = false;
    private ArrayList<String> m_Commands = new ArrayList();
    private ArrayList<String> m_VerboseCommands = new ArrayList();
    private String m_sDescriptionFile;
    private String m_sChartFilepath = null;
    private boolean m_bShowPlotOutput;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        RUtils.executeR(this);
        if (this.m_bShowConsoleOutput) {
            this.m_OutputObjects.getOutput(R_CONSOLE_OUTPUT).setOutputObject((Object)RUtils.getConsoleOutput());
        }
        if (this.m_bShowPlotOutput) {
            ImageContainer cont = new ImageContainer(this.m_sChartFilepath);
            this.m_OutputObjects.getOutput(R_PLOT_OUTPUT).setOutputObject((Object)cont);
        }
        return !this.m_Task.isCanceled();
    }

    public String[] getFullSetOfRCommands() throws GeoAlgorithmExecutionException {
        String[] importCommands = this.getImportCommands();
        String[] exportCommands = this.getExportCommands();
        String[] customCommands = this.getRCommands();
        String[] allCommands = new String[importCommands.length + customCommands.length + exportCommands.length];
        System.arraycopy(importCommands, 0, allCommands, 0, importCommands.length);
        System.arraycopy(customCommands, 0, allCommands, importCommands.length, customCommands.length);
        System.arraycopy(exportCommands, 0, allCommands, importCommands.length + customCommands.length, exportCommands.length);
        return allCommands;
    }

    private String[] getExportCommands() throws GeoAlgorithmExecutionException {
        ArrayList<String> commands = new ArrayList<String>();
        for (int i = 0; i < this.m_OutputObjects.getOutputObjectsCount(); ++i) {
            FileOutputChannel foc;
            IOutputChannel channel;
            Output out = this.m_OutputObjects.getOutput(i);
            if (out instanceof OutputRasterLayer) {
                channel = this.getOutputChannel(out.getName());
                if (channel instanceof FileOutputChannel) {
                    foc = (FileOutputChannel)channel;
                    String sFilename = foc.getFilename();
                    if (!sFilename.endsWith("tif")) {
                        sFilename = sFilename + ".tif";
                    }
                    foc.setFilename(sFilename);
                    out.setOutputChannel((IOutputChannel)foc);
                    sFilename = sFilename.replace("\\", "/");
                    commands.add("writeGDAL(" + out.getName() + ",\"" + sFilename + "\")");
                    continue;
                }
                if (channel instanceof NullOutputChannel) {
                    String sFilename = SextanteGUI.getOutputFactory().getTempRasterLayerFilename();
                    sFilename = sFilename.replace("\\", "/");
                    commands.add("writeGDAL(" + out.getName() + ",\"" + sFilename + "\")");
                    continue;
                }
                throw new UnsupportedOutputChannelException();
            }
            if (!(out instanceof OutputVectorLayer)) continue;
            channel = this.getOutputChannel(out.getName());
            if (channel instanceof FileOutputChannel) {
                foc = (FileOutputChannel)channel;
                String sFilepath = foc.getFilename();
                if (!sFilepath.endsWith("shp")) {
                    sFilepath = sFilepath + ".shp";
                }
                foc.setFilename(sFilepath);
                out.setOutputChannel((IOutputChannel)foc);
                File file = new File(sFilepath);
                String sFilename = file.getName();
                sFilename = sFilename.substring(0, sFilename.lastIndexOf("."));
                commands.add("writeOGR(" + out.getName() + ",\"" + file.getParent().replace("\\", "/") + "\",\"" + sFilename + "\", driver=\"ESRI Shapefile\")");
                continue;
            }
            if (channel instanceof NullOutputChannel) {
                String sFilepath = SextanteGUI.getOutputFactory().getTempVectorLayerFilename();
                File file = new File(sFilepath);
                String sFilename = file.getName();
                sFilename = sFilename.substring(0, sFilename.lastIndexOf("."));
                commands.add("writeOGR(" + out.getName() + ",\"" + file.getParent().replace("\\", "/") + "\",\"" + sFilename + "\", driver=\"ESRI Shapefile\")");
                continue;
            }
            throw new UnsupportedOutputChannelException();
        }
        if (this.m_bShowPlotOutput) {
            commands.add("dev.off()");
        }
        return commands.toArray(new String[0]);
    }

    private String[] getImportCommands() throws GeoAlgorithmExecutionException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("library(\"rgdal\")");
        commands.add("x=c(" + Double.toString(this.m_AnalysisExtent.getXMin()) + "," + Double.toString(this.m_AnalysisExtent.getXMax()) + ")");
        commands.add("y=c(" + Double.toString(this.m_AnalysisExtent.getYMin()) + "," + Double.toString(this.m_AnalysisExtent.getYMax()) + ")");
        commands.add("xy <- cbind(x,y)");
        commands.add("boundingBox <- SpatialPoints(xy)");
        commands.add("cellsize=" + Double.toString(this.m_AnalysisExtent.getCellSize()));
        for (int i = 0; i < this.m_Parameters.getNumberOfParameters(); ++i) {
            String sFilepath;
            Parameter param = this.m_Parameters.getParameter(i);
            if (param instanceof ParameterRasterLayer) {
                IOutputChannel channel = param.getParameterValueAsVectorLayer().getOutputChannel();
                if (channel instanceof FileOutputChannel) {
                    sFilepath = ((FileOutputChannel)channel).getFilename();
                    if (!sFilepath.toLowerCase().endsWith("asc") && sFilepath.toLowerCase().endsWith("tif")) {
                        throw new RExecutionException(Sextante.getText((String)"unsupported_file_format"));
                    }
                    sFilepath = sFilepath.replace("\\", "/");
                    commands.add(param.getParameterName() + " = " + "readGDAL(\"" + sFilepath + "\"");
                    continue;
                }
                throw new RExecutionException(Sextante.getText((String)"error_non_file_based_input"));
            }
            if (param instanceof ParameterVectorLayer) {
                IOutputChannel channel = param.getParameterValueAsVectorLayer().getOutputChannel();
                if (channel instanceof FileOutputChannel) {
                    sFilepath = ((FileOutputChannel)channel).getFilename();
                    if (!sFilepath.toLowerCase().endsWith("shp")) {
                        throw new RExecutionException(Sextante.getText((String)"unsupported_file_format"));
                    }
                    String sFilename = new File(sFilepath).getName();
                    sFilename = sFilename.substring(0, sFilename.lastIndexOf("."));
                    sFilepath = sFilepath.replace("\\", "/");
                    commands.add(param.getParameterName() + " = " + "readOGR(\"" + sFilepath + "\",layer=\"" + sFilename + "\")");
                    continue;
                }
                throw new RExecutionException(Sextante.getText((String)"error_non_file_based_input"));
            }
            if (param instanceof ParameterTableField) {
                int iField = param.getParameterValueAsInt();
                commands.add(param.getParameterName() + "=" + Integer.toString(iField + 1));
                continue;
            }
            if (param instanceof ParameterNumericalValue) {
                double dValue = param.getParameterValueAsDouble();
                commands.add(param.getParameterName() + "=" + Double.toString(dValue));
                continue;
            }
            if (param instanceof ParameterString) {
                String s = param.getParameterValueAsString();
                commands.add(param.getParameterName() + "=" + s);
                continue;
            }
            if (param instanceof ParameterBoolean) {
                boolean b = param.getParameterValueAsBoolean();
                if (b) {
                    commands.add(param.getParameterName() + "=TRUE");
                    continue;
                }
                commands.add(param.getParameterName() + "=FALSE");
                continue;
            }
            if (!(param instanceof ParameterMultipleInput)) continue;
            ArrayList list = (ArrayList)param.getParameterValueAsObject();
            for (int j = 0; j < list.size(); ++j) {
                String sFilepath2;
                IOutputChannel channel;
                ILayer layer = (ILayer)list.get(j);
                if (layer instanceof IRasterLayer) {
                    channel = layer.getOutputChannel();
                    if (channel instanceof FileOutputChannel) {
                        sFilepath2 = ((FileOutputChannel)channel).getFilename();
                        if (!sFilepath2.toLowerCase().endsWith("asc") && sFilepath2.toLowerCase().endsWith("tif")) {
                            throw new RExecutionException(Sextante.getText((String)"unsupported_file_format"));
                        }
                        sFilepath2 = sFilepath2.replace("\\", "/");
                        commands.add("tempvar" + Integer.toString(j) + " = " + "readGDAL(\"" + sFilepath2 + "\"");
                        continue;
                    }
                    throw new RExecutionException(Sextante.getText((String)"error_non_file_based_input"));
                }
                if (!(layer instanceof IVectorLayer)) continue;
                channel = layer.getOutputChannel();
                if (channel instanceof FileOutputChannel) {
                    sFilepath2 = ((FileOutputChannel)channel).getFilename();
                    if (!sFilepath2.toLowerCase().endsWith("shp")) {
                        throw new RExecutionException(Sextante.getText((String)"unsupported_file_format"));
                    }
                    String sFilename = new File(sFilepath2).getName();
                    sFilename = sFilename.substring(0, sFilename.lastIndexOf("."));
                    sFilepath2 = sFilepath2.replace("\\", "/");
                    commands.add("tempvar" + Integer.toString(j) + " = " + "readOGR(\"" + sFilepath2 + "\",layer=\"" + sFilename + "\")");
                    continue;
                }
                throw new RExecutionException(Sextante.getText((String)"error_non_file_based_input"));
            }
            StringBuffer sb = new StringBuffer();
            sb.append(param.getParameterName());
            sb.append(" = c(");
            for (int j = 0; j < list.size(); ++j) {
                if (j != 0) {
                    sb.append(",");
                }
                sb.append("tempvar" + Integer.toString(j));
            }
            sb.append(")\n");
        }
        if (this.m_bShowPlotOutput) {
            this.m_sChartFilepath = this.m_OutputFactory.getTempFilenameWithoutExtension() + ".png";
            this.m_sChartFilepath = this.m_sChartFilepath.replace("\\", "/");
            commands.add("png(\"" + this.m_sChartFilepath + "\")");
        }
        return commands.toArray(new String[0]);
    }

    private String[] getRCommands() {
        return this.m_Commands.toArray(new String[0]);
    }

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(false);
    }

    public void initialize(String sDescriptionFile) throws WrongScriptException {
        String sFolder = RUtils.getScriptsFolder();
        this.m_sDescriptionFile = sFolder + File.separator + sDescriptionFile;
        this.setName(sDescriptionFile.substring(0, sDescriptionFile.lastIndexOf(".")).replace("_", " "));
        this.setGroup("R-Scripts");
        this.setIsDeterminatedProcess(false);
        this.setUserCanDefineAnalysisExtent(true);
        this.defineCharacteristicsFromDescriptionFile();
    }

    private void defineCharacteristicsFromDescriptionFile() throws WrongScriptException {
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.m_sDescriptionFile));
            String sLine = input.readLine().trim();
            while (sLine != null) {
                if (sLine.startsWith("//")) {
                    this.processParameterLine(sLine);
                } else if (sLine.startsWith(">")) {
                    sLine = sLine.substring(1);
                    this.m_Commands.add(sLine.trim());
                    this.m_VerboseCommands.add(sLine.trim());
                    if (!this.m_bShowConsoleOutput) {
                        this.addOutputText(R_CONSOLE_OUTPUT, "R Output");
                    }
                    this.m_bShowConsoleOutput = true;
                } else {
                    this.m_Commands.add(sLine.trim());
                }
                sLine = input.readLine();
            }
            input.close();
        }
        catch (Exception e) {
            throw new WrongScriptException(e.getMessage());
        }
    }

    private void processParameterLine(String sLine) throws WrongScriptException {
        ParameterRasterLayer param = null;
        OutputRasterLayer out = null;
        AdditionalInfoRasterLayer additionalInfo = null;
        if ((sLine = sLine.replace("/", "")).toLowerCase().equals("showplots")) {
            this.m_bShowPlotOutput = true;
            this.addOutputImage(R_PLOT_OUTPUT, "R Plots");
            return;
        }
        String[] sTokens = sLine.split("=");
        if (sTokens[1].toLowerCase().equals("raster")) {
            param = new ParameterRasterLayer();
            additionalInfo = new AdditionalInfoRasterLayer(true);
        } else if (sTokens[1].toLowerCase().equals("vector")) {
            param = new ParameterVectorLayer();
            additionalInfo = new AdditionalInfoVectorLayer(-1, true);
        } else if (sTokens[1].toLowerCase().equals("table")) {
            param = new ParameterTable();
            additionalInfo = new AdditionalInfoTable(true);
        } else if (sTokens[1].toLowerCase().equals("multiple raster")) {
            param = new ParameterMultipleInput();
            additionalInfo = new AdditionalInfoMultipleInput(1, true);
        } else if (sTokens[1].toLowerCase().equals("multiple vector")) {
            param = new ParameterMultipleInput();
            additionalInfo = new AdditionalInfoMultipleInput(5, true);
        } else if (sTokens[1].toLowerCase().equals("boolean")) {
            param = new ParameterBoolean();
            additionalInfo = new AdditionalInfoBoolean(true);
        } else if (sTokens[1].toLowerCase().startsWith("field")) {
            param = new ParameterTableField();
            String parent = sTokens[1].substring("field".length()).trim();
            additionalInfo = new AdditionalInfoTableField(parent, true);
        } else if (sTokens[1].toLowerCase().equals("number")) {
            param = new ParameterNumericalValue();
            additionalInfo = new AdditionalInfoNumericalValue(2, 0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
        } else if (sTokens[1].toLowerCase().equals("string")) {
            param = new ParameterString();
            additionalInfo = new AdditionalInfoString();
        } else if (sTokens[1].toLowerCase().equals("output raster")) {
            out = new OutputRasterLayer();
        } else if (sTokens[1].toLowerCase().equals("output vector")) {
            out = new OutputVectorLayer();
        } else if (sTokens[1].toLowerCase().equals("output table")) {
            out = new OutputTable();
        } else if (sTokens[1].toLowerCase().equals("group")) {
            this.setGroup(sTokens[0]);
            return;
        }
        if (param != null) {
            param.setParameterName(sTokens[0]);
            param.setParameterDescription(sTokens[0]);
            param.setParameterAdditionalInfo((AdditionalInfo)additionalInfo);
            try {
                this.m_Parameters.addParameter((Parameter)param);
            }
            catch (RepeatedParameterNameException e) {
                throw new WrongScriptException(e.getMessage());
            }
        } else if (out != null) {
            out.setDescription(sTokens[0]);
            out.setName(sTokens[0]);
            this.m_OutputObjects.add(out);
        } else {
            throw new WrongScriptException();
        }
    }

    public GeoAlgorithm getNewInstance() throws InstantiationException, IllegalAccessException {
        RAlgorithm alg = (RAlgorithm)((Object)((Object)((Object)this)).getClass().newInstance());
        alg.setOutputObjects(this.m_OutputObjects.getNewInstance());
        alg.setName(this.getName());
        alg.setGroup(this.getGroup());
        alg.setParameters(this.m_Parameters.getNewInstance());
        alg.setIsDeterminatedProcess(false);
        alg.setUserCanDefineAnalysisExtent(this.getUserCanDefineAnalysisExtent());
        alg.m_Commands = (ArrayList)this.m_Commands.clone();
        alg.m_VerboseCommands = (ArrayList)this.m_VerboseCommands.clone();
        alg.m_bShowConsoleOutput = this.m_bShowConsoleOutput;
        alg.m_bShowPlotOutput = this.m_bShowPlotOutput;
        return alg;
    }

    public String getCommandLineName() {
        String sName = "r:" + this.getName().toLowerCase().replace(" ", "");
        return sName;
    }

    public ArrayList<String> getVerboseCommands() {
        return this.m_VerboseCommands;
    }

    public String getFilename() {
        return this.m_sDescriptionFile;
    }
}

